<?php
if (!defined("ABSPATH")) {
    exit();
}

add_action('activated_plugin', 'geoflex_deactivate_other_version');
add_action('admin_notices', 'geoflex_plugin_deactivated_notice');

/**
 * Checks if another version of Geoflex(free or Pro) is already activated and deactivates it.
 *
 * @param string $plugin The plugin being activated.
 */
function geoflex_deactivate_other_version($plugin) {
    if (!in_array($plugin, ['geoflex/geoflex.php', 'geoflex-pro/geoflex.php'], true)) {
        return;
    }

    $deactivated_plugin  = 'geoflex/geoflex.php';
    $deactivated_type = '1';

    if ($plugin === $deactivated_plugin) {
        $deactivated_plugin  = 'geoflex-pro/geoflex.php';
        $deactivated_type = '2';
    }

    if (is_multisite() && is_network_admin()) {
        $active_plugins = (array) get_site_option('active_sitewide_plugins', []);
        $active_plugins = array_keys($active_plugins);
    } else {
        $active_plugins = (array) get_option('active_plugins', []);
    }

    foreach ($active_plugins as $plugin_basename) {
        if ($deactivated_plugin === $plugin_basename) {
            set_transient('geoflex_deactivated_type', $deactivated_type, 1 * HOUR_IN_SECONDS);
            deactivate_plugins($plugin_basename);
            return;
        }
    }
}

// Displays a notice when Geoflex or Geoflex Pro is automatically deactivated.
function geoflex_plugin_deactivated_notice() {
    $deactivated_type = (int) get_transient('geoflex_deactivated_type');
    if (!in_array($deactivated_type, [1, 2], true)) {
        return;
    }

    $message = esc_html__("Geoflex and Geoflex Pro should not be active at the same time. We've automatically deactivated Geoflex.", 'geoflex');
    if (2 === $deactivated_type) {
        $message = esc_html__("Geoflex and Geoflex Pro should not be active at the same time. We've automatically deactivated Geoflex Pro.", 'geoflex');
    }

    ?>
    <div class="updated" style="border-left: 4px solid #ffba00;">
        <p><?php echo esc_html($message); ?></p>
    </div>
    <?php

    delete_transient('geoflex_deactivated_type');
}