<?php

namespace GeoFlex\Utils;

if (!defined("ABSPATH")) {
    exit();
}

class Helpers
{
    /**
     * get_meta_key
     *
     * Get meta key by id
     *
     * @param string $id
     * @param  mixed $underscore
     * @return string
     */
    public static function get_meta_key(string $id, bool $underscore = true)
    {
        if (empty($id)) {
            return false;
        }
        
        $prefix = $underscore ? "_" : "";
        return $prefix . "geoflex_" . $id;
    }

    /**
     * get_settings
     * 
     * Get plugin settings
     *
     * @return array
     */
    public static function get_settings()
    {
        return get_option("geoflex") ?: ["type" => "path"];
    }
}