<?php

namespace GeoFlex\Cache;

if (!defined("ABSPATH")) {
    exit();
}

use GeoFlex\Plugin;
use GeoFlex\Utils\Helpers;

class Regions
{
    /**
     * __construct
     *
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
        add_action("save_post", [$this, "clean_cache"]);
    }
    
    /**
     * get_regions
     *
     * Gel all regions
     * 
     * @return array
     */
    public static function get_regions()
    {
        if (false === $regions = get_transient("geoflex_list")) {
            $default_post = false;
            $default = Plugin::get_default_region();

            $args = [
                "post_type" => GEOFLEX_POST_TYPE,
                "posts_per_page" => -1,
            ];

            if ($default) {
                $default_post = get_post($default);
                $args["exclude"] = [$default];
            }

            $posts = get_posts($args) ?? [];

            if (!empty($default_post) && is_array($posts)) {
                array_unshift($posts, $default_post);
            }
            
            $regions = [];
            foreach ($posts as $region) {
                $regions[$region->ID] = (object) [
                    "name"      => $region->post_title,
                    "slug"      => urldecode(get_post_meta($region->ID, Helpers::get_meta_key("slug"), true)),
                    "default"   => get_post_meta($region->ID, Helpers::get_meta_key("default"), true),
                ];
            }
            set_transient("geoflex_list", $regions, 10 * MINUTE_IN_SECONDS);
        }
        return $regions;
    }

    /**
     * clean_cache
     *
     * Clean cache
     *
     * @param  int $post_id
     * @return void
     */
    public function clean_cache(int $post_id)
    {
        if (get_post_type($post_id) === GEOFLEX_POST_TYPE) {
            delete_transient("geoflex_list");
        }        
    }
}