<?php

namespace GeoFlex\Admin;

if (!defined("ABSPATH")) {
    exit();
}

use GeoFlex\Utils;

class Support
{

    /**
     * __construct
     *
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
        add_action("admin_menu", function () {
            add_submenu_page("edit.php?post_type=" . GEOFLEX_POST_TYPE, esc_html__("Support", "geoflex"), esc_html__("Support", "geoflex"), "manage_options", "support", [$this, "support_page"]);
        });

    }
    
    /**
     * support_page
     *
     * Render page callback 
     * 
     * @return void
     */
    public function support_page()
    {
        ?>
        <div class="wrap">
            <h1>
                <?php echo esc_html(get_admin_page_title()); ?>
            </h1>
            <p><?php esc_html_e("If you have any questions, need a hand with a technical issue we've got you covered. Get in touch with us and we'll be happy to assist you!", "geoflex"); ?></p>
            <p><?php esc_html_e("Email for support:", "geoflex"); ?> <a href="mailto: wordpress@solbeg.com?subject=WP Regions support">wordpress@solbeg.com</a>
            <h3><?php esc_html_e("General options:", "geoflex"); ?></h3>
            <p><?php echo wp_kses(__('To enable opening the region selection window upon clicking the link, it is necessary to add the <code>rel="region"</code> attribute.', "geoflex"), ['code' => []]); ?></p>
            <p><?php esc_html_e("For correct work of the plugin do not use Permalink structure \"Plain\" (Setting->Permalinks).", "geoflex"); ?></p>
            <h3><?php esc_html_e("Substitution options:", "geoflex"); ?></h3>
            <ul>
                <li><code>{region_name}</code> <?php echo wp_kses(__("the name of the region. For example, <strong>«Warsaw»</strong>.", "geoflex"), ['strong' => []]); ?></li>
                <li><code>{region_in}</code> <?php echo wp_kses(__("in a region. For example, <strong>«In Warsaw»</strong>, <strong>«W Warszawie»</strong>.", "geoflex"), ['strong' => []]); ?></li>
                <li><code>{region_by}</code> <?php echo wp_kses(__("by region. For example, <strong>«By Warsaw»</strong>, <strong>«W Warszawie»</strong>.", "geoflex"), ['strong' => []]); ?></li>
                <li><code>{region_from}</code> <?php echo wp_kses(__("from the region. For example, <strong>«From Warsaw»</strong>, <strong>«Z Warszawy»</strong>.", "geoflex"), ['strong' => []]); ?></li>
                <li><code>{region_phone}</code> <?php esc_html_e("phone number for the region", "geoflex"); ?></li>
                <li><code>{region_address}</code> <?php esc_html_e("address for the region", "geoflex"); ?></li>
                <li><code>{region_email}</code> <?php esc_html_e("email for the region", "geoflex"); ?></li>
                <li><code>{region_link}</code> <?php esc_html_e("link for the region", "geoflex"); ?></li>
            </ul>
            <h3><?php esc_html_e("PHP code replacement example:", "geoflex"); ?></h3>
            <textarea id="example-php" rows="5" cols="30" readonly><?php echo '<?php
global $geoflex_region;
if (!empty($geoflex_region)) {
    esc_html_e($geoflex_region->replace("{region_in}"));
};'; ?></textarea>
            <script>
                document.addEventListener("DOMContentLoaded", () => {
                    wp.codeEditor.initialize(jQuery("#example-php"), '<?php echo wp_json_encode(wp_enqueue_code_editor(["type" => "application/x-httpd-php", "codemirror" => ["readOnly" => true]])); ?>');
                });
            </script>
        </div>
        <?php
    }

}