<?php

namespace GeoFlex\Admin;

if (!defined("ABSPATH")) {
    exit();
}

use GeoFlex\Utils\Helpers;

class Settings
{
    /**
     * __construct
     *
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
        add_action("admin_menu", function () {
            add_submenu_page("edit.php?post_type=" . GEOFLEX_POST_TYPE, esc_html__("GeoFlex settings", "geoflex"), esc_html__("Settings", "geoflex"), "manage_options", "settings", [$this, "setting_page"]);
        });

        register_setting("geoflex_settings_group", "geoflex", [
            "sanitize_callback" => [$this, "sanitize_settings_group"],
            "show_in_rest" => false,
        ]);
    }

    /**
     * setting_page
     *
     * Render settings callback
     *
     * @return void
     */
    public function setting_page()
    {
        if (!current_user_can("manage_options")) {
            return;
        } ?>
        <div class="wrap">
            <h1>
                <?php echo esc_html(get_admin_page_title()); ?>
            </h1>
            <form action="options.php" method="post">
                <?php
                add_settings_section("geoflex_section_settings", esc_html__("General settings", "geoflex"), "", "geoflex_settings_general");

                add_settings_field("geoflex_settings_type", esc_html__("Links type:", "geoflex"), [$this, "setting_type"], "geoflex_settings_general", "geoflex_section_settings");

                settings_fields("geoflex_settings_group");
                do_settings_sections("geoflex_settings_general");
                submit_button();?>
            </form>
        </div>
        <?php
    }

    /**
     * setting_type
     *
     * Settings type render
     *
     * @return void
     */
    function setting_type()
    {
        $options = Helpers::get_settings();
        $types = [
            "domain" => wp_kses(__("Domain <code>region.{home}</code>", "geoflex"), ['code' => []]),
            "path" => wp_kses(__("Path <code>{home}/region</code>", "geoflex"), ['code' => []]),
        ];
        foreach ($types as $key => $value) {
            printf('<p><label><input %s value="%s" name="geoflex[type]" type="radio" /> %s</label></p>', checked($key == $options["type"], true, false), esc_attr($key), wp_kses(str_replace("{home}", wp_parse_url(home_url(), PHP_URL_HOST), $value), ['code' => []]));
        }
    }

    /**
     * sanitize_settings_group
     *
     * Sanitize settings
     *
     * @param mixed $options
     * @return mixed
     */
    public function sanitize_settings_group($options)
    {
        foreach ($options as $name => &$val) {
            switch ($name) {
                case "type":
                    $val = sanitize_text_field($val);
                    break;
            }
        }

        return $options;
    }
}
