<?php

namespace GeoFlex\Admin;

if (!defined("ABSPATH")) {
    exit();
}

class Notices
{
    private static $notices = [];

    /**
     * __construct
     *
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
        add_action("admin_notices", [$this, "show_notices"]);
        add_action("shutdown", [$this, "save_notices"]);
    }
    
    /**
     * add_notice
     *
     * Add notice
     * 
     * @param  array $notice
     * @return void
     */
    public static function add_notice(array $notice)
    {
        self::$notices[] = $notice;
    }
    
    /**
     * save_notices
     *
     * Save notices
     * 
     * @return void
     */
    public function save_notices()
    {
        update_option("geoflex_notices", self::$notices);
    }
    
    /**
     * show_notices
     *
     * Show notices
     * 
     * @return void
     */
    public function show_notices()
    {
        $notices = get_option("geoflex_notices");
        if (!empty($notices)) {
            foreach ($notices as $notice) {
                if (isset($notice["status"]) && !in_array($notice["status"], ["info", "success", "warning", "error"], true)) {
                    $notice["status"] = null;
                }
                $class = $notice["status"] ? "notice-" . esc_attr($notice["status"]) : "";
                printf('<div class="notice %s is-dismissible"><p>%s</p></div>', esc_attr($class), esc_html($notice["text"]));
            }
            delete_option("geoflex_notices");
        }
    }
}
