<?php

/**
 * Plugin Name:       Geoflex
 * Description:       Adds multiregional capability to WordPress
 * Version:           1.10
 * Requires at least: 6.0
 * Requires PHP:      7.4
 * Author:            Solbeg
 * Author URI:        https://solbeg.com
 * Text Domain:       geoflex
 * Domain Path:       /languages
 * License:           GPL v3 or later
 * License URI:       https://www.gnu.org/licenses/gpl-3.0.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

use GeoFlex\Plugin;

if (!defined("ABSPATH")) {
    exit();
}

if (!class_exists("\GeoFlex\Plugin")) {
    define("GEOFLEX_VER", get_file_data(__FILE__, ["ver" => "Version"], "plugin")["ver"]);
    defined("GEOFLEX_POST_TYPE") or define("GEOFLEX_POST_TYPE", "geoflex");
    define("GEOFLEX_URL", plugin_dir_url(__FILE__));
    define("GEOFLEX_DIR", plugin_dir_path(__FILE__));

    require_once GEOFLEX_DIR . "version-check.php";

    require_once GEOFLEX_DIR . "vendor/autoload.php";

    add_action("init", function () {
        load_plugin_textdomain("geoflex", false, dirname(plugin_basename(__FILE__)) . "/languages");
        new Plugin();
    }, 5);
}