<?php
/**
 *
 * Yoast SEO extension
 *
 */

if (!defined("ABSPATH")) {
    exit();
}

add_action("geoflex_filters", function ($region) {
    
    // Add new replacements
    add_filter("wpseo_replacements", function ($replacements) use ($region) {
        $replacements = array_merge($replacements, $region->get_replaces());
        return $replacements;
    });

    // Title filter
    add_filter("wpseo_title", [$region, "replace_strip_tags"]);

    // Description filter
    add_filter("wpseo_metadesc", [$region, "replace_strip_tags"]);

    // Opengraph title filter
    add_filter("wpseo_opengraph_title", [$region, "replace_strip_tags"]);

    // Opengraph description filter
    add_filter("wpseo_opengraph_desc", [$region, "replace_strip_tags"]);

    // Opengraph url filter
    add_filter("wpseo_opengraph_url", [$region, "replace_strip_tags"]);

    // Opengraph article:publisher
    add_filter("wpseo_og_article_publisher", [$region, "replace_strip_tags"]);

    // Opengraph og:site_name
    add_filter("wpseo_opengraph_site_name", [$region, "replace_strip_tags"]);

    // Twitter title
    add_filter("wpseo_twitter_title", [$region, "replace_strip_tags"]);

    // Twitter description
    add_filter("wpseo_twitter_description", [$region, "replace_strip_tags"]);

    // Prevent use indexables
    add_filter("Yoast\WP\SEO\should_index_indexables", "__return_false");

    // Schema.org output
    add_filter("wpseo_schema_graph", function ($data) use ($region) {
        if (!$region) {
            return $data;
        }
        return json_decode($region->replace_strip_tags(wp_json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)), JSON_OBJECT_AS_ARRAY);
    });

    // Breadcrumbs
    add_filter("wpseo_breadcrumb_links", function ($crumbs) use ($region) {
        if (is_array($crumbs) && !empty($crumbs)) {
            foreach ($crumbs as &$crumb) {
                $crumb["text"] = $region->replace_strip_tags($crumb["text"]);
            }
        }
        return $crumbs;
    });

    // Sitemap (only for path)
    if ($region->get_options()["type"] === "path") {
        $domain = wp_parse_url($region->get_home(), PHP_URL_HOST);
        add_filter("wpseo_sitemap_url", function ($link) use ($region, $domain) {
            $output = $link;
            foreach ($region->get_regions() as $item) {
                $output .= $item->default ? null : str_replace($domain, $domain . "/" . $item->slug, $link);
            }
            return $output;
        });
    }
});
