<?php
/**
 *
 * Wordpress Sitemap extension
 *
 */

if (!defined("ABSPATH")) {
    exit();
}

if (class_exists("WP_Sitemaps_Posts")) {
    class WP_Sitemaps_Region extends \WP_Sitemaps_Posts
    {
        private $slug;
        private $region;

        public function __construct($name, $region, $slug)
        {
            $this->region = $region;
            $this->slug = $slug;
            $this->name = $name;
        }

        public function get_url_list($page_num, $object_subtype = "")
        {
            $posts_sitemap = new \WP_Sitemaps_Posts();
            $url_list = $posts_sitemap->get_url_list($page_num, $object_subtype);

            foreach ($url_list as &$item) {
                $item["loc"] = $this->region->replace_url($item["loc"], $this->slug);
            }

            return $url_list;
        }
    }

    add_action("geoflex_filters", function ($region) {
        if ($region->get_options()["type"] === "path") {
            foreach ($region->get_regions() as $item) {
                if (empty(preg_replace("/[^0-9]/", "", $item->slug))) {
                    $name = preg_replace("/-/", "", $item->slug);
                    wp_register_sitemap_provider($name, new WP_Sitemaps_Region($name, $region, $item->slug));
                }
            }
        }
    });
}
