<?php
/**
 *
 * SEOPress extension
 *
 */

if (!defined("ABSPATH")) {
    exit();
}

add_action("geoflex_filters", function ($region) {
    // Title filter
    add_filter("seopress_titles_title", [$region, "replace_strip_tags"]);

    // Description filter
    add_filter("seopress_titles_desc", [$region, "replace_strip_tags"]);

    // Site name
    add_filter("seopress_social_og_site_name", [$region, "replace_strip_tags"]);

    // Opengraph
    add_filter("seopress_social_og_title", [$region, "replace_strip_tags"]);
    add_filter("seopress_social_og_desc", [$region, "replace_strip_tags"]);

    // Twitter card
    add_filter("seopress_social_twitter_card_title", [$region, "replace_strip_tags"]);
    add_filter("seopress_social_twitter_card_desc", [$region, "replace_strip_tags"]);
    add_filter("seopress_social_twitter_card_site", [$region, "replace_strip_tags"]);
    add_filter("seopress_social_twitter_card_creator", [$region, "replace_strip_tags"]);

    // Schema.org output
    add_filter("seopress_schemas_website", function ($data) use ($region) {
        if (!$region) {
            return $data;
        }

        return json_decode($region->replace_strip_tags(wp_json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)), JSON_OBJECT_AS_ARRAY);
    }, 50);
});