<?php
/**
 *
 * Rank Math SEO extension
 *
 */

if (!defined("ABSPATH")) {
    exit();
}

add_action("geoflex_filters", function ($region) {
    
    // Title filter
    add_filter("rank_math/frontend/title", [$region, "replace_strip_tags"]);

    // Description filter
    add_filter("rank_math/frontend/description", [$region, "replace_strip_tags"]);

    // Schema.org output
    add_filter("rank_math/json_ld", function ($data) use ($region) {
        if (!$region) {
            return $data;
        }

        return json_decode($region->replace_strip_tags(wp_json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)), JSON_OBJECT_AS_ARRAY);
    }, 50);
});