<?php
/**
 *
 * All in One SEO extension
 *
 */

if (!defined("ABSPATH")) {
    exit();
}

add_action("geoflex_filters", function ($region) {

    // Title filter
    add_filter("aioseo_title", [$region, "replace_strip_tags"]);

    // Description filter
    add_filter("aioseo_description", [$region, "replace_strip_tags"]);

    // Facebook tags
    add_filter("aioseo_facebook_tags", function ($meta) use ($region) {
        if (!$region) {
            return $meta;
        }
        
        if (is_array($meta)) {
            foreach ($meta as $key => $value) {
                if (is_string($value) || is_array($value)) {
                    $meta[$key] = $region->replace_strip_tags($value);
                }
            }
        }

        return $meta;
    });

    // Schema.org output
    add_filter("aioseo_schema_output", function ($data) use ($region) {
        if (!$region) {
            return $data;
        }

        return json_decode($region->replace_strip_tags(wp_json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE)), JSON_OBJECT_AS_ARRAY);
    }, 50);

    // Sitemap (only for path)
    if ($region->get_options()["type"] === "path") {
        $domain = wp_parse_url($region->get_home(), PHP_URL_HOST);
        $replace = function ($links) use ($region, $domain) {
            $new_links = [];
            foreach ($links as $link) {
                foreach ($region->get_regions() as $item) {
                    $new_links[] = str_replace($domain, $domain . "/" . $item->slug, $link);
                }
            }
            return array_merge($links, $new_links);
        };
        add_filter("aioseo_sitemap_posts", $replace);
        add_filter("aioseo_sitemap_terms", $replace);
    }
});