<?php
/**
 * Plugin Name: GeoBuddy
 * Description: A simple plugin with GeoDirectory custom fields and settings
 * Requires Plugins: geodirectory
 * Version: 1.0.4
 * Author: BuddyDevelopers
 * Author URI: https://buddydevelopers.com
 * Text Domain: geobuddy
 * Domain Path: /languages
 * Requires at least: 5.0
 * Requires PHP: 7.2
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * @package Geobuddy
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Define plugin constants.
define( 'BD_GEOBUDDY_VERSION', '1.0.4' );
define( 'BD_GEOBUDDY_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'BD_GEOBUDDY_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// Include the main plugin class.
require_once BD_GEOBUDDY_PLUGIN_DIR . 'class-geobuddy-plugin.php';
require_once __DIR__ . '/vendor/autoload.php';

// Initialize the plugin.
new BD_GEOBUDDY_Plugin(); 

// Freemius SDK integration.
if ( ! function_exists( 'geobuddy_fs' ) ) {
    // Create a helper function for easy SDK access.
    function geobuddy_fs() {
        global $geobuddy_fs;

        if ( ! isset( $geobuddy_fs ) ) {
            // Include Freemius SDK.
            // SDK is auto-loaded through Composer

            $geobuddy_fs = fs_dynamic_init( array(
                'id'                  => '17588',
                'slug'                => 'geobuddy',
                'premium_slug'        => 'geobuddy-pro',
                'type'                => 'plugin',
                'public_key'          => 'pk_ef77760e0a4dc010bf37a5f8a507e',
                'is_premium'          => false,
                'premium_suffix'      => '',
                // If your plugin is a serviceware, set this option to false.
                'has_premium_version' => false,
                'has_addons'          => true,
                'has_paid_plans'      => false,
                // Automatically removed in the free version. If you're not using the
                // auto-generated free version, delete this line before uploading to wp.org.
                'menu'                => array(
                    'slug'           => 'geobuddy',
                    'first-path'     => 'admin.php?page=geobuddy',
                    'support'        => false,
                ),
            ) );
        }

        return $geobuddy_fs;
    }

    // Init Freemius.
    geobuddy_fs();
    // Signal that SDK was initiated.
    do_action( 'geobuddy_fs_loaded' );
}