<?php
/**
 * Main plugin class file
 *
 * @package    Geobuddy
 * @subpackage Geobuddy/includes
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Check if class already exists.
if ( ! class_exists( 'BD_GEOBUDDY_Plugin' ) ) :

	/**
	 * Main plugin class
	 */
	class BD_GEOBUDDY_Plugin {

		/**
		 * Initialize the plugin
		 */
		public function __construct() {
			$this->load_dependencies();
			add_action( 'plugins_loaded', array( $this, 'init' ) );
		}

		/**
		 * Load required files
		 */
		private function load_dependencies() {
			require_once BD_GEOBUDDY_PLUGIN_DIR . 'admin/class-admin.php';
			require_once BD_GEOBUDDY_PLUGIN_DIR . 'includes/class-custom-fields.php';
		}

		/**
		 * Initialize plugin components
		 */
		public function init() {
			// Check if GeoDirectory is active.
			if ( ! class_exists( 'GeoDirectory' ) ) {
				add_action( 'admin_notices', array( $this, 'geodirectory_missing_notice' ) );
				return;
			}

			// Initialize components.
			new BD_GEOBUDDY_Admin();
			new BD_GEOBUDDY_Custom_Fields();
		}

		/**
		 * Display admin notice if GeoDirectory is not active
		 */
		public function geodirectory_missing_notice() {
			echo '<div class="error"><p>' . 
				esc_html__( 'GeoBuddy requires GeoDirectory plugin to be installed and activated.', 'geobuddy' ) . 
				'</p></div>';
		}
	}

endif; 