<?php
/**
 * Welcome page view
 *
 * @package    Geobuddy
 * @subpackage Geobuddy/admin/views
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

	<!-- Hero Introduction Section -->
	<div class="geobuddy-hero-section">
		<div class="geobuddy-hero-content">
			<h2 class="geobuddy-hero-title"><?php esc_html_e( 'Welcome to GeoBuddy', 'geobuddy' ); ?></h2>
			<p class="geobuddy-hero-description">
				<?php esc_html_e( 'GeoBuddy is your comprehensive addon platform for GeoDirectory, designed to extend and enhance your directory website with powerful features and functionality. Built by BuddyDevelopers, GeoBuddy serves as the foundation for a growing ecosystem of specialized addons that help you create, manage, and optimize your business directory website with ease.', 'geobuddy' ); ?>
			</p>
			<div class="geobuddy-addons-showcase">
				<h3 class="geobuddy-addons-title"><?php esc_html_e( 'Available Addons', 'geobuddy' ); ?></h3>
				<div class="geobuddy-addons-grid">
					<div class="geobuddy-addon-item">
						<span class="dashicons dashicons-forms"></span>
						<span><?php esc_html_e( 'Multistep Form', 'geobuddy' ); ?></span>
					</div>
					<div class="geobuddy-addon-item">
						<span class="dashicons dashicons-email-alt"></span>
						<span><?php esc_html_e( 'Private Message', 'geobuddy' ); ?></span>
					</div>
					<div class="geobuddy-addon-item">
						<span class="dashicons dashicons-star-filled"></span>
						<span><?php esc_html_e( 'Confetti', 'geobuddy' ); ?></span>
					</div>
					<div class="geobuddy-addon-item">
						<span class="dashicons dashicons-megaphone"></span>
						<span><?php esc_html_e( 'Announcement Bar', 'geobuddy' ); ?></span>
					</div>
					<div class="geobuddy-addon-item">
						<span class="dashicons dashicons-cloud"></span>
						<span><?php esc_html_e( 'Weather Forecast', 'geobuddy' ); ?></span>
					</div>
					<div class="geobuddy-addon-item">
						<span class="dashicons dashicons-rss"></span>
						<span><?php esc_html_e( 'Broadcasting', 'geobuddy' ); ?></span>
					</div>
				</div>
				<p class="geobuddy-phase-notice">
					<strong><?php esc_html_e( 'Coming Soon:', 'geobuddy' ); ?></strong> 
					<?php esc_html_e( 'GeoBuddy Site builder addon is coming soon, bringing you one-click template imports and professional directory designs and AI support.', 'geobuddy' ); ?>
				</p>
			</div>
		</div>
	</div>

	<div class="geobuddy-welcome-content">
		<h2 class="geobuddy-welcome-title"><?php esc_html_e( 'Get Started', 'geobuddy' ); ?></h2>

		<div class="geobuddy-welcome-cards">
			<!-- Documentation Card -->
			<div class="geobuddy-card">
				<div class="geobuddy-card-icon">
					<span class="dashicons dashicons-book"></span>
				</div>
				<div class="geobuddy-card-content">
					<h3><?php esc_html_e( 'Comprehensive Documentation', 'geobuddy' ); ?></h3>
					<p><?php esc_html_e( 'Access our extensive knowledge base with step-by-step tutorials, video guides, and detailed documentation. Learn how to install and configure GeoBuddy addons, customize settings, and unlock the full potential of each addon. Perfect for beginners and advanced users alike.', 'geobuddy' ); ?></p>
					<a href="https://wpgeobuddy.com/docs" target="_blank" class="geobuddy-button geobuddy-button-primary"><?php esc_html_e( 'View Documentation', 'geobuddy' ); ?></a>
				</div>
			</div>

			<!-- Contribute Card -->
			<div class="geobuddy-card">
				<div class="geobuddy-card-icon">
					<span class="dashicons dashicons-groups"></span>
				</div>
				<div class="geobuddy-card-content">
					<h3><?php esc_html_e( 'Contribute & Improve', 'geobuddy' ); ?></h3>
					<p><?php esc_html_e( 'Your feedback drives innovation! Help us make GeoBuddy even better by reporting bugs, suggesting new features, or sharing your ideas. Join thousands of users who are actively contributing to make GeoBuddy the best directory solution for WordPress. Every contribution matters!', 'geobuddy' ); ?></p>
					<a href="https://github.com/buddydevelopers/geobuddy/issues" target="_blank" class="geobuddy-button geobuddy-button-primary"><?php esc_html_e( 'Report Issue', 'geobuddy' ); ?></a>
				</div>
			</div>

			<!-- Need Help Card -->
			<div class="geobuddy-card">
				<div class="geobuddy-card-icon">
					<span class="dashicons dashicons-sos"></span>
				</div>
				<div class="geobuddy-card-content">
					<h3><?php esc_html_e( 'Expert Support', 'geobuddy' ); ?></h3>
					<p><?php esc_html_e( 'Get personalized assistance from our dedicated support team. Whether you need help with setup, customization, or troubleshooting, we\'re here to ensure your success. Premium users enjoy priority support with faster response times and in-depth technical assistance.', 'geobuddy' ); ?></p>
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=geobuddy-contact' ) ); ?>" target="_blank" class="geobuddy-button geobuddy-button-primary"><?php esc_html_e( 'Get Support', 'geobuddy' ); ?></a>
				</div>
			</div>

			<!-- Community Card -->
			<div class="geobuddy-card">
				<div class="geobuddy-card-icon">
					<span class="dashicons dashicons-format-chat"></span>
				</div>
				<div class="geobuddy-card-content">
					<h3><?php esc_html_e( 'Join Our Community', 'geobuddy' ); ?></h3>
					<p><?php esc_html_e( 'Connect with a vibrant community of GeoBuddy users, developers, and directory website creators. Share your projects, exchange tips and tricks, get inspired by others\' work, and stay updated with the latest features and best practices. Together, we\'re building amazing directory websites!', 'geobuddy' ); ?></p>
					<a href="https://www.facebook.com/groups/170345126924558" target="_blank" class="geobuddy-button geobuddy-button-primary"><?php esc_html_e( 'Join Community', 'geobuddy' ); ?></a>
				</div>
			</div>
		</div>
	</div>

	<!-- BuddyDevelopers Promotion Section -->
	<div class="geobuddy-buddydevelopers-section">
		<div class="geobuddy-bd-content">
			<div class="geobuddy-bd-logo">
				<h3><?php esc_html_e( 'Powered by BuddyDevelopers', 'geobuddy' ); ?></h3>
			</div>
			<div class="geobuddy-bd-description">
				<p><?php esc_html_e( 'GeoBuddy is proudly developed by BuddyDevelopers, a team of passionate WordPress developers dedicated to creating powerful, user-friendly addons for the GeoDirectory ecosystem. We specialize in building modular solutions that extend GeoDirectory functionality, making it easier to create feature-rich directory websites.', 'geobuddy' ); ?></p>
			</div>
			<div class="geobuddy-bd-features">
				<div class="geobuddy-bd-feature">
					<span class="dashicons dashicons-admin-plugins"></span>
					<h4><?php esc_html_e( 'Premium Plugins', 'geobuddy' ); ?></h4>
					<p><?php esc_html_e( 'Explore our collection of premium GeoDirectory addons and extensions.', 'geobuddy' ); ?></p>
				</div>
				<div class="geobuddy-bd-feature">
					<span class="dashicons dashicons-admin-customizer"></span>
					<h4><?php esc_html_e( 'Custom Development', 'geobuddy' ); ?></h4>
					<p><?php esc_html_e( 'Need something custom? We offer professional development services.', 'geobuddy' ); ?></p>
				</div>
				<div class="geobuddy-bd-feature">
					<span class="dashicons dashicons-heart"></span>
					<h4><?php esc_html_e( 'Active Support', 'geobuddy' ); ?></h4>
					<p><?php esc_html_e( 'Get dedicated support from our team of WordPress experts.', 'geobuddy' ); ?></p>
				</div>
			</div>
			<div class="geobuddy-bd-cta">
				<a href="https://buddydevelopers.com" target="_blank" class="geobuddy-button geobuddy-button-primary geobuddy-button-large"><?php esc_html_e( 'Visit BuddyDevelopers', 'geobuddy' ); ?></a>
				<a href="https://buddydevelopers.com/products" target="_blank" class="geobuddy-button geobuddy-button-secondary"><?php esc_html_e( 'View All Products', 'geobuddy' ); ?></a>
			</div>
		</div>
	</div>

