<?php
/**
 * Settings tabs view
 *
 * @package    Geobuddy
 * @subpackage Geobuddy/admin/views
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

<div class="geobuddy-admin-container">
	<!-- Settings Tabs Navigation (Vertical Sidebar) -->
	<div class="geobuddy-admin-sidebar">
		<ul>
			<?php foreach ( $tabs as $tab_id => $tab ) : ?>
				<li>
					<a href="<?php echo esc_url( add_query_arg( 'tab', $tab_id, admin_url( 'admin.php?page=geobuddy-settings' ) ) ); ?>" 
					   class="<?php echo $active_tab === $tab_id ? 'active' : ''; ?>" 
					   data-tab="<?php echo esc_attr( $tab_id ); ?>">
						<?php echo esc_html( $tab['title'] ); ?>
					</a>
				</li>
			<?php endforeach; ?>
		</ul>
	</div>

	<!-- Settings Tabs Content -->
	<div class="geobuddy-admin-sidebar-content-wrapper">
		<div class="geobuddy-admin-main-content">
			<?php foreach ( $tabs as $tab_id => $tab ) : ?>
				<div class="geobuddy-tab-content <?php echo $active_tab === $tab_id ? 'active' : ''; ?>" 
					 id="geobuddy-tab-<?php echo esc_attr( $tab_id ); ?>">
					<?php
					if ( is_callable( $tab['callback'] ) ) {
						call_user_func( $tab['callback'] );
					} else {
						echo '<div class="error"><p>' . esc_html__( 'Invalid callback for this tab.', 'geobuddy' ) . '</p></div>';
					}
					?>
				</div>
			<?php endforeach; ?>
		</div>
	</div>
</div>

