<?php
/**
 * Admin page header
 *
 * @package    Geobuddy
 * @subpackage Geobuddy/admin/views
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

$current_user = wp_get_current_user();
$user_name = $current_user->display_name ? $current_user->display_name : $current_user->user_login;
?>

<div class="geobuddy-welcome-wrapper">
	<div class="geobuddy-admin-header">
		<div class="geobuddy-admin-logo">
			<a href="https://wpgeobuddy.com/" target="_blank" rel="noopener noreferrer">
				<h3><span>Geo</span>Buddy</h3>
			</a>
		</div>
		<div class="geobuddy-admin-user-name">
			<p><?php echo esc_html( sprintf( __( 'Hi, %s', 'geobuddy' ), $user_name ) ); ?></p>
		</div>
		<div class="geobuddy-admin-help-btn">
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=geobuddy-contact' ) ); ?>"><?php esc_html_e( 'Need Help', 'geobuddy' ); ?></a>
		</div>
	</div>

