<?php
/**
 * Admin page footer
 *
 * @package    Geobuddy
 * @subpackage Geobuddy/admin/views
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

	<!-- Footer Section -->
	<div class="geobuddy-welcome-footer">
		<div class="geobuddy-footer-content">
			<div class="geobuddy-footer-links">
				<div class="geobuddy-footer-column">
					<h4><?php esc_html_e( 'Resources', 'geobuddy' ); ?></h4>
					<ul>
						<li><a href="https://wpgeobuddy.com/docs/geobuddy" target="_blank"><?php esc_html_e( 'Documentation', 'geobuddy' ); ?></a></li>
						<li><a href="https://wpgeobuddy.com/support" target="_blank"><?php esc_html_e( 'Support', 'geobuddy' ); ?></a></li>
						<li><a href="https://github.com/buddydevelopers/geobuddy" target="_blank"><?php esc_html_e( 'GitHub', 'geobuddy' ); ?></a></li>
						<li><a href="https://wordpress.org/plugins/geobuddy/" target="_blank"><?php esc_html_e( 'WordPress.org', 'geobuddy' ); ?></a></li>
					</ul>
				</div>
				<div class="geobuddy-footer-column">
					<h4><?php esc_html_e( 'Community', 'geobuddy' ); ?></h4>
					<ul>
						<li><a href="https://wpgeobuddy.com/community" target="_blank"><?php esc_html_e( 'Join Community', 'geobuddy' ); ?></a></li>
						<li><a href="https://github.com/buddydevelopers/geobuddy/issues" target="_blank"><?php esc_html_e( 'Report Issue', 'geobuddy' ); ?></a></li>
						<li><a href="https://wpgeobuddy.com/contact" target="_blank"><?php esc_html_e( 'Contact Us', 'geobuddy' ); ?></a></li>
						<li><a href="https://wpgeobuddy.com/blog" target="_blank"><?php esc_html_e( 'Blog', 'geobuddy' ); ?></a></li>
					</ul>
				</div>
				<div class="geobuddy-footer-column">
					<h4><?php esc_html_e( 'BuddyDevelopers', 'geobuddy' ); ?></h4>
					<ul>
						<li><a href="https://wpgeobuddy.com" target="_blank"><?php esc_html_e( 'About Us', 'geobuddy' ); ?></a></li>
						<li><a href="https://wpgeobuddy.com/products" target="_blank"><?php esc_html_e( 'All Products', 'geobuddy' ); ?></a></li>
						<li><a href="https://wpgeobuddy.com/pricing" target="_blank"><?php esc_html_e( 'Pricing', 'geobuddy' ); ?></a></li>
						<li><a href="https://wpgeobuddy.com/affiliates" target="_blank"><?php esc_html_e( 'Affiliate Program', 'geobuddy' ); ?></a></li>
					</ul>
				</div>
			</div>
			<div class="geobuddy-footer-bottom">
				<div class="geobuddy-footer-copyright">
					<p>
						&copy; <?php echo esc_html( date( 'Y' ) ); ?> 
						<a href="https://wpgeobuddy.com" target="_blank"><?php esc_html_e( 'BuddyDevelopers', 'geobuddy' ); ?></a>. 
						<?php esc_html_e( 'All rights reserved.', 'geobuddy' ); ?>
					</p>
					<p class="geobuddy-version">
						<?php 
						printf(
							/* translators: %s: Plugin version */
							esc_html__( 'GeoBuddy Version %s', 'geobuddy' ),
							esc_html( BD_GEOBUDDY_VERSION )
						); 
						?>
					</p>
				</div>
				<div class="geobuddy-footer-social">
					<a href="https://wpgeobuddy.com" target="_blank" class="geobuddy-social-link" title="<?php esc_attr_e( 'Visit BuddyDevelopers', 'geobuddy' ); ?>">
						<span class="dashicons dashicons-admin-site"></span>
					</a>
					<a href="https://github.com/buddydevelopers" target="_blank" class="geobuddy-social-link" title="<?php esc_attr_e( 'GitHub', 'geobuddy' ); ?>">
						<span class="dashicons dashicons-media-code"></span>
					</a>
				</div>
			</div>
		</div>
	</div>
</div>

