<?php
/**
 * Example: How to register a settings tab from a GeoBuddy addon
 *
 * This is an example file showing how addons can register their own tabs
 * in the GeoBuddy Settings page.
 *
 * @package    Geobuddy
 * @subpackage Geobuddy/admin/views
 */

/**
 * Example: Register a tab for "GeoBuddy Multistep Form" addon
 * 
 * Add this code to your addon's main file or initialization class
 * 
 * The action 'geobuddy_register_settings_tabs' passes the admin instance
 * as the first parameter, so you can call register_settings_tab() on it.
 */
function geobuddy_multistep_form_register_tab($admin_instance) {
    // Register the tab using the passed admin instance
    $admin_instance->register_settings_tab(array(
        'id'       => 'stepwise-form',
        'title'    => __('Stepwise Form', 'geobuddy-multistep-form'),
        'callback' => 'geobuddy_multistep_form_render_tab',
        'priority' => 20 // Higher priority = appears later (General is 10)
    ));
}
add_action('geobuddy_register_settings_tabs', 'geobuddy_multistep_form_register_tab', 20);

/**
 * Render the tab content
 */
function geobuddy_multistep_form_render_tab() {
    ?>
    <div class="geobuddy-addon-settings">
        <h3><?php esc_html_e('Stepwise Form Settings', 'geobuddy-multistep-form'); ?></h3>
        <p><?php esc_html_e('Configure your stepwise form settings here.', 'geobuddy-multistep-form'); ?></p>
        
        <form method="post" action="options.php">
            <?php
            // Your settings fields here
            settings_fields('geobuddy_multistep_form_options');
            do_settings_sections('geobuddy_multistep_form_settings');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

/**
 * Example: Register a tab for "GeoBuddy Private Message" addon
 */
function geobuddy_private_message_register_tab($admin_instance) {
    $admin_instance->register_settings_tab(array(
        'id'       => 'private-message',
        'title'    => __('Private Message', 'geobuddy-private-message'),
        'callback' => 'geobuddy_private_message_render_tab',
        'priority' => 30
    ));
}
add_action('geobuddy_register_settings_tabs', 'geobuddy_private_message_register_tab', 20);

/**
 * Render Private Message tab content
 */
function geobuddy_private_message_render_tab() {
    ?>
    <div class="geobuddy-addon-settings">
        <h3><?php esc_html_e('Private Message Settings', 'geobuddy-private-message'); ?></h3>
        <p><?php esc_html_e('Configure your private messaging settings here.', 'geobuddy-private-message'); ?></p>
        
        <form method="post" action="options.php">
            <?php
            settings_fields('geobuddy_private_message_options');
            do_settings_sections('geobuddy_private_message_settings');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

/**
 * NOTES FOR ADDON DEVELOPERS:
 * 
 * 1. Hook into 'geobuddy_register_settings_tabs' action
 * 2. The callback receives $admin_instance as parameter
 * 3. Call register_settings_tab() with:
 *    - id: unique tab identifier (slug)
 *    - title: tab label
 *    - callback: function/method to render tab content
 *    - priority: order (lower = earlier, General is 10)
 * 
 * 4. Your callback function should render the settings form
 * 5. Use standard WordPress Settings API for form fields
 * 6. Tab will automatically appear when your addon is active
 */

