/**
 * GeoBuddy Admin JavaScript
 *
 * @package    Geobuddy
 * @subpackage Geobuddy/admin/js
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        // Handle tab navigation clicks
        $('.geobuddy-tab-nav').on('click', function(e) {
            e.preventDefault();
            
            var tabId = $(this).data('tab');
            var tabUrl = $(this).attr('href');
            
            // Update active tab
            $('.geobuddy-tab-nav').removeClass('active');
            $(this).addClass('active');
            
            // Update active tab content
            $('.geobuddy-tab-content').removeClass('active');
            $('#geobuddy-tab-' + tabId).addClass('active');
            
            // Update URL without page reload
            if (window.history && window.history.pushState) {
                window.history.pushState(null, null, tabUrl);
            }
        });

        // Handle browser back/forward buttons
        if (window.history && window.history.pushState) {
            window.addEventListener('popstate', function(e) {
                var urlParams = new URLSearchParams(window.location.search);
                var tab = urlParams.get('tab') || 'general';
                
                // Update active tab
                $('.geobuddy-tab-nav').removeClass('active');
                $('.geobuddy-tab-nav[data-tab="' + tab + '"]').addClass('active');
                
                // Update active tab content
                $('.geobuddy-tab-content').removeClass('active');
                $('#geobuddy-tab-' + tab).addClass('active');
            });
        }
    });

})(jQuery);

