(function ($) {
    $(function () {

        if (typeof BGEO_ADMIN === "undefined") {
            return;
        }

        const ajaxUrl = BGEO_ADMIN.ajax_url;
        const nonce = BGEO_ADMIN.nonce;

        const ipEl = document.getElementById('bgeo-test-ip');
        const resWrap = document.getElementById('bgeo-test-result');
        const statusPill = document.getElementById('bgeo-status-pill');
        const statusText = document.getElementById('bgeo-status-text');

        const kv = {
            ip: document.getElementById('kv-ip'),
            asn: document.getElementById('kv-asn'),
            asname: document.getElementById('kv-asname'),
            asdomain: document.getElementById('kv-asdomain'),
            cc: document.getElementById('kv-cc'),
            country: document.getElementById('kv-country'),
            continentCode: document.getElementById('kv-continent-code'),
            continent: document.getElementById('kv-continent'),
        };

        function setStatusBadge(status) {
            statusPill.className = 'bgeo-pill';

            if (status >= 200 && status < 300) {
                statusPill.classList.add('bgeo-pill--ok');
                statusText.textContent = 'OK (' + status + ')';
            } else if (status >= 400 && status < 500) {
                statusPill.classList.add('bgeo-pill--warn');
                statusText.textContent = 'Client Error (' + status + ')';
            } else if (status >= 500) {
                statusPill.classList.add('bgeo-pill--error');
                statusText.textContent = 'Server Error (' + status + ')';
            } else {
                statusPill.classList.add('bgeo-pill--muted');
                statusText.textContent = '—';
            }
        }

        function fillKV(data) {
            kv.ip.textContent = data.ip || '—';
            kv.asn.textContent = data.asn || '—';
            kv.asname.textContent = data.as_name || '—';
            kv.asdomain.textContent = data.as_domain || '—';
            kv.cc.textContent = data.country_code || '—';
            kv.country.textContent = data.country || '—';
            kv.continentCode.textContent = data.continent_code || '—';
            kv.continent.textContent = data.continent || '—';
        }

        function showLoading() {
            resWrap.style.display = 'block';
            setStatusBadge(0);
            statusText.textContent = 'Loading…';
            fillKV({});
        }

        function test(ip) {
            showLoading();

            const form = new FormData();
            form.append('action', 'bgeo_test_ipinfo');
            form.append('nonce', nonce);
            if (ip) form.append('ip', ip);

            fetch(ajaxUrl, { method: 'POST', body: form })
                .then(r => r.json())
                .then(json => {
                    if (!json || !json.success || !json.data) {
                        setStatusBadge(0);
                        statusText.textContent = 'Lookup failed.';
                        return;
                    }

                    const status = json.data.status || 0;
                    const data = json.data.data || {};
                    setStatusBadge(parseInt(status, 10));
                    fillKV(data);
                })
                .catch(() => {
                    setStatusBadge(0);
                    statusText.textContent = 'Request error.';
                });
        }

        $('#bgeo-test-btn').on('click', function () {
            const ip = (ipEl.value || '').trim();
            if (!ip) {
                resWrap.style.display = 'block';
                statusPill.className = 'bgeo-pill bgeo-pill--warn';
                statusText.textContent = 'Enter an IP or click “Test My IP”.';
                return;
            }
            test(ip);
        });

        $('#bgeo-test-my-btn').on('click', function () {
            test('');
        });

    });
})(jQuery);