<?php
/**
 * Plugin Name: Geemie Chat Widget
 * Description: Loads the Geemie Chat widget script on the front-end.
 * Version: 1.0.2
 * Requires at least: 5.0
 * Tested up to: 6.8
 * Author: Geemie
 * License: GPL2+
 */

if (!defined('ABSPATH')) {
    exit;
}

define('GEEMIE_CHAT_WIDGET_VERSION', '1.0.2');

/**
 * HEAD
 */
add_action('wp_enqueue_scripts', function () {
    if (is_admin() || is_feed() || is_robots() || is_trackback()) {
        return;
    }

    wp_register_script(
        'geemie-viewport-fix',
        'https://service.geemie.chat/viewport.js',
        array(),
        '1.0.0',
        false
    );
    wp_enqueue_script('geemie-viewport-fix');
}, 999); 

/**
 * FOOTER
 */
add_action('wp_enqueue_scripts', function () {
    if (is_admin() || is_feed() || is_robots() || is_trackback()) {
        return;
    }

    $src = apply_filters('geemie_chat_widget_src', 'https://service.geemie.chat/widget.js');

    wp_register_script(
        'geemie-chat-widget',
        esc_url($src),
        array(),
        '1.0.0',
        true
    );
    wp_enqueue_script('geemie-chat-widget');

    if (function_exists('wp_script_add_data')) {
        wp_script_add_data('geemie-chat-widget', 'defer', true);
    }
}, 20);
