<?php

namespace Geargag_Advanced_Shipping\admin;

defined('WPINC') || die();

use Geargag_Advanced_Shipping\tools\contracts\Bootable;
use function Geargag_Advanced_Shipping\is_woocommerce_active;
use const Geargag_Advanced_Shipping\PLUGIN_BASE;

class Notices implements Bootable {
	public function boot() {
		add_action('admin_notices', [$this, 'global_note']);
	}

	public function global_note() {
		if (!is_woocommerce_active()) {
			printf(
				'<div id="message" class="notice notice-error is-dismissible"><p>%s</p></div>',
				esc_html__('Please install and activate WooCommerce to use Geargag Advanced Shipping for WooCommerce plugin.', 'geargag-advanced-shipping-for-woocommerce')
			);
		}

		if (is_plugin_active('geargag-advanced-shipping-for-woocommerce-pro/index.php')) {
			deactivate_plugins(PLUGIN_BASE);
			unset($_GET['activate']);
		}
	}
}
