<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists("GDPREXTENSIONCOMYT_TabWidget")) {

    class GDPREXTENSIONCOMYT_TabWidget
    {

        public function __construct()
        {
            $this->gdprextensioncomyt_tab_widget_callback();
        }


        public function gdprextensioncomyt_tab_widget_callback()
        {
            $site_id = get_current_blog_id();
            $tab_data = $this->gdprextensioncomyt_tabdata($site_id);


            $tab_icon = isset($tab_data['image_url']) ? $tab_data['image_url'] : '/wp-content/plugins/gdpr-extensions-com-youtube/assets/img/gdpr-logo-icon.svg';

            $heading_color = isset($tab_data['heading_color']) ? $tab_data['heading_color'] : '#000';
            $header_color = isset($tab_data['header_color']) ? $tab_data['header_color'] : '#000';
            $headline = isset($tab_data['headline']) ? $tab_data['headline'] : 'YouTube Consent';
            $overlay_text = isset($tab_data['overlay_text']) ? $tab_data['overlay_text'] : 'You consent for viewing Youtube content that may collect your data';
            $button_color = isset($tab_data['button_color']) ? $tab_data['button_color'] : '#fff';
            $button_shape = isset($tab_data['button_shape']) ? $tab_data['button_shape'] : 'default';
            $button_bgcolor = isset($tab_data['button_bgcolor']) ? $tab_data['button_bgcolor'] : '#2271B1';
            $btn_text = isset($tab_data['button_text']) ? $tab_data['button_text'] : 'Confirm';
            $bgcolor = isset($tab_data['bg_color']) ? $tab_data['bg_color'] : '#CCCCCC';

            wp_nonce_field('gdprextensioncomyt_settings_action', 'gdprextensioncomyt_settings_nonce');  //change
            echo ' 
                <style>:root { --yt--bg-image: url(" ' . esc_attr($tab_icon) . '"); }</style>

            <div class="wrap">
                    <div class="mainLogo">
                        <div class="gdprextension">
                        </div>
                    </div>
                <div class="extensionPromotions">
                    <div class="col-7">
                        <div class="content">
                            <p class="bold">Explore More of our Solutions</p>
                            <p class="light">2-Click Solutions Available Now to Check Out</p>
                            <div class="pair-end mt-20">
                                <span>
                                    <a href="https://www.gdpr-extensions.com/gdpr-solutions" class="btn btn-outline" target="_blank">Explore</a>
                                </span>
                                <span>
                                   
                                    <div class="arrow1">
                                    </div>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="col-5">
                       
                        <div class="logosgroup"></div>
                    </div>
                </div>
                <div class="extensionBriefing">
                    <div class="main-headline">
                        <h2>Youtube 2-Click Solution</h2>
                       
                        <div class="sm-youtube">
                        </div>
                    </div>
                    <div class="content">
                        <p>Welcome to the your Youtube 2-Click Solution Customization page.</p>
                        <p>YouTube content will be masked until the user has consented for YouTube to collect their data.</p>
                        <a href="http://" class="seeExample">See Example</a>
                    </div>
                </div>
                <div class="popUpoverlay" style="display: none;">
                    <div class="popUp">
                        <div class="popUp--content" id="beforeConsent">
                            <p class="bold">Youtube Content Disabled - Need Consent</p>
                            <p class="light">You consent for viewing Youtube content that may collect your data </p>
                            <a href="" class="button button-primary" id="consentBtn">I consent</a>
                        </div>
                        <div class="popUp--content" id="afterConsent" style="display: none;">
                            <p class="bold">YT VIDEO</p>
                        </div>
                    </div>
                </div>
                <div class="nav-tab-wrapper">
                <form action="options.php" method="post" enctype="multipart/form-data">
                
                <div class="yt__site-list">
                            <div class="yt__site-item">

                                <div class="yt__site-details" data-id="1">
                                    <div class="yt__site-name">Customize Content Mask</div>
                                </div>
                                    <div class="yt__toggles mt-16 mb-10" style="display: none;" id="api-details-1">
                                    <input type="hidden" id="site_id" name="site_id" value="' . esc_attr(get_current_blog_id()) . '" />
                                <div class="d-flex g-20">
                                    <div class="uplodedImageTitle">
                                        Background Image
                                    </div>
                                        <label class="switch">
                                        <input type="checkbox" id="gdprextensioncomyt_managertab_toggle">
                                        <span class="slider round"></span>
                                        </label>
                                        <input class="d-none" id="enabledbackgroundImage" type="text" name="gdprManager[enableBackgroundImage]" value="0">
                                    </div>
                                    <div class="yt__file-upload d-none">
                                        <input type="hidden" id="gdprextensioncomyt_managertab_img" name="gdprextensioncomyt_managertab_img" value="" style="display: inline-block;">
                                        <input type="file" id="upload_imagefile" name="upload_image" value="" accept="image/*,.svg"  />
                                        <label class="yt__btn yt__btn-outlined yt__icon" for="upload_cookie_icon" class="yt__label yt__semibold"style="height: 26px;">Choose file
                                            <span id="file--upload">
                                            </span>
                                        </label>
                                         <div class="uploaded-image" >
                                                <div id="uploaded_image_icon" src="' . esc_attr($tab_icon) . '"></div>
                                        </div>
                                        <span id="yt_remove-icon" class="yt_close"></span>
                                    </div>                                   
                                    <div class="background_color_wrap">
                                    <div class="yt__label yt__semibold">Color</div>
                                    <div class="yt__color">
                                        <div class="yt__color-wrap">
                                            <input type="color" id="gdprextensioncomyt_managertab_bgcolor" name="background_color"
                                                value="' . esc_attr($bgcolor) . '" />
                                            <label for="gdprextensioncomyt_managertab_bgcolor" class="yt__label">Background Color</label>
                                        </div>
                                    </div>
                                    </div>
                                </div>

                            </div>

                            <div class="yt__site-details" data-id="2">
                                <div class="yt__site-name">Customize Button</div>
                            </div>

                            <div class="yt__toggles pt-8" style="display: none;" id="api-details-2">
                                <div class="yt__label yt__semibold">Button Color</div>
                                <div class="yt__color">
                                    <div class="yt__color-wrap">
                                        <input type="color" id="gdprextensioncomyt_managertab_button_bgcolor" name="gdprextensioncomyt_managertab_button_bgcolor"
                                            value="' . esc_attr($button_bgcolor) . '" />
                                        <label for="gdprextensioncomyt_managertab_button_bgcolor" class="yt__label">Background Color</label>
                                    </div>
                                    <div class="yt__color-wrap">
                                        <input type="color" id="gdprextensioncomyt_managertab_btncolor" name="gdprextensioncomyt_managertab_btncolor"
                                            value="' . esc_attr($button_color) . '" />
                                        <label for="gdprextensioncomyt_managertab_btncolor" class="yt__label">Button Text Color</label>
                                    </div>
                                </div>
                                <div class="pair ">
                                    <div class="mt-20 mb-10 d-flex i-flex">
                                        <label for="cm_btn_text" class="yt__label yt__semibold">Button Text:</label>
                                        <input type="text" id="gdprextensioncomyt_managertab_buttontext" name="gdprextensioncomyt_managertab_buttontext" size="30"
                                            class="yt__input mb-8 yt__sm_input" value="' . esc_attr($btn_text) . '" />
                                    </div>

                                </div>
                                <div class="pair ">
                                    <div class="mt-10 mb-10 d-flex i-flex">
                                        <label for="yt_btn_text" class="yt__label yt__semibold">Button Shape:</label>
                                        <select id="gdprextensioncomyt_managertab_button_shape" name="button_shape">
                                                    <option value="default" ' . selected($button_shape, 'default', false) . '>Default</option>
                                                    <option value="square" ' . selected($button_shape, 'square', false) . '>Square</option>
                                                    <option value="round" ' . selected($button_shape, 'round', false) . '>Round</option>
                                        </select>
                                    </div>

                                </div>
                            </div>
                        </div>


                        <div class="yt__site-details" data-id="3">
                        <div class="yt__site-name">Customize Message</div>
                    </div>

                    <div class="yt__toggles" style="display: none;" id="api-details-3">
                        <div class="yt__label yt__semibold">Body Color</div>
                        <div class="yt__color">
                            <div class="yt__color-wrap">
                                <input type="color" id="gdprextensioncomyt_managertab_heading_color" name="heading_color"
                                    value="' . esc_attr($heading_color) . '" />
                                <label for="gdprextensioncomyt_managertab_heading_color" class="yt__label">Heading Color</label>
                            </div>
                            <div class="yt__color-wrap">
                                <input type="color" id="gdprextensioncomyt_managertab_header_color" name="header_color" value="' . esc_attr($header_color) . '" />
                                <label for="gdprextensioncomyt_managertab_header_color" class="yt__label">Text Color</label>
                            </div>
                        </div class="pair ">
                            <div class="mt-20 d-flex i-flex">
                                <label for="gdprextensioncomyt_managertab_headline" class="yt__label yt__semibold">Heading</label>
                                <input type="text" id="gdprextensioncomyt_managertab_headline" name="gdprextensioncomyt_managertab_headline" value="' . esc_attr($headline) . '" />
                            </div>

                
                        <div class= "pair ">
                            <div class="mt-20 d-flex i-flex">
                                <label for="gdprextensioncomyt_managertab_overlay_text" class="yt__label yt__semibold">Content</label>
                                <textarea name="overlay_text" id="gdprextensioncomyt_managertab_overlay_text" name="gdprextensioncomyt_managertab_overlay_text" rows="12">  ' . esc_textarea($overlay_text) . '</textarea>
                            </div>

                        </div>
                </div>
                    </div>
                </form>
                </div>

            </div>

            <div>
                <button type="button" id="submit_button_id" class="yt_btn"> Save</button>
                <div id="success-message" style="display: none;"></div>
            </div>';
        }

        public function gdprextensioncomyt_tabdata($site_id)
        {
            global $wpdb;
            // @codingStandardsIgnoreStart
            return $wpdb->get_row(
                $wpdb->prepare(
                    "SELECT * FROM youtube_tab_manager WHERE site_id = %d",
                    $site_id
                ),
                ARRAY_A
            ); // db call ok; no-cache ok
            // @codingStandardsIgnoreEnd
        }

    }
    add_action('wp_ajax_gdprextensioncomyt_upload_image', 'gdprextensioncomyt_upload_image');
    new GDPREXTENSIONCOMYT_TabWidget();

}
