document.addEventListener('DOMContentLoaded', function () {
    const siteId = document.body.dataset.blogId;
    const toggleYoutubeBtns = document.getElementById('cookieToggle-gdpr-extensions-com-youtube2xclicksolution-' + siteId);
    const consentYoutubeOverlays = document.querySelectorAll(".gdpr-youtube__consent-overlay");
    const consentYoutubeBtns = document.querySelectorAll(".gdpr-youtube__consent-overlay__btn");
    const consentYoutubeCookie = 'gdpr-extensions-com-youtube2xclicksolution-' + siteId;

    function updateYoutubeCookieList() {
        return document.cookie.split(";");
    }

    if (updateYoutubeCookieList().some(cookie => cookie.trim().startsWith(`${consentYoutubeCookie}=`))) {
        consentYoutubeOverlays.forEach(overlay => overlay.style.display = "none");
        loadYouTubeScriptWithDelay();
    }

    if (consentYoutubeBtns) {
        consentYoutubeBtns.forEach(btn => {
            btn.addEventListener("click", (e) => {
                e.preventDefault();
                consentYoutubeOverlays.forEach(overlay => overlay.style.display = "none");
                setCookie(consentYoutubeCookie, 'true', 30); 
                checkYoutubeToggle();
                loadYouTubeScriptWithDelay();
            });
        });
    }



    toggleYoutubeBtns?.addEventListener('change', function () {
        const pluginName = toggleYoutubeBtns?.id.replace('cookieToggle-', '');
        toggleYoutubeCookie(pluginName);
    });

    function toggleYoutubeCookie(pluginName) {
        const checkbox = document.getElementById('cookieToggle-' + pluginName);
        const isChecked = checkbox.checked;

        if (isChecked) {
            setCookie(consentYoutubeCookie, 'true', 1); 
            loadYouTubeScriptWithDelay();
        } else {
            deleteCookie(consentYoutubeCookie);
            destroyYouTubePlayers();
        }
    }

    function loadYouTubeScriptWithDelay() {
        setTimeout(function () {
            const consentCookiePresent = updateYoutubeCookieList().some(cookie => cookie.trim().startsWith(`${consentYoutubeCookie}=`));

            if (consentCookiePresent) {
                loadYouTubeScript();
                consentYoutubeOverlays.forEach(overlay => overlay.style.display = "none");
                checkYoutubeToggle();
            }
        }, 500);
    }

    function loadYouTubeScript() {
        const youtubeWrappers = document.querySelectorAll(".gdpr-youtube__player");

        youtubeWrappers?.forEach((wrapper, index) => {
            const attributes = JSON.parse(wrapper.dataset.attributes);
            const videoID = attributes.videoID || '';
            const autoplay = attributes.autoplay;
            const disableFullscreen = attributes.disableFullscreen;
            const disableKeyboardControls = attributes.disableKeyboardControls;
            const disablePlaybar = attributes.disablePlaybar;
            const annotationsDisabled = attributes.annotationsDisabled;
            const showClosedCaptions = attributes.showClosedCaptions;

            const iframe = document.createElement('iframe');
            iframe.src = `https://www.youtube.com/embed/${videoID}?autoplay=${autoplay ? 1 : 0}&fs=${disableFullscreen ? 0 : 1}&disablekb=${disableKeyboardControls ? 0 : 1}&controls=${disablePlaybar ? 0 : 1}&iv_load_policy=${annotationsDisabled ? 3 : 1}&cc_load_policy=${showClosedCaptions ? 1 : 0}&mute=${autoplay ? 1 : 0}`;
            iframe.width = '640';
            iframe.height = '360';
            iframe.frameborder = '0';
            iframe.allowfullscreen = 'true';

            wrapper.innerHTML = ''; // Clear existing content
            wrapper.appendChild(iframe);
        });
    }

    function checkYoutubeToggle() {
        const consentCookiePresent = updateYoutubeCookieList().some(cookie => cookie.trim().startsWith(`${consentYoutubeCookie}=`));
        const pluginName = toggleYoutubeBtns?.id.replace('cookieToggle-', '');
        const isChecked = consentCookiePresent && document.cookie.includes(pluginName);
        if (toggleYoutubeBtns) {
            toggleYoutubeBtns.checked = isChecked;
        }

    }

    function destroyYouTubePlayers() {
        const videoContainers = document.querySelectorAll('.gdpr-youtube__player');
        videoContainers?.forEach(function (container) {
            container.innerHTML = '';
        });
        consentYoutubeOverlays.forEach(overlay => overlay.style.display = "flex");
    }

    function setCookie(name, value, days) {
        const date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000)); // Add days to the current time
        const expires = "expires=" + date.toUTCString();
        document.cookie = name + "=" + value + ";" + expires + ";path=/";
    }
    

    function deleteCookie(name) {
        document.cookie = name + "=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
    }
});
