export function editorPlayer() {
  const siteId = document.body.dataset.blogId;
  const consentYoutubeOverlays = document.querySelectorAll(".gdpr-youtube__consent-overlay");
  const consentYoutubeBtns = document.querySelectorAll(".gdpr-youtube__consent-overlay__btn");
  const consentYoutubeCookie = 'gdpr-extensions-com-youtube2xclicksolution-' + siteId;

  const cookieList = document.cookie.split(";");


  if (cookieList.includes("gdpr-extensions-com-youtube=true")) {
    consentYoutubeOverlays.forEach(overlay => overlay.style.display = "none");
    loadYouTubeScript();
  }

  if (consentYoutubeBtns) {
    consentYoutubeBtns.forEach(btn => {
      btn.addEventListener("click", (e) => {
        e.preventDefault();
        consentYoutubeOverlays.forEach(overlay => overlay.style.display = "none");
        setCookie(consentYoutubeCookie, 'true', 30); 
        loadYouTubeScript();
      });
    });
  }

  if (cookieList.some(cookie => cookie.trim().startsWith(`${consentYoutubeCookie}=`))) {
    consentYoutubeOverlays.forEach(overlay => overlay.style.display = "none");
    loadYouTubeScript();
  }

  function loadYouTubeScript() {
    const youtubeWrappers = document.querySelectorAll(".gdpr-youtube__player");

    youtubeWrappers?.forEach((wrapper, index) => {
      const attributes = JSON.parse(wrapper.dataset.attributes);
      const videoID = attributes.videoID || '';
      const autoplay = attributes.autoplay;
      const disableFullscreen = attributes.disableFullscreen;
      const disableKeyboardControls = attributes.disableKeyboardControls;
      const disablePlaybar = attributes.disablePlaybar;
      const annotationsDisabled = attributes.annotationsDisabled;
      const showClosedCaptions = attributes.showClosedCaptions;

      const iframe = document.createElement('iframe');
      iframe.src = `https://www.youtube.com/embed/${videoID}?autoplay=${autoplay ? 1 : 0}&fs=${disableFullscreen ? 0 : 1}&disablekb=${disableKeyboardControls ? 0 : 1}&controls=${disablePlaybar ? 0 : 1}&iv_load_policy=${annotationsDisabled ? 3 : 1}&cc_load_policy=${showClosedCaptions ? 1 : 0}&mute=${autoplay ? 1 : 0}`;
      iframe.width = '640';
      iframe.height = '360';
      // iframe.allow = 'accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share';
      iframe.frameborder = '0';
      iframe.allowfullscreen = 'true';

      wrapper.innerHTML = ''; // Clear existing content
      wrapper.appendChild(iframe);
    });
  }

  function setCookie(name, value, days) {
    const date = new Date();
    date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000)); // Add days to the current time
    const expires = "expires=" + date.toUTCString();
    document.cookie = name + "=" + value + ";" + expires + ";path=/";
}


  const bodyText = "Interaktive Karte laden";
  const overlayText = "Wenn Sie die eingebettete interaktive Karte auf dieser Website nutzen möchten, werden personenbezogene Daten (IP-Adresse) an den Betreiber des Online-Kartendienstes gesendet. Daher ist es möglich, dass der Anbieter Ihre Zugriffe speichert und Ihr Verhalten analysieren kann. Wenn Sie den Button 'interaktive Karte laden' anklicken, wird ein Cookie auf Ihrem Computer gesetzt, sodass die Website weiß, dass Sie dem Anzeigen der Onlinekarte in Ihrem Browser zugestimmt haben. Dieses Cookie speichert keine personenbezogenen Daten, es erkennt lediglich. Weitere Informationen erhalten Sie hier: Datenschutz";

  $.ajax({
    url: '/wp-admin/admin-ajax.php',
    data: {
      'action': 'gdprextensioncomyt_fetch_ytdata',
    },
    success: function (data) {
      $('.gdpr-youtube__consent-overlay__headline eee').html(data?.headline || bodyText);
      $('.gdpr-youtube__consent-overlay__text').html(data?.overlay_text || overlayText);
      $('.gdpr-youtube__consent-overlay__btn').html(data?.button_text || bodyText);
    }
  });


}
