<?php

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly
}

function gdprextensioncomyt_ytplugin()
{
  global $wpdb;
  $cache_key = 'gdprextensioncomyt_ytplugin_';

  // Attempt to retrieve cached data
  $cached_result = wp_cache_get($cache_key);
  if ($cached_result !== false) {
    return $cached_result;
  }

  
  // @codingStandardsIgnoreStart
  $result = $wpdb->get_row(
    $wpdb->prepare(
      "SELECT * FROM youtube_tab_manager WHERE id = %d",
      1
    ),
    ARRAY_A
  );
  // @codingStandardsIgnoreEnds

  // Cache the result
  wp_cache_set($cache_key, $result);
  return $result;
}

/**
 * Enqueue YouTube script on the frontend.
 */
function gdprextensioncomyt_youtube_scripts()
{
  if (!is_admin() && (strpos(get_the_content(), 'gdpr-youtube__wrapper') !== false || strpos(get_the_content(), 'gdpr-extensions-com-youtube') !== false)) {
    $script_url = plugin_dir_url(dirname(__FILE__)) . 'assets/js/gdpr-youtube.js';

    wp_enqueue_script(
      'gdprextensioncomyt-user',
      $script_url,
      array('jquery'),
      GDPREXTENSIONCOMYT_VERSION,
      true
    );

    wp_localize_script('gdprextensioncomyt-user', 'ajax_object', array(
      'ajax_url' => admin_url('admin-ajax.php'),
    ));
  }
}
add_action('wp_enqueue_scripts', 'gdprextensioncomyt_youtube_scripts');

/**
 * Enqueue YouTube script in the admin editor.
 */
function gdprextensioncomyt_admin_youtube_scripts($hook)
{
  // Check if we are on the post editor screen
  $screen = get_current_screen();

  if ($screen && $screen->base === 'post' && $screen->post_type === 'page') {
    $script_url = plugin_dir_url(dirname(__FILE__)) . 'assets/js/gdpr-youtube.js';

    wp_enqueue_script(
      'gdprextensioncomyt-user-admin',
      $script_url,
      array('jquery'),
      GDPREXTENSIONCOMYT_VERSION,
      true
    );

    wp_localize_script('gdprextensioncomyt-user-admin', 'ajax_object', array(
      'ajax_url' => admin_url('admin-ajax.php'),
    ));
  }
}
add_action('admin_enqueue_scripts', 'gdprextensioncomyt_admin_youtube_scripts');

/**
 * Handle AJAX request to fetch YouTube data.
 */
function gdprextensioncomyt_fetch_ytdata()
{
  $hold = gdprextensioncomyt_ytplugin();
  wp_send_json($hold);
}
add_action('wp_ajax_gdprextensioncomyt_fetch_ytdata', 'gdprextensioncomyt_fetch_ytdata');
add_action('wp_ajax_nopriv_gdprextensioncomyt_fetch_ytdata', 'gdprextensioncomyt_fetch_ytdata');
