<?php

/**
 * Plugin Name:       GDPR-Extensions-com - Youtube 2xClick Solution
 * Plugin URI:        https://www.gdpr-extensions.com/gdpr-solutions/our-2-click-solutions/youtube-2xclick-solution
 * Description:       The GDPR-Extensions-com - Youtube 2xClick Solution, brought to you by GDPR-Extensions-com, is a feature-rich solution designed to empower website owners in effectively managing youtube videos and bolstering user privacy.
 * Requires at least: 6.4
 * Requires PHP:      8.1
 * Version:           1.0.1
 * Author:            GDPR-extensions.com Team
 * Author URI:        https://www.gdpr-extensions.com/
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       gdpr-extensions-com-youtube
 * Domain Path:       /languages
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!function_exists('add_action')) {
    echo 'Seems like you have an old version of PHP';
    exit;
}

//Hooks
add_action('wp_head', 'gdprextensioncomyt_blogid', 5);
add_action('init', 'gdprextensioncomyt_register_blocks');
add_filter('block_categories_all', "gdprextensioncomyt_category");


// Setup
define('GDPREXTENSIONCOMYT_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('GDPREXTENSIONCOMYT_TEXT_DOMAIN', 'gdpr-extensions-com-youtube');
define('GDPREXTENSIONCOMYT_VERSION', '1.0.1');

function gdprextensionyoutube_blog_id() {
    $current_blog_id = get_current_blog_id();
	wp_add_inline_script( 'jquery', "
        jQuery(document).ready(function($) {
            var body = $('body');
            if (!body.attr('data-blog-id')) {
                body.attr('data-blog-id', '" . esc_attr( $current_blog_id ) . "');
            }
        });
    ");
}

// Hook
add_action( 'wp_enqueue_scripts', 'gdprextensionyoutube_blog_id' );
add_action( 'admin_enqueue_scripts', 'gdprextensionyoutube_blog_id' );



// require_once plugin_dir_path(__FILE__) . 'functions/functions.php';
require_once plugin_dir_path(__FILE__) . 'functions/tabs_data.php';
register_activation_hook(__FILE__, 'gdprextensioncomyt_tabManager');
register_deactivation_hook(__FILE__, 'gdprextensioncomyt_tabManager_deactivation');




function gdprextensioncomyt_category($categories)
{
    $category_slug = 'gdprextensioncom';
    $category_title = 'GDPR-Extensions-Com';

    $category_exists = false;
    foreach ($categories as $category) {
        if ($category['slug'] === $category_slug) {
            $category_exists = true;
            break;
        }
    }

    // If the category doesn't exist, add it
    if (!$category_exists) {
        $categories[] = array(
            'slug' => $category_slug,
            'title' => $category_title
        );
    }

    return $categories;
}
function gdprextensioncomyt_menu()
{

    $menu_slug = 'gdprextensionscom-plugin-settings';
    $exists = false;
    global $menu;
    foreach ($menu as $item) {
        if ($item[2] == $menu_slug) {
            $exists = true;
            break;
        }
    }

    if (!$exists) {
        add_menu_page(
            null,
            'GDPR-Extensions-Com Admin',
            'manage_options',
            $menu_slug,
        );
    }

    add_submenu_page(
        $menu_slug,
        'Youtube 2xClick Solution Settings',
        'Youtube 2xClick Solution',
        'manage_options',
        'gdprextensioncomyt-submenu',
        'gdprextensioncomyt_submenu_page'
    );

    remove_submenu_page($menu_slug, 'gdprextensionscom-plugin-settings');
}
add_action('admin_menu', 'gdprextensioncomyt_menu');

function gdprextensioncomyt_submenu_page()
{
    require_once(GDPREXTENSIONCOMYT_PLUGIN_DIR . 'views/tab-setting-page.php');
}

function gdprextensioncomyt_enqueue_admin_scripts()
{
    wp_enqueue_script(
        'gdprextensioncomyt-admin-script',
        plugin_dir_url(__FILE__) . 'assets/js/admin.js',
        array('jquery'),
        GDPREXTENSIONCOMYT_VERSION,
        true
    );

    wp_enqueue_script(
        'gdprextensioncomyt-admin-script-min',
        plugin_dir_url(__FILE__) . 'assets/js/min.js',
        array('jquery'),
        GDPREXTENSIONCOMYT_VERSION,
        true
    );

    wp_enqueue_style(
        'gdprextensioncomyt-admin-style',
        plugin_dir_url(__FILE__) . 'assets/css/admin.css',
        array(),
        GDPREXTENSIONCOMYT_VERSION,
    );
}
add_action('admin_enqueue_scripts', 'gdprextensioncomyt_enqueue_admin_scripts');


function gdprextensioncomyt_tabManager()
{
    global $wpdb;
    $table_name ='youtube_tab_manager'; // ';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        site_id INT(11) NOT NULL,
        header_color varchar(7) NOT NULL,       
        heading_color varchar(7) NOT NULL,        
        overlay_text text NOT NULL,
        headline varchar(255) NOT NULL,
        button_text varchar(255) NOT NULL,
        button_color varchar(20) NOT NULL,
        button_bgcolor varchar(20) NOT NULL,
        button_shape varchar(20) NOT NULL,
        bg_color varchar(20) NOT NULL,
        image_url varchar(255) NOT NULL,
        toggle_status varchar(10) NOT NULL DEFAULT '',
        PRIMARY KEY (id), 
        UNIQUE  (site_id)
    )  $charset_collate;";



    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}


function gdprextensioncomyt_tabManager_deactivation()
{
    global $wpdb;
    $cache_key = 'gdprextensioncomyt_tabManager_';
    $cached_data = wp_cache_get($cache_key);
    if ($cached_data !== false) {
        return $cached_data;
    }
    // @codingStandardsIgnoreStart
    $result = $wpdb->query("DROP TABLE IF EXISTS `youtube_tab_manager`");
    // @codingStandardsIgnoreEnd
    wp_cache_set($cache_key, $result);
}

function gdprextensioncomyt_blogid()
{
    $current_blog_id = get_current_blog_id();
?>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var body = document.getElementsByTagName("body")[0];
            if (!body.hasAttribute("data-blog-id")) {
                body.setAttribute("data-blog-id", '<?php echo esc_attr($current_blog_id); ?>');
            }
        });
    </script>
<?php
}


// Includes
include(GDPREXTENSIONCOMYT_PLUGIN_DIR . 'includes/youtube-functions.php');
include(GDPREXTENSIONCOMYT_PLUGIN_DIR . 'includes/register-blocks.php');
