<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

function gdprextensioncomyt_cookiewidget_save()
{

    // Check if data is coming from a valid source (uncomment the nonce check if needed)
    if ( ! isset( $_POST['gdprextensioncomyt_settings_nonce'] ) ) {
        if ( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['gdprextensioncomyt_settings_nonce'] ) ), 'gdprextensioncomyt_settings_action' ) ) {
            return;
        }
    }

 // Check if the request is not from an autosave and the current user has permissions
    if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) {
        return;
    }

    if ( ! current_user_can( 'manage_options' ) ) {
        wp_send_json_error( 'Unauthorized access' );
        return;
    }

    // Sanitize and retrieve POST data
    global $wpdb;
    $header_color = isset($_POST['header_color']) ? sanitize_text_field(wp_unslash($_POST['header_color'])) : '#000';
    $heading_color = isset($_POST['heading_color']) ? sanitize_text_field(wp_unslash($_POST['heading_color'])) : '#000';
    $headline = isset($_POST['headline']) ? sanitize_text_field(wp_unslash($_POST['headline'])) : 'YouTube Consent';
    $overlay_text = isset($_POST['overlay_text']) ? sanitize_text_field(wp_unslash($_POST['overlay_text'])) : 'You consent for viewing Youtube content that may collect your data';
    $button_text = isset($_POST['buttontext']) ? sanitize_text_field(wp_unslash($_POST['buttontext'])) : 'click';
    $button_color = isset($_POST['buttoncolor']) ? sanitize_text_field(wp_unslash($_POST['buttoncolor'])) : '#FFF';
    $button_bgcolor = isset($_POST['buttonbgcolor']) ? sanitize_text_field(wp_unslash($_POST['buttonbgcolor'])) : '#2271B1';
    $button_shape = isset($_POST['buttonshape']) ? sanitize_text_field(wp_unslash($_POST['buttonshape'])) : 'square';
    $bg_color = isset($_POST['bgcolor']) ? sanitize_text_field(wp_unslash($_POST['bgcolor'])) : '#CCCCCC';
    // $image_url =isset($_POST['image_url']) ? esc_url_raw(wp_unslash($_POST['image_url'])) : '';
    $site_id = isset($_POST['site_id']) ? absint($_POST['site_id']) : 0;
    $toggle_status = isset($_POST['gdprextensioncomyt_managertab_toggle']) ? sanitize_text_field(wp_unslash($_POST['gdprextensioncomyt_managertab_toggle'])) : 'false';

    // Table name for the YouTube Tab Manager
    $youtube_table = 'youtube_tab_manager';  // ';
    $existing_icon_url = '';
   // @codingStandardsIgnoreStarts
    $existing_row = $wpdb->get_row($wpdb->prepare( "SELECT image_url FROM {$youtube_table} WHERE site_id = %d", $site_id));
    //@codingStandardsIgnoreEnds

    if ($existing_row) {
        $existing_icon_url = $existing_row->image_url;
        
        if (empty($existing_row->image_url)) {
            $existing_icon_url = '/wp-content/plugins/gdpr-extensions-com-youtube/assets/img/gdpr-logo-icon.svg';
        }
    }
    if (!empty($_FILES['image_url']['tmp_name'])) {
        $upload_overrides = array('test_form' => false);
        $uploaded_icon = wp_handle_upload($_FILES['image_url'], $upload_overrides);
        if (!empty($uploaded_icon['url'])) {
            // Replace existing icon URL with the new one
            $existing_icon_url = esc_url($uploaded_icon['url']);
        }
    }
    else{
        $existing_icon_url = '/wp-content/plugins/gdpr-extensions-com-youtube/assets/img/gdpr-logo-icon.svg';
      
    }


    // Check if the site_id exists in the database
    //@codingStandardsIgnoreStart
    $existing_row = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$youtube_table} WHERE site_id = %d", $site_id));
    //@codingStandardsIgnoreEnds

    // Prepare the data for insertion/update
    $data_to_update = array(
        'site_id' => $site_id,
        'header_color' => $header_color,
        'heading_color' => $heading_color,
        'headline' => $headline,
        'overlay_text' => $overlay_text,
        'button_text' => $button_text,
        'button_color' => $button_color,
        'button_bgcolor' => $button_bgcolor,
        'button_shape' => $button_shape,
        'bg_color' => $bg_color,
        'image_url' => $existing_icon_url,
        'toggle_status' => $toggle_status 
    );



    // If the row exists, update it
    if ($existing_row) {
        // @codingStandardsIgnoreStart
        $update_result = $wpdb->update(
            $youtube_table,
            $data_to_update,
            array('site_id' => $site_id),
            array('%d', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s'),
            array('%d')
        ); //db call ok; no-cache ok
        // @codingStandardsIgnoreEnd



        if ($update_result === false) {
            wp_send_json_error('Failed to update the record');
        } else {
            wp_send_json_success(__('Data updated successfully!', 'gdpr-extensions-com-youtube'));
        }

    } else {
        // If the row does not exist, insert it
        // @codingStandardsIgnoreStart
        $insert_result = $wpdb->insert(
            $youtube_table,
            $data_to_update,
            array('%d', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s')
        ); // db call ok; no-cache ok
        // @codingStandardsIgnoreEnd

        
        if ($insert_result === false) {
            wp_send_json_error('Failed to insert the record');
        } else {
            wp_send_json_success(__('Data saved successfully!', 'gdpr-extensions-com-youtube'));
        }
    }

}

add_action('wp_ajax_gdprextensioncomyt_cookiewidget_save', 'gdprextensioncomyt_cookiewidget_save');
add_action('wp_ajax_nopriv_gdprextensioncomyt_cookiewidget_save', 'gdprextensioncomyt_cookiewidget_save');

?>