jQuery(document).ready(function ($) {

    const bodyText = "Interaktive Karte laden";
    const overlayText = "Wenn Sie die eingebettete interaktive Karte auf dieser Website nutzen möchten, werden personenbezogene Daten (IP-Adresse) an den Betreiber des Online-Kartendienstes gesendet. Daher ist es möglich, dass der Anbieter Ihre Zugriffe speichert und Ihr Verhalten analysieren kann. Wenn Sie den Button 'interaktive Karte laden' anklicken, wird ein Cookie auf Ihrem Computer gesetzt, sodass die Website weiß, dass Sie dem Anzeigen der Onlinekarte in Ihrem Browser zugestimmt haben. Dieses Cookie speichert keine personenbezogenen Daten, es erkennt lediglich. Weitere Informationen erhalten Sie hier: Datenschutz";
    
    
    $.ajax({
        url: '/wp-admin/admin-ajax.php',
        data: {
            'action': 'gdprextensioncomyt_fetch_ytdata',
        
        },
        success: function (data) {
            $('.gdpr-youtube__consent-overlay__headline').each(function (index, element) {
                if (element) {
                    $(element).html(data && data.headline ? data.headline : bodyText);
                }
            });

            $('.gdpr-youtube__consent-overlay__text').each(function (index, element) {
                if (element) {
                    $(element).html(data && data.overlay_text ? data.overlay_text : overlayText);
                }
            });

            $('.gdpr-youtube__consent-overlay__btn').each(function (index, element) {
                if (element) {
                    $(element).html(data && data.button_text ? data.button_text : bodyText);
                    if (element && data.button_shape){
                        $(element).addClass(data.button_shape);
                    }
                }
            });
            
            $(':root').css('--ytbgimg-url', `url(${data?.image_url})`);

            if (data?.toggle_status === true || data?.toggle_status === 'true') {
                $('.gdpr-youtube__consent-overlay').addClass('hasBgImage');
                $(':root').css('--ytbg-color', ''); 
            } 
            else {
                $('.gdpr-youtube__consent-overlay').removeClass('hasBgImage');
                $(':root').css('--ytbg-color', data?.bg_color || '#CCCCCC'); 
            }



            $('html').css({
                '--ytbtn-txt-color': data?.button_color || '#FFFFFF',
                '--ytbtn-bg-color': data?.button_bgcolor || '#000000',
                '--ytheading-color': data?.heading_color || '#333333',
                '--yttext-color': data?.header_color || '#666666',
                '--ytbutton-shape': data?.button_shape,
            });


        }

    });
});
