jQuery(document).ready(function ($) {
    var ytTabToLoad = 'content_mask';
    var nonce = $('#gdprextensioncomyt_settings_nonce').val();

    $.ajax({
        url: ajaxurl,
        type: 'POST',
        data: {
            action: 'gdprextensioncomyt_load_tab_content',
            tab: ytTabToLoad,
            gdprextensioncomyt_settings_nonce: nonce
        },
        success: function (response) {
            $('#tab-content').html(response.html);
            $('#active-section').val(ytTabToLoad);
            $('#' + ytTabToLoad).addClass('active');
        }
    });
    $(document).ready(function () {
        const initialImagePath = $('#uploaded_image_icon').attr('src');
        if (initialImagePath.includes('/wp-content/plugins/gdpr-extensions-com-youtube/assets/img/gdpr-logo-icon.svg')) {
            $('#uploaded_image_icon').css('background-position', 'center');
            $('#uploaded_image_icon').css('background-size', 'auto');
        }
        else {
            $('#uploaded_image_icon').css('background-position', '');
            $('#uploaded_image_icon').css('background-size', 'cover');
        }
    });
    $(document).ready(function () {
        const basePath = '/wp-content/plugins/gdpr-extensions-com-youtube/assets/img/';
        const defaultIconPath = basePath + 'gdpr-logo-icon.svg';
        const toggleState = localStorage.getItem('gdprToggleState') === 'true';
        if (toggleState) {
            $('#gdprextensioncomyt_managertab_toggle').prop('checked', true);
            $('.yt__file-upload').removeClass('d-none');
            $('.background_color_wrap').addClass('d-none');
        }
        else {
            $('#gdprextensioncomyt_managertab_toggle').prop('checked', false);
            $('.yt__file-upload').addClass('d-none');
            $('.background_color_wrap').removeClass('d-none');
        }

        $('#gdprextensioncomyt_managertab_toggle').on('change', function () {
            const isChecked = $(this).is(':checked');
            localStorage.setItem('gdprToggleState', isChecked);
            if (isChecked) {
                $('.yt__file-upload').removeClass('d-none');
                $('.background_color_wrap').addClass('d-none');
            } else {
                $('.yt__file-upload').addClass('d-none');
                $('.background_color_wrap').removeClass('d-none');
            }
        });

        $('#upload_imagefile').on('change', function (event) {
            const file = event.target.files[0];

            if (file) {
                const fileNameWithPath = `${basePath}${file.name}`;
                $('#hiddenImageName').val(fileNameWithPath);

                const fileReader = new FileReader();
                fileReader.onload = function (e) {
                    const dataUrl = e.target.result;
                    $('#uploaded_image_icon').attr('src', dataUrl);
                    document.documentElement.style.setProperty('--yt--bg-image', `url(${dataUrl})`);

                    const gdprLogoPath = '/wp-content/plugins/gdpr-extensions-com-youtube/assets/img/gdpr-logo-icon.svg';
                    if (dataUrl.includes(gdprLogoPath)) {
                        $('#uploaded_image_icon').css('background-position', 'center');
                        $('#uploaded_image_icon').css('background-size', 'auto');
                    } else {
                        $('#uploaded_image_icon').css('background-position', '');
                        $('#uploaded_image_icon').css('background-size', 'cover');
                    }
                };
                fileReader.readAsDataURL(file);
            }
        });

        $('#yt_remove-icon').on('click', function () {
            $('#uploaded_image_icon').attr('src', defaultIconPath);
            document.documentElement.style.setProperty('--yt--bg-image', `url(${defaultIconPath})`);
            $('#uploaded_image_icon').css('background-position', 'center');
            $('#uploaded_image_icon').css('background-size', 'auto');
            $('#upload_imagefile').val('');
        });
    });

    $('.nav-tab-wrapper a').on('click', function (e) {
        e.preventDefault();
        $('.nav-tab').removeClass('active');
        $(this).addClass('active');
        var tab = $(this).attr('href').substring(1);
        loadYtTabContent(tab);
    });

    jQuery(document).on('click', '.yt__site-details', function () {

        var siteId = $(this).data('id');
        var detailsTable = $('#api-details-' + siteId);
        if (detailsTable.css('display') === 'none') {
            detailsTable.css('display', 'flex');
            $(this).addClass('active');
        } else {
            detailsTable.css('display', 'none');
            $(this).removeClass('active');
        }
    }
    );

    $(document).ready(function () {
        $('.seeExample').on('click', function (event) {
            event.preventDefault();
            $('.popUpoverlay').css('display', 'flex');
        });

        $('#consentBtn').on('click', function (event) {
            event.preventDefault();
            $('#beforeConsent').css('display', 'none');
            $('#afterConsent').css('display', 'flex');
        });

        $('.popUpoverlay').on('click', function (event) {
            if (event.target === this) {
                $(this).css('display', 'none');
            }
        });
    });

    jQuery(document).on('click', '.reset-to-default', function () {
        var inputField = $(this).closest('label').next('input.category-title');
        var inputTagField = $(this).closest('label').next('input.yt__tag-title');


        var defaultValue = inputField.data('title');
        var defaultValueTag = inputTagField.data('title');


        inputField.val(defaultValue);
        inputTagField.val(defaultValueTag);
    });

    jQuery(document).on('click', '#submit_button_id', function (e) {
        e.preventDefault();
        var image_url = $('#upload_imagefile')[0].files[0];
        var site_id = $('#site_id').val();
        var headercolor = $('#gdprextensioncomyt_managertab_header_color').val();
        var headingcolor = $('#gdprextensioncomyt_managertab_heading_color').val();
        var headline = $('#gdprextensioncomyt_managertab_headline').val();
        var overlay_text = $('#gdprextensioncomyt_managertab_overlay_text').val();
        var buttontext = $('#gdprextensioncomyt_managertab_buttontext').val();
        var buttoncolor = $('#gdprextensioncomyt_managertab_btncolor').val();
        var btnbgcolor = $('#gdprextensioncomyt_managertab_button_bgcolor').val();
        var buttonshape = $('#gdprextensioncomyt_managertab_button_shape').val();
        var bgcolor = $('#gdprextensioncomyt_managertab_bgcolor').val();
        var nonce = $('#gdprextensioncomyt_settings_nonce').val();
        const checkbox = document.getElementById('gdprextensioncomyt_managertab_toggle');
        let hiddenInput = document.createElement('input');
        hiddenInput.type = 'hidden';
        hiddenInput.name = 'gdprextensioncomyt_managertab_toggle';
        hiddenInput.value = checkbox.checked ? 'true' : 'false';

        var formData = new FormData();
        formData.append('action', 'gdprextensioncomyt_cookiewidget_save');
        formData.append('site_id', site_id);
        formData.append('heading_color', headingcolor);
        formData.append('headline', headline);
        formData.append('overlay_text', overlay_text);
        formData.append('header_color', headercolor);
        formData.append('buttonbgcolor', btnbgcolor);
        formData.append('buttoncolor', buttoncolor);
        formData.append('buttontext', buttontext);
        formData.append('buttonshape', buttonshape);
        formData.append('bgcolor', bgcolor);
        formData.append('image_url', image_url);
        formData.append('gdprextensioncomyt_managertab_toggle', checkbox.checked);
        formData.append('gdprextensioncomyt_settings_nonce', nonce);


        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            processData: false,
            contentType: false,
            data: formData,

            success: function (response) {
                const successMessage = $('#success-message');
                if (response.success) {

                    successMessage
                        .text(response.data)
                        .css({
                            display: 'block',
                            color: 'white',
                            opacity: '1'
                        })
                    setTimeout(() => {
                        successMessage.animate({ opacity: 0 }, 400, function () {
                            successMessage.css('display', 'none');
                        });
                    }, 2000);
                } else {
                    successMessage
                        .text("Error: " + response.data)
                        .css({
                            display: 'block',
                            color: 'red',
                            opacity: '1'
                        })
                    setTimeout(() => {
                        successMessage.animate({ opacity: 0 }, 400, function () {
                            successMessage.css('display', 'none');
                        });
                    }, 2000);
                }
            },

            error: function (e) {
                // Handle unexpected errors
                console.error(e);
                $('#success-message')
                    .text('Something went wrong. Please try again.')
                    .css('display', 'block')
                    .css('background-color', 'red');
            }

        });
    });
});
