<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>
<div class="grl__wrap">

	<div class="grl__container">
		<div class="grl__title"><?php echo esc_html( 'Google Reviews List' ); ?></div>
		<div class="grl__text"><?php echo esc_html( 'Welcome to the Google Reviews settings page' ); ?></div>

		<form method="post" enctype="multipart/form-data">
			<?php
			wp_nonce_field( 'gdprextensionscomgrl_tab_action', 'gdprextensionscomgrl_tab_nonce' );
			global $wpdb;
			$site_id = get_current_blog_id();

			//@codingStandardsIgnoreStart
			$saved_key = $wpdb->get_var( //db call ok; no-cache ok
				$wpdb->prepare(
					"SELECT reviews_api_key FROM greviews_list_apikey WHERE site_id = %d LIMIT 1",
					$site_id
				)
			);
			//@codeingStandardsIgnoreEnd
			?>

			<div class="grl__wrapper">

				<input type="hidden" id="grl__siteid" name="site_id" value="<?php echo esc_attr( $site_id ); ?>">
				<label for="grl__api_key" class="grl__label grl__semibold">Reviews Hub Key</label>
				<div class="grl__fields">
					<div class="grl__input-wrap">
						<input type="text" id="grl__api_key" name="grl__api_key" size="40"
							class="grl__input" value="<?php echo esc_attr( $saved_key ); ?>" />
						<span id="grl__keyerror-message" class="grl__keyerror-message">Invalid Key</span>
					</div>

					<button type="button" id="grl__save-apikey" class="grl__btn">Connect Hub</button>
					<button type="button" id="grl__run-schedular" class="grl__btn">Get Reviews</button>
					<div class="grl__loader-p d-none">
						<div class="grl__loader"></div>
					</div>
					<div class="grl__loader-done d-none">
						<img src="/wp-content/plugins/gdpr-extensions-com-google-reviews-list-localload-solution/assets/img/tick.svg" alt="">
					</div>
				</div>

			</div>
			<div class="grl__static">
				<div class="grl__static-title"><?php echo esc_html( 'Generate Reviews Hub Key' ); ?></div>
				<div class="grl__text">
					<?php echo esc_html( 'Please follow the below steps in order to generate your reviews hub key.' ); ?>
				</div>
				<div class="grl__steps-wrap">
					<div class="grl__steps">
						<div class="grl__steps-item">
							<div class="grl__steps-title">1. Connect Your Google Account</div>
							<ul class="grl__steps-list">
								<li>Visit <a href="https://dashboard.gdpr-extensions.com/home"
										target="_blank">https://dashboard.gdpr-extensions.com/home</a></li>
								<li>Complete Sign-up</li>
								<li>Visit the reviews hub tool on your GDPR dashboard</li>
								<li>Visit Reviews Sources</li>
								<li>Connect your Google account</li>
							</ul>
						</div>
					</div>
					<div class="grl__steps">
						<div class="grl__steps-item">
							<div class="grl__steps-title">2. Create Reviews Hub</div>
							<ul class="grl__steps-list">
								<li>Navigate to Reviews Hub Tab</li>
								<li>Create a new Reviews Hub</li>
								<li>Select the desired website</li>
								<li>Connect one or multiple Google businesses to this website</li>
								<li>You can also filter the reviews from the filters step</li>
							</ul>
						</div>
					</div>
					<div class="grl__steps">
						<div class="grl__steps-item">
							<div class="grl__steps-title">3. Connect Hub</div>
							<ul class="grl__steps-list">
								<li>From the actions button on the created reviews hub, copy the API key </li>
								<li>Paste the Key above</li>
								<li>Click on "Connect Hub"</li>
								<li>Click on "Get Review"</li>
								<li>When adding the content element the filtered reviews should show successfully on
									your website!</li>
							</ul>
						</div>
					</div>
					<div class="grl__steps">
						<div class="grl__steps-item">
							<div class="grl__steps-title">4. Add Content Element</div>
							<ul class="grl__steps-list">
								<li>Customize content on your desired page,under the section
									"<b>GDPR-Extensions-com</b>"
									you
									can add the content element "<b>Google Reviews List</b>"</li>
								<li>Publish the changes and reviews will show successfully</li>
							</ul>
						</div>
					</div>
					<div class="grl__steps">
						<div class="grl__steps-item">
							<div class="grl__steps-title">Explore more products from GDPR-Extensions</div>
							<div class="grl__steps-img">
							    <div class="grl__image"></div>
								<a href="https://www.gdpr-extensions.com/gdpr-solutions"
									class="grl__btn grl__btn-outlined" target="_blank">Visit</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</form>
	</div>
</div>