import { useBlockProps } from '@wordpress/block-editor';

export default function save({ attributes }) {
	const { buttonTextColor, buttonBgColor, buttonRadius, numberOfReviews } = attributes;
	const dataAttributes = JSON.stringify(attributes);

	const buttonStyle = {
		color: buttonTextColor,
		backgroundColor: buttonBgColor,
		borderRadius: `${buttonRadius}px`,
	};


	return (
		<div {...useBlockProps.save()}>
			<div className="gdpr-extensions-com-google-reviews-list gr-list" data-attributes={dataAttributes}>
				<div class="grl-list__dropdown">
					<div class="grl-list__dropdown-wrapper">
						<label for="grl-list__dropdown-select">Sorting:</label>
						<select id="grl-list__dropdown-select" class="grl-list__dropdown-select">
						<option value="desc" selected>Descending</option>
						<option value="asc">Ascending</option>
						</select>
					</div>
				</div>
				<div className="gr-list__container"></div>
				<div className="gr-list__btn">
					{numberOfReviews > 6 && (
						<button className="gr-list__load-more" style={buttonStyle} > Load More</button>
					)}
				</div>
			</div>
		</div>
	);
}
