import $ from 'jquery';

export function grList() {
  const grList = document.querySelectorAll('.gr-list');


  grList.forEach((grList) => {
    const attributes = grList.dataset.attributes;
    const dataAttributes = JSON.parse(attributes);
    // const reviewsLocation = dataAttributes.reviewsLocation;
    const numberOfReviews = dataAttributes.numberOfReviews;
    const currentBlogId = document.body.getAttribute("data-blog-id");
    let currentPage = 1;
    const numberOfReviewsPerPage = numberOfReviews < 6 ? numberOfReviews : 6;
    const loadMoreButton = grList.querySelector('.gr-list__load-more');


    function fetchReviews() {
      $.ajax({
        url: gdprextensionscomgrl_ajax.ajax_url,
        type: "POST",
        data: {
          action: "gdprextensionscomgrl_get",
          // reviewsLocation: reviewsLocation,
          numberOfReviews: numberOfReviews,
          gdprextensionscomgrl__settings_nonce : gdprextensionscomgrl_ajax.nonce,
          page: currentPage,
          per_page: numberOfReviewsPerPage,
          currentBlogId: currentBlogId,
        },
        success: function (response) {
          // console.log("Response in Main: ", response)
          if (Array.isArray(response) && response.length > 0) {
            mapReviews(grList, response, currentPage, numberOfReviewsPerPage, numberOfReviews);
            readMore();
            styleReview(grList, dataAttributes);
            sortReviewsItem(grList);
            checkLoadMoreButton(grList, currentPage, numberOfReviewsPerPage, numberOfReviews);

          } else {
            console.error("Empty or invalid response received");
          }
        },
        error: function (xhr, status, error) {
          console.error("AJAX request error:", status, error);
        },
      });
    }
    fetchReviews();

    loadMoreButton?.addEventListener('click', () => {
      currentPage++;
      fetchReviews();
    });

    const sortReviews = document.querySelector('.grl-list__dropdown-select');
    sortReviews.addEventListener("change", () => {
      sortReviewsItem(grList);
    })

  });
}

function mapReviews(grList, response, currentPage, numberOfReviewsPerPage, numberOfReviews) {
  const grListContainer = grList.querySelector('.gr-list__container');
  const startIndex = (currentPage - 1) * numberOfReviewsPerPage;
  const endIndex = startIndex + numberOfReviewsPerPage;

  for (let i = startIndex; i < endIndex && i < numberOfReviews; i++) {
    const item = response[i];
    const reviewItem = document.createElement('div');
    reviewItem.classList.add('gr-list__item');

    const reviewerInfo = document.createElement('div');
    reviewerInfo.classList.add('gr-list__reviewer-info');
    reviewerInfo.innerHTML = `
        <img src="${item?.reviewer_profile_photo_url}" alt="Reviewer Photo" class="gr-list__reviewer-photo" />
        <div class="gr-list__info">
          <div class="gr-list__reviewer-name">${item?.reviewer_display_name}</div>
          <div class="gr-list__reviewer-date" data-date="${item.date_sort}">${item?.create_time}</div>
        </div>
      `;

    const reviewInfo = document.createElement('div');
    reviewInfo.classList.add('gr-list__review-info');

    const starRatingContainer = document.createElement('div');
    starRatingContainer.classList.add('gr-list__star-rating');
    starRatingContainer.setAttribute('value', item?.star_rating);

    renderRatingStars(item?.star_rating).forEach((starType, index) => {
      const starElement = document.createElement('i');
      starElement.className = `material-icons gr-list__star`;
      starElement.textContent = starType;
      starRatingContainer.appendChild(starElement);
    });

    const commentElement = document.createElement('div');
    commentElement.classList.add('gr-list__review-text');
    commentElement.textContent = item.comment;

    const reviewSourceElement = document.createElement('div');
    reviewSourceElement.classList.add('gr-list__review-source');
    reviewSourceElement.textContent = `Source: ${item?.source}`;

    reviewInfo.appendChild(starRatingContainer);
    reviewInfo.appendChild(commentElement);
    reviewInfo.appendChild(reviewSourceElement);

    reviewItem.dataset.reviewCounter = i;
    reviewItem.dataset.id = item?.id;

    reviewItem.appendChild(reviewerInfo);
    reviewItem.appendChild(reviewInfo);
    grListContainer.appendChild(reviewItem);
  }

}

function checkLoadMoreButton(grList, currentPage, numberOfReviewsPerPage, numberOfReviews) {
  const loadMoreButton = grList.querySelector('.gr-list__load-more');

  const startIndex = (currentPage - 1) * numberOfReviewsPerPage;
  const endIndex = startIndex + numberOfReviewsPerPage;
  const remainingReviews = numberOfReviews - endIndex;

  if (remainingReviews <= 0 || numberOfReviews <= 6) {
    loadMoreButton?.classList.add('hidden');
  } else {
    loadMoreButton?.classList.remove('hidden');
  }
}

function readMore() {
  const maxLength = 285;
  const reviewTexts = document.querySelectorAll('.gr-list__review-text');

  reviewTexts.forEach((text) => {
    const myStr = text.textContent;

    if (myStr.length > maxLength) {
      const newStr = myStr.substring(0, maxLength);
      const removedStr = myStr.substring(maxLength, myStr.length);
      text.textContent = newStr + ' ';
      const markup = `<div class="gr-list__half-text"><span>${text.textContent}</span><span class="gr-list__half-text--dots"> ...</span><span class="gr-list__more-text"><span>${removedStr}</span></span></div><a class="gr-list__see-less">Show less</a><a class="gr-list__see-more">Show More</a>`;
      text.innerHTML = markup;
    }

    text.addEventListener('click', (e) => {
      if (e.target.classList.contains('gr-list__see-more')) {
        e.target.style.display = 'none';
        e.target.previousElementSibling.style.display = 'inline';
        e.target.previousElementSibling.previousElementSibling.querySelector('.gr-list__half-text--dots').style.display = 'none';
        e.target.previousElementSibling.previousElementSibling.querySelector('.gr-list__more-text').style.display = 'inline';
      } else if (e.target.classList.contains('gr-list__see-less')) {
        e.target.style.display = 'none';
        e.target.nextElementSibling.style.display = 'inline';
        e.target.previousElementSibling.querySelector('.gr-list__half-text--dots').style.display = 'inline';
        e.target.previousElementSibling.querySelector('.gr-list__more-text').style.display = 'none';
      }
    });
  });
}

function styleReview(grList, dataAttributes) {
  const bgColor = dataAttributes.bgColor;
  const textColor = dataAttributes.textColor;
  const borderColor = dataAttributes.borderColor;

  const grListItems = grList.querySelectorAll('.gr-list__item');
  grListItems.forEach((item) => {
    item.style.backgroundColor = bgColor;
    item.style.color = textColor;
    item.style.borderColor = borderColor;
  });
}

function renderRatingStars(star_rating) {
  const fullStars = Math.floor(star_rating);
  const hasHalfStar = star_rating % 1 !== 0;
  let stars = Array(fullStars).fill('star');
  if (hasHalfStar) {
    stars.push('star_half');
  }

  return stars;
}

function sortReviewsItem(grList) {
  const grListCont = grList.querySelector('.gr-list__container');
  const grListItem = grList.querySelectorAll('.gr-list__item');
  const sortOrder = grList.querySelector('.grl-list__dropdown-select').value;
  const grListItemArr = Array.from(grListItem);


  grListItemArr.sort(function (a, b) {
    const timestampA = parseInt(a.querySelector('.gr-list__reviewer-date').dataset.date, 10);
    const timestampB = parseInt(b.querySelector('.gr-list__reviewer-date').dataset.date, 10);

    // Compare the timestamps numerically
    const comparison = timestampA - timestampB;
    // Apply sorting order based on user selection
    return sortOrder === 'asc' ? comparison : -comparison;
  });

  grListCont.innerHTML = '';
  grListItemArr.forEach(function (item) {
    grListCont.appendChild(item);
  });
}
