import { __ } from '@wordpress/i18n';
import { PanelBody, ColorPalette, RangeControl, SelectControl, ToggleControl } from '@wordpress/components';
import { InspectorControls, useBlockProps } from '@wordpress/block-editor';
import { useEffect, useState } from 'react';
import { grList } from './js/main';
import $ from 'jquery';

export default function Edit({ attributes, setAttributes }) {
  const {
    textColor,
    bgColor,
    buttonTextColor,
    buttonBgColor,
    buttonRadius,
    numberOfReviews,
    showAllReviews,
    borderColor,
  } = attributes;

  const currentBlogId = document.body.getAttribute('data-blog-id');
  // const [reviewsApiData, setReviewsApiData] = useState([]);
  const [reviewsCount, setReviewsCount] = useState(1);
  const dataAttributes = JSON.stringify(attributes);

  const buttonStyle = {
    color: buttonTextColor,
    backgroundColor: buttonBgColor,
    borderRadius: `${buttonRadius}px`,
  };

  useEffect(() => {
    fetchReviews();
  }, []);

  useEffect(() => {

    if (!grList.hasRun) {
      grList();
      grList.hasRun = true;
    }
  }, []);

  useEffect(() => {
    if (showAllReviews) {
      setAttributes({ numberOfReviews: reviewsCount });
    }
  }, [showAllReviews, reviewsCount]);

  const fetchReviews = () => {
    $.ajax({
      url: gdprextensionscomgrl_ajax.ajax_url,
      type: "POST",
      data: {
        action: "gdprextensionscomgrl_get",
        gdprextensionscomgrl__settings_nonce : gdprextensionscomgrl_ajax.nonce,
        currentBlogId: currentBlogId,

      },
      success: function (response) {
        // console.log("Response in edit: ",response );
        setReviewsCount(response.length);
      },
      error: function (xhr, status, error) {
        console.error("AJAX request error:", status, error);
      },
    });
  };

  return (
    <div {...useBlockProps()}>
      <InspectorControls>
        <PanelBody title={__('Review Settings', 'gdpr-extensions-com-google-reviews-list-localload-solution')}>
          <ToggleControl
            label={__('Show All Reviews', 'gdpr-extensions-com-google-reviews-list-localload-solution')}
            checked={showAllReviews}
            onChange={(value) => {
              setAttributes({ showAllReviews: value });
            }}
          />
          <RangeControl
            label={__('Number of Reviews', 'gdpr-extensions-com-google-reviews-list-localload-solution')}
            value={numberOfReviews}
            onChange={(value) => setAttributes({ numberOfReviews: value })}
            min={1}
            max={reviewsCount <= 100 ? reviewsCount : 100}
            disabled={showAllReviews}
          />
        </PanelBody>
        <PanelBody title={__('Style', 'gdpr-extensions-com-google-reviews-list-localload-solution')}>
          <div className="button-settings-panel">
            <div className="button-settings-group">
              <label className="button-settings-label">{__('Text Color', 'gdpr-extensions-com-google-reviews-list-localload-solution')}</label>
              <ColorPalette value={textColor} onChange={(value) => setAttributes({ textColor: value })} />
            </div>
            <div className="button-settings-group">
              <label className="button-settings-label">{__('Background Color', 'gdpr-extensions-com-google-reviews-list-localload-solution')}</label>
              <ColorPalette value={bgColor} onChange={(value) => setAttributes({ bgColor: value })} />
            </div>
            <div className="button-settings-group">
              <label className="button-settings-label">{__('Border Color', 'gdpr-extensions-com-google-reviews-list-localload-solution')}</label>
              <ColorPalette value={borderColor} onChange={(value) => setAttributes({ borderColor: value })} />
            </div>
            <div className="button-settings-group">
              <label className="button-settings-label">{__('Button Text Color', 'gdpr-extensions-com-google-reviews-list-localload-solution')}</label>
              <ColorPalette value={buttonTextColor} onChange={(value) => setAttributes({ buttonTextColor: value })} />
            </div>
            <div className="button-settings-group">
              <label className="button-settings-label">{__('Button Background Color', 'gdpr-extensions-com-google-reviews-list-localload-solution')}</label>
              <ColorPalette value={buttonBgColor} onChange={(value) => setAttributes({ buttonBgColor: value })} />
            </div>
            <div className="button-settings-group">
              <label className="button-settings-label">{__('ButtonBorder Radius(px)', 'gdpr-extensions-com-google-reviews-list-localload-solution')}</label>
              <RangeControl value={buttonRadius} onChange={(value) => setAttributes({ buttonRadius: value })} min={0} max={100} />
            </div>
          </div>
        </PanelBody>
      </InspectorControls>

      <div className="gdpr-extensions-com-gdpr-extensions-com-google-reviews-list-localload-solution gr-list" data-attributes={dataAttributes}>
        <div class="grl-list__dropdown">
          <div class="grl-list__dropdown-wrapper">
            <label for="grl-list__dropdown-select">Sorting:</label>
            <select id="grl-list__dropdown-select" class="grl-list__dropdown-select">
              <option value="desc">Descending</option>
              <option value="asc" selected >Ascending</option>
            </select>
          </div>
        </div>

        <div className="gr-list__container"></div>
        <div className="gr-list__btn">
          <button className="gr-list__load-more" style={buttonStyle}>
            Load More
          </button>
        </div>
      </div>
    </div>
  );
}
