<?php
/**
 * Plugin Name:       GDPR-Extensions-com - Google Reviews List Localload Solution
 * Plugin URI:        https://www.gdpr-extensions.com/gdpr-solutions/our-local-load-solutions/google-reviews-list
 * Description:       Showcase Google Reviews on your WordPress site with the GDPR-Extensions-com - Google Reviews List Localload Solution plugin.
 * Requires at least: 6.4
 * Requires PHP:      8.1
 * Version:           1.0.1
 * Author:            GDPR-extensions.com Team
 * Author URI:        https://www.gdpr-extensions.com/
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       gdpr-extensions-com-google-reviews-list-localload-solution
 * Domain Path:       /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'add_action' ) ) {
	echo 'Seems like you have an old version of PHP';
	exit;
}

function gdprextensionscomgrl_block_init() {
	register_block_type( __DIR__ . '/build' );
}
add_action( 'init', 'gdprextensionscomgrl_block_init' );

// Setup
define( 'GDPREXTENSIONCOMGRL_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'GDPREXTENSIONCOMGRL_TEXT_DOMAIN', 'gdpr-extensions-com-google-reviews-list-localload-solution' );
define( 'GDPREXTENSIONCOMGRL_VERSION', '1.0.1' );

function gdprextensionscomgrl_blogid() {
	$current_blog_id = get_current_blog_id();
	wp_add_inline_script( 'jquery', "
        jQuery(document).ready(function($) {
            var body = $('body');
            if (!body.attr('data-blog-id')) {
                body.attr('data-blog-id', '" . esc_attr( $current_blog_id ) . "');
            }
        });
    ");
}

add_action( 'wp_enqueue_scripts', 'gdprextensionscomgrl_blogid' );
add_action( 'admin_enqueue_scripts', 'gdprextensionscomgrl_blogid' );


add_action('init','gdprextensioncomgrl_text_domain_load');

function gdprextensioncomgrl_text_domain_load() {
	load_plugin_textdomain( 'gdpr-extensions-com-google-reviews-list-localload-solution', false, basename( dirname( __FILE__ ) ) . '/languages' );
}

require_once GDPREXTENSIONCOMGRL_PLUGIN_DIR . 'functions/gr-functions.php';
require_once GDPREXTENSIONCOMGRL_PLUGIN_DIR . 'functions/gr-fetch.php';
register_activation_hook( __FILE__, 'gdprextensionscomgrl_activation' );
register_deactivation_hook( __FILE__, 'gdprextensionscomgrl_deactivation' );
add_filter( 'block_categories_all' , "gdprextensionscomgrl_category");




function gdprextensionscomgrl_category( $categories ) {
    $category_slug = 'gdprextensioncom';
    $category_title = 'GDPR-Extensions-Com';

    $category_exists = false;
    foreach ( $categories as $category ) {
        if ( $category['slug'] === $category_slug ) {
            $category_exists = true;
            break;
        }
    }

    // If the category doesn't exist, add it
    if ( ! $category_exists ) {
        $categories[] = array(
            'slug'  => $category_slug,
            'title' => $category_title
        );
    }

    return $categories;
}

function gdprextensionscomgrl_menu() {

	// Check if the menu page already exists
	$menu_slug = 'gdprextensionscom-plugin-settings';
	$exists = false;
	global $menu;
	foreach ( $menu as $item ) {
		if ( $item[2] == $menu_slug ) {
			$exists = true;
			break;
		}
	}

	if ( ! $exists ) {
		add_menu_page(
			null,
			'GDPR-Extensions-Com Admin',
			'manage_options',
			$menu_slug,
		);
	}

	add_submenu_page(
		$menu_slug,
		'Google Reviews List',
		'Google Reviews List',
		'manage_options',
		'gdprextensionscomgrl-submenu',
		'gdprextensionscomgrl_submenu_page'
	);

	remove_submenu_page( $menu_slug, 'gdprextensionscom-plugin-settings' );
}

function gdprextensionscomgrl_submenu_page() {
	require_once ( GDPREXTENSIONCOMGRL_PLUGIN_DIR . 'views/gr-setting.php' );
}

function gdprextensionscomgrl_scripts() {
	wp_enqueue_script(
		'gdprextensionscomgrl-admin-script',
		plugin_dir_url( __FILE__ ) . 'assets/js/gr-admin.js',
		array( 'jquery' ),
		GDPREXTENSIONCOMGRL_VERSION,
		true
	);

	wp_localize_script('gdprextensionscomgrl-admin-script', 'gdprextensionscomgrl_ajax', array(
		'ajax_url' => admin_url('admin-ajax.php'),
		// 'nonce' => wp_create_nonce('gdprextensionscomgrl_ajax-nonce'),
		'nonce' => wp_create_nonce('gdprextensionscomgrl__settings_action'),
	));

	wp_enqueue_script(
		'gdprextensionscomgrl-jquery-script',
		plugin_dir_url( __FILE__ ) . 'assets/js/min.js',
		array( 'jquery' ),
		GDPREXTENSIONCOMGRL_VERSION,
		true
	);

	

	wp_enqueue_style( 'gdprextensionscomgrl-style', plugins_url( 'assets/css/gr-admin.css', __FILE__ ), array(), '1.0.0', 'all' );
}
add_action ('wp_enqueue_scripts', 'gdprextensionscomgrl_scripts');


function gdprextensionscomgrl_activation() {
	gdprextensionscomgrl_apikey_table();
	gdprextensionscomgrl_table();
}

function gdprextensionscomgrl_apikey_table() {
	global $wpdb;

	$table_name = 'greviews_list_apikey';

	$charset_collate = $wpdb->get_charset_collate();

	$sql = "CREATE TABLE $table_name (
		id INT AUTO_INCREMENT PRIMARY KEY,
		site_id int(11),
		SiteName VARCHAR(255) DEFAULT '',
		location_name VARCHAR(255) DEFAULT '',
		reviews_api_key VARCHAR(255),
		is_single_site TINYINT(1) NOT NULL DEFAULT 0
	) $charset_collate;";

	require_once ( ABSPATH . 'wp-admin/includes/upgrade.php' );
	dbDelta( $sql );
}

function gdprextensionscomgrl_table() {
	global $wpdb;

	$table_name = 'greviews_list_table';
	$charset_collate = $wpdb->get_charset_collate();

	$sql = "CREATE TABLE $table_name (
		id INT AUTO_INCREMENT PRIMARY KEY,
		review_id varchar(255) NOT NULL DEFAULT '',
		reviewer_profile_photo_url varchar(255) NOT NULL DEFAULT '',
		reviewer_display_name varchar(255) NOT NULL DEFAULT '',
		star_rating int(11) NOT NULL DEFAULT '0',
		comment text NOT NULL,
		source varchar(255) NOT NULL DEFAULT '',
		reply_comment text,
		reply_time varchar(255),
		create_time varchar(255) NOT NULL DEFAULT '',
		root_pid int(11) NOT NULL DEFAULT '0',
		date_sort int(11) NOT NULL DEFAULT '0',
		locationtitle varchar(255),
		user_location_name varchar(255),
		reviews_api_key VARCHAR(255)
	) $charset_collate;";

	require_once ( ABSPATH . 'wp-admin/includes/upgrade.php' );
	dbDelta( $sql );
}

function gdprextensionscomgrl_deactivation() {
	global $wpdb;
	//@codingStandardsIgnoreStart
	$wpdb->query( "DROP TABLE IF EXISTS greviews_list_table" );	// db call ok; no-cache ok
	$wpdb->query( "DROP TABLE IF EXISTS greviews_list_apikey" );	// db call ok; no-cache ok
	//@codingStandardsIgnoreEnd
}

//Hooks


add_action( 'admin_menu', 'gdprextensionscomgrl_menu' );
add_action( 'admin_enqueue_scripts', 'gdprextensionscomgrl_scripts' );