<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

function gdprextensionscomgrl_apikey_save() {
    global $wpdb;

    if ( ! isset( $_POST['gdprextensionscomgrl__settings_nonce'] ) ||
        ! wp_verify_nonce( sanitize_text_field(wp_unslash($_POST['gdprextensionscomgrl__settings_nonce'])), 'gdprextensionscomgrl__settings_action' ) ) {
            return;
        }

    if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) {
        return;
    }

    if ( ! current_user_can( 'manage_options' ) ) {
        wp_send_json_error( 'Unauthorized access' );
        return;
    }


    $site_id = isset( $_POST['grl__siteid'] ) ? sanitize_text_field( wp_unslash($_POST['grl__siteid'] )) : '';
    $reviews_api_key = isset( $_POST['reviews_api_key'] ) ? sanitize_text_field( wp_unslash($_POST['reviews_api_key'] ) ): '';
    $is_single_site = 1;

    //@codingStandardsIgnoreStart
    $exists = $wpdb->get_var( $wpdb->prepare(    //db call ok; no-cache ok
        "SELECT COUNT(*) FROM `greviews_list_apikey` WHERE `site_id` = %s AND `is_single_site` = %d",
        $site_id, $is_single_site
    ) );

    if ( $exists > 0 ) {
        $result = $wpdb->update(    //db call ok; no-cache ok
            'greviews_list_apikey',
            array( 'reviews_api_key' => $reviews_api_key ),
            array( 'site_id' => $site_id, 'is_single_site' => $is_single_site )
        );
    } else {
        $result = $wpdb->insert(    //db call ok; no-cache ok
            'greviews_list_apikey',
            array(
                'site_id' => $site_id,
                'reviews_api_key' => $reviews_api_key,
                'is_single_site' => $is_single_site
            )
        );

    }
    //@codingStandardsIgnoreEnd
    if ( $result !== false ) {
        wp_send_json_success( 'Data saved successfully' );
    } else {
        wp_send_json_error( 'An error occurred' );
    }

    wp_die();
}

//Hooks
add_action( 'wp_ajax_gdprextensionscomgrl_apikey_save', 'gdprextensionscomgrl_apikey_save' );
add_action( 'wp_ajax_nopriv_gdprextensionscomgrl_apikey_save', 'gdprextensionscomgrl_apikey_save' );

function gdprextensionscomgrl_get() {
    global $wpdb;

    if ( ! isset( $_POST['gdprextensionscomgrl__settings_nonce'] ) ||
        ! wp_verify_nonce( sanitize_text_field(wp_unslash($_POST['gdprextensionscomgrl__settings_nonce'])), 'gdprextensionscomgrl__settings_action' ) ) {
            return;
        }

    if (defined ('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    // if ( ! current_user_can( 'manage_options' ) ) {
    //     wp_send_json_error( 'Unauthorized access' );
    //     return;
    // }

    $numberOfReviews = isset( $_POST['numberOfReviews'] ) ? sanitize_text_field(wp_unslash( $_POST['numberOfReviews'])) : '-1';


    if ( is_multisite() ) {
        $site_id = isset( $_POST['currentBlogId'] ) ? sanitize_text_field( wp_unslash($_POST['currentBlogId'] )) : '';

    } else {
        $site_id = get_current_blog_id();
    }
//@codingStandardsIgnoreStart
    $api_key = $wpdb->get_var( $wpdb->prepare( "SELECT reviews_api_key FROM greviews_list_apikey WHERE site_id = %d", $site_id ) ); //db call ok; no-cache ok

    if ( $numberOfReviews > 0 ) {
        
        $result = $wpdb->get_results(  //db call ok; no-cache ok
            $wpdb->prepare(
                "SELECT * FROM `greviews_list_table` WHERE reviews_api_key = %s LIMIT %d",
                $api_key,
                $numberOfReviews
            )
        );
        //@codingStandardsIgnoreEnd
    } else {
        //@codingStandardsIgnoreStart
        $result = $wpdb->get_results(  //db call ok; no-cache ok
            $wpdb->prepare(
                "SELECT * FROM `greviews_list_table` WHERE reviews_api_key = %s",
                $api_key
            )
        );
        //@codingStandardsIgnoreEnd
    }

    // error_log( print_r( $result, true ) );
    header( 'Content-Type: application/json' );
    wp_die( wp_json_encode( $result ) );
}

add_action( 'wp_ajax_gdprextensionscomgrl_get', 'gdprextensionscomgrl_get' );
add_action( 'wp_ajax_nopriv_gdprextensionscomgrl_get', 'gdprextensionscomgrl_get' );

function gdprextensionscomgrl_validate() {
    if ( ! isset( $_POST['gdprextensionscomgrl__settings_nonce'] ) ||
        ! wp_verify_nonce( sanitize_text_field(wp_unslash($_POST['gdprextensionscomgrl__settings_nonce'])), 'gdprextensionscomgrl__settings_action' ) ) {
            return;
        }

    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    if ( ! current_user_can( 'manage_options' ) ) {
        wp_send_json_error( 'Unauthorized access' );
        return;
    }
    $googleReviewsApiKey = isset( $_POST['reviews_api_key'] ) ? sanitize_text_field( wp_unslash($_POST['reviews_api_key'] )) : '';
    if ( $googleReviewsApiKey ) {
        $url = 'https://dashboard.gdpr-extensions.com/review/api/' . $googleReviewsApiKey . '/authenticate-key.json';
        $args = [ 'method' => 'POST', 'headers' => [ 'Content-Type' => 'application/json' ], 'data_format' => 'body',];
        $response = wp_remote_post( $url, $args );
        $body = wp_remote_retrieve_body( $response );
        $json = json_decode( $body, true );
        $message = $json['message'];
        wp_send_json_success( esc_html( $message ) );
        wp_die();
    }
}

add_action( 'wp_ajax_gdprextensionscomgrl_validate', 'gdprextensionscomgrl_validate' );
add_action( 'wp_ajax_nopriv_gdprextensionscomgrl_validate', 'gdprextensionscomgrl_validate' );