<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function gdprextensionscomgrl_frequency( $schedules ) {
	$schedules['gdprextensionscomgrl_recurrence'] = array(
		'interval' => 43200,
		'display' => __( 'Every Two Minutes', 'gdpr-extensions-com-google-reviews-list-localload-solution' ),
	);
	return $schedules;
}

function gdprextensionscomgrl_fetch() {

	$starRatings = [ 'ZERO' => 0, 'ONE' => 1, 'TWO' => 2, 'THREE' => 3, 'FOUR' => 4, 'FIVE' => 5,];
	$reviewsToolBase = 'https://dashboard.gdpr-extensions.com/';
	global $wpdb;
	$table_name = 'greviews_list_apikey';

	//@codingStandardsIgnoreStart
	$allSites = $wpdb->get_results( "SELECT * FROM `greviews_list_apikey`" );	//db call ok; no-cache ok
	//@codingStandardsIgnoreEnd

	foreach ( $allSites as $site ) {
		$rootPageId = $site->site_id;
		$reviewsApiKey = $site->reviews_api_key;

		if ( $rootPageId != '' && $reviewsApiKey != '' ) {

			$reviewsToolUrl = $reviewsToolBase . 'review/api/' . $reviewsApiKey . '/reviews-list.json';
			$args = array(
				'sslverify' => false,

			);

			$response = wp_remote_get( $reviewsToolUrl, $args );

			// var_dump( $response );
			// die();

			if ( is_wp_error( $response ) ) {
				$error_message = $response->get_error_message();
				echo "Something went wrong: " . esc_html($error_message);

			} else {
				$response_code = wp_remote_retrieve_response_code( $response );
				if ( $response_code == 200 ) {
					try {
						$body = wp_remote_retrieve_body( $response );
						$decoded_response = json_decode( $body, true );

						global $wpdb;
						$table_name = 'greviews_list_table';
						$rootPageId = intval( $rootPageId );
						$reviewsApiKey = sanitize_text_field( $reviewsApiKey );

						//@codingStandardsIgnoreStart
						$result = $wpdb->query( $wpdb->prepare(	//db call ok; no-cache ok
							"DELETE FROM `greviews_list_table` WHERE root_pid = %d AND reviews_api_key = %s",
							$rootPageId,
							$reviewsApiKey )
						);
						//@codingStandardsIgnoreEnd
						
						global $wpdb;
						$table_name = 'greviews_list_table';
						if ( is_array( $decoded_response ) ) {
							foreach ( $decoded_response as $item ) {
								$item['comment'] = gdprextensionscomgrl_strip( $item['comment'] );
								$item['replyComment'] = gdprextensionscomgrl_strip( $item['replyComment'] );
								$item['comment'] = preg_replace( '/[^\p{L}\p{N}\s]/u', '', $item['comment'] );
								$item['replyComment'] = preg_replace( '/[^\p{L}\p{N}\s]/u', '', $item['replyComment'] );
								$reviewerPhotoUrl = '';
								
								if ( isset( $item['reviewerProfilePhotoUrl'] ) ) {
									$grlImg = wp_remote_get( $item['reviewerProfilePhotoUrl'] );
									if ( ! is_wp_error( $grlImg ) && wp_remote_retrieve_response_code( $grlImg ) === 200 ) {
										global $wp_filesystem;
										WP_Filesystem();
								
										$subdirectory = 'grl_grid'; 
										$upload_dir = wp_upload_dir();
										$upload_path = trailingslashit( $upload_dir['basedir'] .'/'. $subdirectory );
										$upload_url = trailingslashit( $upload_dir['baseurl'] .'/'. $subdirectory );
										
										$wp_filesystem->mkdir( $upload_path );
								
										$grlPhoto = wp_remote_retrieve_body( $grlImg );
										$filename = md5( $item['reviewerProfilePhotoUrl'] ) . '.png';
										$file_path = $upload_path . $filename;
								
										if ( $wp_filesystem->put_contents( $file_path, $grlPhoto, FS_CHMOD_FILE ) ) {
											$reviewerPhotoUrl = $upload_url . $filename;
										}
									}
								}
								
							
								$data = array(
									'review_id' => sanitize_text_field( $item['reviewId'] ),
									'reviewer_display_name' => sanitize_text_field( $item['reviewerDisplayName'] ),
									'reviews_api_key' => sanitize_text_field( $reviewsApiKey ),
									'root_pid' => intval( $rootPageId ),
									'comment' => sanitize_textarea_field( $item['comment'] ),
									'reply_comment' => sanitize_textarea_field( $item['replyComment'] ),
									'source' => sanitize_text_field( $item['source'] ),
									'star_rating' => isset( $starRatings[ $item['starRating'] ] ) ? intval( $starRatings[ $item['starRating'] ] ) : 0,
									'locationtitle' => sanitize_text_field( $item['locationtitle'] ),
									'user_location_name' => sanitize_text_field( $site->location_name ),
									'create_time' => isset( $item['createTime']['date'] ) ? sanitize_text_field( gmdate( 'd. M Y', strtotime( $item['createTime']['date'] ) ) ) : '',
									'reply_time' => isset( $item['replyTime']['date'] ) ? sanitize_text_field( gmdate( 'd. M Y', strtotime( $item['replyTime']['date'] ) ) ) : '',
									'date_sort' => isset( $item['createTime']['date'] ) ? intval( strtotime( $item['createTime']['date'] ) ) : 0,
									'reviewer_profile_photo_url' => esc_url_raw( $reviewerPhotoUrl )
								);

								//@codingStandardsIgnoreStart
								$wpdb->insert( $table_name, $data );	//db call ok; no-cache ok
								//@codingStandardsIgnoreEnd

								if ( $result === false ) {
									echo "Error: " . esc_html( $wpdb->last_error );
								}
							}
						}
					} catch (Exception $e) {

						echo esc_html( $e->getMessage() );
						
					}
				}

			}
		}

	}
}

function gdprextensionscomgrl_schedule() {
	if ( ! wp_next_scheduled( 'gdprextensionscomgrl_event' ) ) {
		wp_schedule_event( time(), 'gdprextensionscomgrl_recurrence', 'gdprextensionscomgrl_event' );
	}
}

function gdprextensionscomgrl_runscheduler() {
	gdprextensionscomgrl_fetch();
	echo 'Schedular Executed Successfully';
	wp_die();

}
function gdprextensionscomgrl_strip( $comment ) {
	if ( preg_match( "#^\(Translated by Google\)(.*?)\(Original\)(.*)$#ms", $comment, $matches ) ) {
		return trim( $matches[2] );
	} elseif ( preg_match( "#^(.*)\(Translated by Google\)(.*)$#ms", $comment, $matches ) ) {
		return trim( $matches[1] );
	} else {
		return $comment;
	}
}

//Hooks
add_filter( 'cron_schedules', 'gdprextensionscomgrl_frequency' );
add_action( 'gdprextensionscomgrl_event', 'gdprextensionscomgrl_fetch' );
add_action( 'wp', 'gdprextensionscomgrl_schedule' );
add_action( 'wp_ajax_gdprextensionscomgrl_runscheduler', 'gdprextensionscomgrl_runscheduler' );
add_action( 'wp_ajax_nopriv_gdprextensionscomgrl_runscheduler', 'gdprextensionscomgrl_runscheduler' );