jQuery(function ($) {

    const grlLoaderContainer = $('.grl__loader-p');
    const grlVerifyKey = $('#grl__save-apikey');
    const grlInputField = $('#grl__api_key');
    // const errField = $('#grl__fields-error');
    const grlfetchReviews = $('#grl__run-schedular');


    grlVerifyKey.prop('disabled', grlInputField.val() === '');
    grlfetchReviews.prop('disabled', grlInputField.val() === '');
    
    grlVerifyKey.on('click', function () {

        grlLoaderContainer.removeClass('d-none');
        grlVerifyKey.prop('disabled', true);
        grlfetchReviews.prop('disabled', true);

        const currentKey = grlInputField.val();
        const siteId = $('#grl__siteid').val();

        $.ajax({
            // url: ajaxurl,
            url: gdprextensionscomgrl_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'gdprextensionscomgrl_validate',
                gdprextensionscomgrl__settings_nonce: gdprextensionscomgrl_ajax.nonce,
                reviews_api_key: currentKey
            },
            success: function (response) {
                grlLoaderContainer.addClass('d-none');
                // grlVerifyKey.prop('disabled', false);
                // grlfetchReviews.prop('disabled', false);

                if (response === 'invalid key') {
                    displayPopup('Failed to connect hub', 'fail');
                    grlInputField.addClass('grl__keyerror');
                    // errField.removeClass('d-none');
                } else {   
                    $.ajax({
                        // url: ajaxurl,
                        url: gdprextensionscomgrl_ajax.ajax_url,
                        type: 'POST',
                        data: {
                            action: 'gdprextensionscomgrl_apikey_save',
                            gdprextensionscomgrl__settings_nonce: gdprextensionscomgrl_ajax.nonce,
                            grl__siteid: siteId,
                            reviews_api_key: currentKey
                        },
                        success: function (response) {
                            grlInputField.removeClass('grl__keyerror');
                            // errField.addClass('d-none');
                            displayPopup('Hub Connected Successfully', 'success');
                        },
                        error: function () {
                            displayPopup('Failed to connect hub', 'fail');
                        }
                    });
                }
            },
            error: function () {
                grlLoaderContainer.addClass('d-none');
                grlVerifyKey.prop('disabled', false);
                displayPopup('An error occurred while validating the API key.', 'fail');
            }
        });
    });

    grlfetchReviews.on('click', function () {
        grlLoaderContainer.removeClass('d-none');
        grlfetchReviews.prop('disabled', true);
        grlVerifyKey.prop('disabled', true);

        $.ajax({
            // url: ajaxurl,
            url: gdprextensionscomgrl_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'gdprextensionscomgrl_runscheduler',
                gdprextensionscomgrl__settings_nonce: gdprextensionscomgrl_ajax.nonce
            },
            success: function (response) {
                // console.log("Sechedular Response:", response);
                grlLoaderContainer.addClass('d-none');
                // grlfetchReviews.prop('disabled', false);
                // grlVerifyKey.prop('disabled', false);
                displayPopup(response, 'success');
            },
            error: function (response) {
                grlLoaderContainer.addClass('d-none');
                // grlfetchReviews.prop('disabled', false);
                // grlVerifyKey.prop('disabled', false);
                displayPopup('Failed to connect hub', 'fail');
            }
        });
    });

    function displayPopup(message, type) {
        const popup = $('<div class="grl__popup ' + type + '"><div class="grl__popup-txt">' + message + '</div></div>');
        $('body').append(popup);
        setTimeout(function () {
            popup.addClass('active');
        }, 100);
        setTimeout(function () {
            popup.remove();
            grlVerifyKey.prop('disabled', false);
            grlfetchReviews.prop('disabled', false);
        }, 3000);
    }

    grlInputField.on('input', function () {
        grlVerifyKey.prop('disabled', $(this).val() === '');
        grlfetchReviews.prop('disabled', $(this).val() === '');
    });
});