<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class GWCPA_Admin {

    public function __construct() {
        add_filter( 'woocommerce_coupon_data_tabs', [ $this, 'add_coupon_data_tab' ], 100 );
        add_action( 'woocommerce_coupon_data_panels', [ $this, 'add_coupon_data_panel' ] );
        add_action( 'woocommerce_process_shop_coupon_meta', [ $this, 'save_coupon_tab_data' ], 10, 1 );
        add_action( 'admin_menu', [ $this, 'add_options_page' ] );
        add_action( 'admin_init', [ $this, 'register_settings' ] );
        add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_admin_assets' ] );
    }



public function add_coupon_data_tab( $tabs ) {
    $tabs['gateway_restriction'] = array(
        'label'  => __( 'Gateway Restriction', 'gateway-coupon-assistant' ),
        'target' => 'gwcpa_coupon_data',
        'class'  => 'gwcpa_coupon_data',
    );
    return $tabs;
}

public function add_coupon_data_panel() {
    wp_nonce_field( 'gwcpa_save_coupon_data_action', 'gwcpa_coupon_data_nonce' );
    global $post;
    $coupon_id = $post->ID;
    
    echo '<div id="gwcpa_coupon_data" class="panel woocommerce_options_panel hidden">';
    
    echo '<div class="options_group">';
    if ( ! $coupon_id ) {
        echo '<p>' . esc_html__( 'Please save the coupon first to set restrictions.', 'gateway-coupon-assistant' ) . '</p>';
    } else {
        $payment_gateways = WC()->payment_gateways->get_available_payment_gateways(); $gateway_options  = [];
        if ( $payment_gateways ) { foreach ( $payment_gateways as $gateway ) { $gateway_options[ $gateway->id ] = $gateway->get_title(); } }
        woocommerce_wp_select(array(
            'id' => GWCPA_META_KEY, 'name' => GWCPA_META_KEY . '[]', 'label' => __( 'Allowed Payment Gateways', 'gateway-coupon-assistant' ),
            'description' => __( 'This coupon will only be valid for the selected gateways. Leave empty for no restriction.', 'gateway-coupon-assistant' ),
            'desc_tip' => true, 'class' => 'wc-enhanced-select', 'style' => 'width: 50%;', 'options' => $gateway_options,
            'value' => get_post_meta( $coupon_id, GWCPA_META_KEY, true ),
            'custom_attributes' => [ 'multiple' => 'multiple', 'data-placeholder' => __( 'Select one or more gateways...', 'gateway-coupon-assistant' ) ]
        ));
    }
    echo '</div>';

    echo '<div class="options_group gwcpa_discount_cap_wrapper">';
    woocommerce_wp_text_input( array(
        'id'          => '_gwcpa_discount_cap',
        'label'       => __( 'Discount Cap', 'gateway-coupon-assistant' ) . ' (' . get_woocommerce_currency_symbol() . ')',
        'placeholder' => __( 'No limit', 'gateway-coupon-assistant' ),
        'description' => __( 'Set a maximum discount amount for this percentage coupon. Leave blank for no limit.', 'gateway-coupon-assistant' ),
        'desc_tip'    => true,
        'type'        => 'number',
        'custom_attributes' => array(
            'step' 	=> 'any',
            'min'	=> '0'
        )
    ) );
    echo '</div>';
    
    echo '</div>';
    
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            function toggleDiscountCapField() {
                if ( $('select#discount_type').val() === 'percent' ) {
                    $('.gwcpa_discount_cap_wrapper').show();
                } else {
                    $('.gwcpa_discount_cap_wrapper').hide();
                }
            }
            toggleDiscountCapField();
            $('select#discount_type').on('change', toggleDiscountCapField);
        });
    </script>
    <?php
}

public function save_coupon_tab_data( $post_id ) {
    if ( ! isset( $_POST['gwcpa_coupon_data_nonce'] ) || ! wp_verify_nonce( sanitize_key( $_POST['gwcpa_coupon_data_nonce'] ), 'gwcpa_save_coupon_data_action' ) ) {
        return;
    }
    
    // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
    $gateways = isset( $_POST[ GWCPA_META_KEY ] ) ? wp_unslash( (array) $_POST[ GWCPA_META_KEY ] ) : [];
    $sanitized_gateways = array_map( 'sanitize_text_field', $gateways );
    if ( ! empty( $sanitized_gateways ) ) { 
        update_post_meta( $post_id, GWCPA_META_KEY, $sanitized_gateways ); 
    } else { 
        delete_post_meta( $post_id, GWCPA_META_KEY ); 
    }

    if ( isset( $_POST['_gwcpa_discount_cap'] ) ) {
        $discount_cap = '' === $_POST['_gwcpa_discount_cap'] ? '' : wc_format_decimal( sanitize_text_field( wp_unslash( $_POST['_gwcpa_discount_cap'] ) ) );
        update_post_meta( $post_id, '_gwcpa_discount_cap', $discount_cap );
    }
}

    public function add_options_page() {
        add_submenu_page('woocommerce', __( 'Coupon Gateway Settings', 'gateway-coupon-assistant' ), __( 'Gateway Coupons', 'gateway-coupon-assistant' ), 'manage_woocommerce', 'gateway-coupon-assistant-settings', [ $this, 'render_options_page' ]);
    }

    public function render_options_page() {
        ?>
        <div class="wrap cyg-settings-wrap">
            <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
            <?php settings_errors(); ?>
            <h2 class="nav-tab-wrapper">
                <a href="#tab-1" class="nav-tab nav-tab-active"><?php esc_html_e( 'Main Banner Content', 'gateway-coupon-assistant' ); ?></a>
                <a href="#tab-2" class="nav-tab"><?php esc_html_e( 'Banner Display Locations', 'gateway-coupon-assistant' ); ?></a>
                <a href="#tab-3" class="nav-tab"><?php esc_html_e( 'Error Message Settings', 'gateway-coupon-assistant' ); ?></a>
                <a href="#tab-4" class="nav-tab"><?php esc_html_e( 'About & Support', 'gateway-coupon-assistant' ); ?></a>
            </h2>
            <form action="options.php" method="post">
                <?php settings_fields( 'GWCPA_settings_group' ); ?>
                <div id="tab-1" class="tab-content active"><?php do_settings_sections( 'GWCPA_banner_content_section' ); ?></div>
                <div id="tab-2" class="tab-content"><?php do_settings_sections( 'GWCPA_locations_section' ); ?></div>
                <div id="tab-3" class="tab-content"><?php do_settings_sections( 'GWCPA_error_section' ); ?></div>
                <div id="tab-4" class="tab-content"><?php do_settings_sections( 'GWCPA_about_section' ); ?></div>
                <?php submit_button(); ?>
            </form>
        </div>
        <?php
    }

    public function register_settings() {
 register_setting( 'GWCPA_settings_group', GWCPA_OPTION_NAME, [ $this, 'sanitize_settings' ] );

    $section_banner = 'GWCPA_banner_content_section';
    add_settings_section( $section_banner, null, null, $section_banner );

    add_settings_field( 
        'featured_coupon_code', 
        __( 'Coupon Code to Display', 'gateway-coupon-assistant' ), 
        [ $this, 'render_text_field' ], 
        $section_banner, 
        $section_banner, 
        [ 
            'id' => 'featured_coupon_code', 
            'desc' => __( 'Enter the coupon code you want to display in the banner.', 'gateway-coupon-assistant' ) 
        ] 
    );
    
    add_settings_field( 
        'banner_message', 
        __( 'Custom Banner Message', 'gateway-coupon-assistant' ), 
        [ $this, 'render_textarea_field' ], 
        $section_banner, 
        $section_banner, 
        [ 
            'id' => 'banner_message', 
            'desc' => __( 'Use the shortcodes: <code>{gateway_names}</code>, <code>{coupon_amount}</code>, and <code>{coupon_code}</code>.', 'gateway-coupon-assistant' ), 
            'default' => __( 'Get {coupon_amount} OFF with code {coupon_code} when you pay with {gateway_names}.', 'gateway-coupon-assistant' ) 
        ] 
    );
    
    add_settings_field( 
        'banner_template', 
        __( 'Banner Template', 'gateway-coupon-assistant' ), 
        [ $this, 'render_select_field' ], 
        $section_banner, 
        $section_banner, 
        [ 
            'id' => 'banner_template', 
            'options' => [ 
                'style1' => __( 'Style 1 - Classic', 'gateway-coupon-assistant' ), 
                'style2' => __( 'Style 2 - Modern', 'gateway-coupon-assistant' ), 
                'style3' => __( 'Style 3 - Flat', 'gateway-coupon-assistant' ) 
            ] 
        ] 
    );
    
    add_settings_field( 'primary_color', __( 'Primary Background Color', 'gateway-coupon-assistant' ), [ $this, 'render_color_field' ], $section_banner, $section_banner, [ 'id' => 'primary_color', 'default' => '#26a69a' ] );
    add_settings_field( 'text_color', __( 'Primary Text Color', 'gateway-coupon-assistant' ), [ $this, 'render_color_field' ], $section_banner, $section_banner, [ 'id' => 'text_color', 'default' => '#ffffff' ] );
    add_settings_field( 'accent_color', __( 'Accent Color', 'gateway-coupon-assistant' ), [ $this, 'render_color_field' ], $section_banner, $section_banner, [ 'id' => 'accent_color', 'default' => '#f2bf1a', 'desc' => __( 'Used for highlighting parts like the gateway name in "Style 3 - Flat".', 'gateway-coupon-assistant' ) ] );

    $section_locations = 'GWCPA_locations_section';
    add_settings_section( $section_locations, null, null, $section_locations );

    add_settings_field( 'location_1_enabled', __( '1. Above payment gateways', 'gateway-coupon-assistant' ), [ $this, 'render_checkbox_field' ], $section_locations, $section_locations, [ 'id' => 'location_1_enabled', 'label' => __( '(Checkout page)', 'gateway-coupon-assistant' ) ] );
    add_settings_field( 'location_1_visibility', __( 'Device Visibility', 'gateway-coupon-assistant' ), [ $this, 'render_select_field' ], $section_locations, $section_locations, [ 'id' => 'location_1_visibility', 'options' => [ 'all' => __( 'All Devices', 'gateway-coupon-assistant' ), 'desktop' => __( 'Desktop Only', 'gateway-coupon-assistant' ), 'mobile' => __( 'Mobile Only', 'gateway-coupon-assistant' ) ] ] );
    
    add_settings_field( 'location_2_enabled', __( '2. Below coupon field', 'gateway-coupon-assistant' ), [ $this, 'render_checkbox_field' ], $section_locations, $section_locations, [ 'id' => 'location_2_enabled', 'label' => __( '(Checkout page)', 'gateway-coupon-assistant' ) ] );
    add_settings_field( 'location_2_visibility', __( 'Device Visibility', 'gateway-coupon-assistant' ), [ $this, 'render_select_field' ], $section_locations, $section_locations, [ 'id' => 'location_2_visibility', 'options' => [ 'all' => __( 'All Devices', 'gateway-coupon-assistant' ), 'desktop' => __( 'Desktop Only', 'gateway-coupon-assistant' ), 'mobile' => __( 'Mobile Only', 'gateway-coupon-assistant' ) ] ] );
    
    add_settings_field( 'location_3_enabled', __( '3. Above cart totals', 'gateway-coupon-assistant' ), [ $this, 'render_checkbox_field' ], $section_locations, $section_locations, [ 'id' => 'location_3_enabled', 'label' => __( '(Cart page)', 'gateway-coupon-assistant' ) ] );
    add_settings_field( 'location_3_visibility', __( 'Device Visibility', 'gateway-coupon-assistant' ), [ $this, 'render_select_field' ], $section_locations, $section_locations, [ 'id' => 'location_3_visibility', 'options' => [ 'all' => __( 'All Devices', 'gateway-coupon-assistant' ), 'desktop' => __( 'Desktop Only', 'gateway-coupon-assistant' ), 'mobile' => __( 'Mobile Only', 'gateway-coupon-assistant' ) ] ] );

    $section_error = 'GWCPA_error_section';
    add_settings_section( $section_error, null, null, $section_error );

    add_settings_field( 
        'validation_error_message', 
        __( 'Error Message Text', 'gateway-coupon-assistant' ), 
        [ $this, 'render_textarea_field' ], 
        $section_error, 
        $section_error, 
        [ 
            'id' => 'validation_error_message', 
            'desc' => __( 'Use the shortcodes <code>{coupon_code}</code> and <code>{gateway_names}</code>.', 'gateway-coupon-assistant' ), 
            'default' => __( 'Sorry, the coupon code {coupon_code} is only valid for payment with {gateway_names}.', 'gateway-coupon-assistant' ) 
        ] 
    );

    add_settings_section( 'GWCPA_about_section', '', [ $this, 'render_about_section' ], 'GWCPA_about_section' );
    }

    public function sanitize_settings( $input ) {
        $output = get_option( GWCPA_OPTION_NAME, [] );
        $text_fields = ['featured_coupon_code', 'banner_template', 'location_1_visibility', 'location_2_visibility', 'location_3_visibility'];
        $textarea_fields = ['banner_message', 'validation_error_message'];
        $color_fields = ['primary_color', 'text_color', 'accent_color'];
        $checkbox_fields = ['location_1_enabled', 'location_2_enabled', 'location_3_enabled'];

        foreach ($text_fields as $field) { if (isset($input[$field])) $output[$field] = sanitize_text_field($input[$field]); }
        foreach ($textarea_fields as $field) { if (isset($input[$field])) $output[$field] = sanitize_textarea_field($input[$field]); }
        foreach ($color_fields as $field) { if (isset($input[$field])) $output[$field] = sanitize_hex_color($input[$field]); }
        foreach ($checkbox_fields as $field) { $output[$field] = (isset($input[$field]) && $input[$field] == 1) ? 1 : 0; }
        
        return $output;
    }

    public function render_text_field( $args ) {
    $options = get_option( GWCPA_OPTION_NAME, [] );
    $value   = isset( $options[ $args['id'] ] ) ? $options[ $args['id'] ] : '';
    
    printf(
        '<input type="text" id="%s" name="%s[%s]" value="%s" class="regular-text">',
        esc_attr( $args['id'] ),
        esc_attr( GWCPA_OPTION_NAME ),
        esc_attr( $args['id'] ),
        esc_attr( $value )
    );

    if ( isset( $args['desc'] ) ) {
        echo '<p class="description">' . wp_kses_post( $args['desc'] ) . '</p>';
    }
}

public function render_textarea_field( $args ) {
    $options = get_option(GWCPA_OPTION_NAME, [] );
    $value   = isset( $options[ $args['id'] ] ) ? $options[ $args['id'] ] : ( isset( $args['default'] ) ? $args['default'] : '' );
    
    printf(
        '<textarea id="%s" name="%s[%s]" rows="4" class="large-text">%s</textarea>',
        esc_attr( $args['id'] ),
        esc_attr( GWCPA_OPTION_NAME ),
        esc_attr( $args['id'] ),
        esc_textarea( $value )
    );

    if ( isset( $args['desc'] ) ) {
        echo '<p class="description">' . wp_kses_post( $args['desc'] ) . '</p>';
    }
}

public function render_checkbox_field( $args ) {
    $options = get_option( GWCPA_OPTION_NAME, [] );
    $value   = isset( $options[ $args['id'] ] ) ? $options[ $args['id'] ] : 0;
    
    printf(
        '<label><input type="checkbox" id="%s" name="%s[%s]" value="1" %s> %s</label>',
        esc_attr( $args['id'] ),
        esc_attr( GWCPA_OPTION_NAME ),
        esc_attr( $args['id'] ),
        checked( 1, $value, false ),
        esc_html( $args['label'] )
    );
}

public function render_select_field( $args ) {
    $options = get_option( GWCPA_OPTION_NAME, [] );
    $value   = isset( $options[ $args['id'] ] ) ? $options[ $args['id'] ] : '';
    
    printf(
        '<select id="%s" name="%s[%s]">',
        esc_attr( $args['id'] ),
        esc_attr( GWCPA_OPTION_NAME ),
        esc_attr( $args['id'] )
    );

    foreach ( $args['options'] as $key => $label ) {
        printf(
            '<option value="%s" %s>%s</option>',
            esc_attr( $key ),
            selected( $value, $key, false ),
            esc_html( $label )
        );
    }

    echo '</select>';
}

public function render_color_field( $args ) {
    $options = get_option( GWCPA_OPTION_NAME, [] );
    $value   = isset( $options[ $args['id'] ] ) ? $options[ $args['id'] ] : ( isset( $args['default'] ) ? $args['default'] : '' );
    
    printf(
        '<input type="text" id="%s" name="%s[%s]" value="%s" class="cyg-color-picker">',
        esc_attr( $args['id'] ),
        esc_attr( GWCPA_OPTION_NAME ),
        esc_attr( $args['id'] ),
        esc_attr( $value )
    );

    if ( isset( $args['desc'] ) ) {
        echo '<p class="description">' . wp_kses_post( $args['desc'] ) . '</p>';
    }
}
    
     public function render_about_section() {
        $about_html = '<div style="background-color: #fff; padding: 20px; border-left: 4px solid #46b450; margin-top: 1px;"><h3 style="margin-top: 0;">' . esc_html__( 'How to Use This Plugin', 'gateway-coupon-assistant' ) . '</h3><p>' . esc_html__( 'This plugin allows you to create special marketing campaigns by restricting coupons to specific payment gateways. Here is the simple workflow:', 'gateway-coupon-assistant' ) . '</p><ol style="padding-right: 20px;"><li>' . esc_html__( 'Go to WooCommerce > Coupons and create or edit a coupon.', 'gateway-coupon-assistant' ) . '</li><li>' . esc_html__( 'In the "Gateway Restriction" tab, select the payment gateways for which this coupon should be valid.', 'gateway-coupon-assistant' ) . '</li><li>' . esc_html__( 'In the settings on this page, configure the promotional banner to inform your customers about this special offer.', 'gateway-coupon-assistant' ) . '</li></ol><hr style="margin: 25px 0;"><h3 style="margin-top: 0;">' . esc_html__( 'About the Creators', 'gateway-coupon-assistant' ) . '</h3><p style="margin-bottom: 8px;">' . esc_html__( 'Developer:', 'gateway-coupon-assistant' ) . ' <strong>' . esc_html__( 'amin hosseini', 'gateway-coupon-assistant' ) . '</strong> - <a href="https://nooghteh.ir/" target="_blank">' . esc_html__( 'Visit Website', 'gateway-coupon-assistant' ) . '</a></p><p style="margin-top: 0;">' . esc_html__( 'Designer:', 'gateway-coupon-assistant' ) . ' <strong>' . esc_html__( 'javad darvishi', 'gateway-coupon-assistant' ) . '</strong> - <a href="https://nooghteh.ir/" target="_blank">' . esc_html__( 'Visit Website', 'gateway-coupon-assistant' ) . '</a></p><hr style="margin: 25px 0;"><p style="text-align: center; font-size: 1.1em;">' . esc_html__( 'Enjoying the plugin?', 'gateway-coupon-assistant' ) . ' <a href="https://wordpress.org/plugins/gateway-coupon-assistant/" target="_blank" style="text-decoration: none; vertical-align: middle;"><span style="color: #ffb900;">&#9733;&#9733;&#9733;&#9733;&#9733;</span> ' . esc_html__( 'Please leave us a rating!', 'gateway-coupon-assistant' ) . '</a></p><p style="text-align: center; margin-top: 20px; color: #777; font-size: 13px;">' . esc_html__( 'Designed with', 'gateway-coupon-assistant' ) . ' <span style="color: #e25555;">&hearts;</span> ' . esc_html__( 'by nooghteh.ir', 'gateway-coupon-assistant' ) . '</p></div>';
        echo wp_kses_post( $about_html );
    }
    
    public function enqueue_admin_assets($hook) {
        if ( 'woocommerce_page_gateway-coupon-assistant-settings' != $hook ) { return; }
        wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_script( 'wp-color-picker' );
        $custom_js = "jQuery(document).ready(function($){ $('.cyg-color-picker').wpColorPicker(); var tabs = $('.cyg-settings-wrap .nav-tab-wrapper a'); var tabContents = $('.cyg-settings-wrap .tab-content'); tabs.on('click', function(e){ e.preventDefault(); tabs.removeClass('nav-tab-active'); $(this).addClass('nav-tab-active'); tabContents.removeClass('active'); $(this.hash).addClass('active'); }); });";
        wp_add_inline_style( 'wp-admin', '.cyg-settings-wrap .tab-content { display: none; } .cyg-settings-wrap .tab-content.active { display: block; } .cyg-settings-wrap .form-table th { padding-left: 0; } .cyg-settings-wrap .form-table { margin-top: 0; }' );
        wp_add_inline_script( 'wp-color-picker', $custom_js );
    }
}