<?php
/**
 * Plugin Name:       Gateway Coupon Assistant
 * Plugin URI:        https://wordpress.org/plugins/gateway-coupon-assistant/
 * Description:       Create and manage WooCommerce coupons that are only valid for specific payment gateways. Display promotional banners to boost sales.
 * Version:           1.2.0 
 * Requires Plugins: woocommerce
 * Author:            amin hosseini
 * Author URI:        https://profiles.wordpress.org/aminh19/
 * License:           GPL v2 or later
 * Text Domain:       gateway-coupon-assistant
 * Domain Path:       /languages
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'GWCPA_VERSION', '1.2.0' );
define( 'GWCPA_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'GWCPA_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'GWCPA_META_KEY', '_gwcpa_payment_gateways' );
define( 'GWCPA_OPTION_NAME', 'gateway_coupon_assistant_settings' );

function gwcpa_run_plugin() {
    if ( ! class_exists( 'WooCommerce' ) ) {
        add_action( 'admin_notices', 'gwcpa_woocommerce_not_active_notice' );
        return;
    }

    require_once GWCPA_PLUGIN_DIR . 'includes/class-gwcpa-admin.php'; 
    require_once GWCPA_PLUGIN_DIR . 'includes/class-gwcpa-frontend.php'; 

    new GWCPA_Admin(); 
    new GWCPA_Frontend(); 
}
add_action( 'plugins_loaded', 'gwcpa_run_plugin', 10 );

function gwcpa_woocommerce_not_active_notice() {
    printf(
        '<div class="notice notice-error"><p>%s</p></div>',
        esc_html__( 'Gateway Coupon Assistant plugin requires WooCommerce to be installed and active.', 'gateway-coupon-assistant' )
    );
}