jQuery(function ($) {

    function updateCouponTriggersStatus() {
        $('.gwcpa-apply-coupon-trigger').each(function() {
            var trigger = $(this);
            var couponCode = trigger.data('coupon-code');
            
            if (!trigger.data('original-text')) {
                trigger.data('original-text', trigger.html());
            }

            if ( $('.woocommerce-remove-coupon[data-coupon="' + couponCode.toLowerCase() + '"]').length > 0 ) {
                 trigger.html(gwcpa_ajax_vars.applied_text).addClass('gwcpa-applied').css({'opacity': '0.6', 'cursor': 'default', 'pointer-events': 'none'});
            } else {
                trigger.html(trigger.data('original-text')).removeClass('gwcpa-applied').css({'opacity': '1', 'cursor': 'pointer', 'pointer-events': 'auto'});
            }
        });
    }

    updateCouponTriggersStatus();
    $(document.body).on('updated_cart_totals updated_checkout applied_coupon removed_coupon', function() {
        setTimeout(updateCouponTriggersStatus, 200);
    });

    $(document.body).on('click', '.gwcpa-apply-coupon-trigger', function(e) {
        e.preventDefault();
        e.stopPropagation();

        var trigger = $(this);
        var couponCode = trigger.data('coupon-code');
        
        if (trigger.hasClass('gwcpa-loading') || trigger.hasClass('gwcpa-applied')) {
            return;
        }
        
        if (!trigger.data('original-text')) {
            trigger.data('original-text', trigger.html());
        }
        var originalText = trigger.data('original-text');
        
        trigger.addClass('gwcpa-loading').html(gwcpa_ajax_vars.applying_text);

        $.ajax({
            type: 'POST',
            url: gwcpa_ajax_vars.ajax_url,
            data: {
                action: 'gwcpa_apply_coupon',
                coupon_code: couponCode,
                security: gwcpa_ajax_vars.nonce,
            },
            dataType: 'json',
            success: function(response) {
                if ($('body').hasClass('woocommerce-cart')) {
                    $(document.body).trigger('wc_update_cart'); 
                } else if ($('body').hasClass('woocommerce-checkout')) {
                    $(document.body).trigger('update_checkout');
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                trigger.removeClass('gwcpa-loading').html(gwcpa_ajax_vars.error_text);
                setTimeout(function() {
                    trigger.html(originalText);
                }, 2000);
            },
            complete: function() {
                setTimeout(function() {
                    trigger.removeClass('gwcpa-loading');
                }, 500);
            }
        });
    });
});