<?php
/**
 * Scripts
 *
 * @package GamiPress\lifterLMS\Points_Per_Quiz_Score\Scripts
 * @since 1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function gamipress_points_per_quiz_score_for_lifterlms_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Scripts
    wp_register_script( 'gamipress-points-per-quiz-score-for-lifterlms-admin-js', GAMIPRESS_POINTS_PER_QUIZ_SCORE_FOR_LIFTERLMS_URL . 'assets/js/gamipress-points-per-quiz-score-for-lifterlms-admin' . $suffix . '.js', array( 'jquery' ), GAMIPRESS_POINTS_PER_QUIZ_SCORE_FOR_LIFTERLMS_VER, true );

}
add_action( 'admin_init', 'gamipress_points_per_quiz_score_for_lifterlms_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function gamipress_points_per_quiz_score_for_lifterlms_admin_enqueue_scripts( $hook ) {

    global $post_type;

    //Scripts
    if ( $post_type === 'points-type' ) {

        wp_enqueue_script( 'gamipress-points-per-quiz-score-for-lifterlms-admin-js' );

    }
}
add_action( 'admin_enqueue_scripts', 'gamipress_points_per_quiz_score_for_lifterlms_admin_enqueue_scripts', 100 );