<?php

declare(strict_types=1);

/*
 * This file is part of JoliCode's Slack PHP API project.
 *
 * (c) JoliCode <coucou@jolicode.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace JoliCode\Slack\Api\Normalizer;

use JoliCode\Slack\Api\Runtime\Normalizer\CheckArray;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class JaneObjectNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    protected $normalizers = ['JoliCode\\Slack\\Api\\Model\\BlocksItem' => 'JoliCode\\Slack\\Api\\Normalizer\\BlocksItemNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsBotProfile' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsBotProfileNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsBotProfileIcons' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsBotProfileIconsNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsChannel' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsChannelNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsChannelPurpose' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsChannelPurposeNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsChannelTopic' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsChannelTopicNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsComment' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsCommentNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsConversation' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsConversationNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsConversationDisplayCounts' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsConversationDisplayCountsNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsConversationPurpose' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsConversationPurposeNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsConversationSharesItem' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsConversationSharesItemNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsConversationTopic' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsConversationTopicNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsEnterpriseUser' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsEnterpriseUserNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsExternalOrgMigrations' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsExternalOrgMigrationsNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsExternalOrgMigrationsCurrentItem' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsExternalOrgMigrationsCurrentItemNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsFile' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsFileNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsFileShares' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsFileSharesNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsIcon' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsIconNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsMessage' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsMessageNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsMessageAttachmentsItem' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsMessageAttachmentsItemNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsMessageAttachmentsItemActionsItem' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsMessageAttachmentsItemActionsItemNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsMessageAttachmentsItemFieldsItem' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsMessageAttachmentsItemFieldsItemNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsMessageIcons' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsMessageIconsNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsPaging' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsPagingNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsPrimaryOwner' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsPrimaryOwnerNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsReaction' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsReactionNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsReminder' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsReminderNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsResources' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsResourcesNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsResponseMetadata' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsResponseMetadataNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsSubteam' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsSubteamNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsSubteamPrefs' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsSubteamPrefsNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsTeam' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsTeamNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsTeamSsoProvider' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsTeamSsoProviderNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsTeamProfileField' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsTeamProfileFieldNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsTeamProfileFieldOption' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsTeamProfileFieldOptionNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsUser' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsUserNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsUserTeamProfile' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsUserTeamProfileNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsUserProfile' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsUserProfileNormalizer', 'JoliCode\\Slack\\Api\\Model\\ObjsUserProfileShort' => 'JoliCode\\Slack\\Api\\Normalizer\\ObjsUserProfileShortNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminAppsApprovePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminAppsApprovePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminAppsApprovePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminAppsApprovePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminAppsApprovedListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminAppsApprovedListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminAppsApprovedListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminAppsApprovedListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminAppsRequestsListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminAppsRequestsListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminAppsRequestsListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminAppsRequestsListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminAppsRestrictPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminAppsRestrictPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminAppsRestrictPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminAppsRestrictPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminAppsRestrictedListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminAppsRestrictedListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminAppsRestrictedListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminAppsRestrictedListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsArchivePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsArchivePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsArchivePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsArchivePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsConvertToPrivatePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsConvertToPrivatePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsConvertToPrivatePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsConvertToPrivatePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsCreatePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsCreatePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsCreatePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsCreatePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsDeletePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsDeletePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsDeletePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsDeletePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsDisconnectSharedPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsDisconnectSharedPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsDisconnectSharedPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsDisconnectSharedPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsEkmListOriginalConnectedChannelInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsEkmListOriginalConnectedChannelInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsEkmListOriginalConnectedChannelInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsEkmListOriginalConnectedChannelInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsGetConversationPrefsGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsGetConversationPrefsGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsGetConversationPrefsGetResponse200Prefs' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsGetConversationPrefsGetResponse200PrefsNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsGetConversationPrefsGetResponse200PrefsCanThread' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsGetConversationPrefsGetResponse200PrefsCanThreadNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsGetConversationPrefsGetResponse200PrefsWhoCanPost' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsGetConversationPrefsGetResponse200PrefsWhoCanPostNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsGetConversationPrefsGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsGetConversationPrefsGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsGetTeamsGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsGetTeamsGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsGetTeamsGetResponse200ResponseMetadata' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsGetTeamsGetResponse200ResponseMetadataNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsGetTeamsGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsGetTeamsGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsInvitePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsInvitePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsInvitePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsInvitePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsRenamePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsRenamePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsRenamePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsRenamePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsRestrictAccessAddGroupPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsRestrictAccessAddGroupPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsRestrictAccessAddGroupPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsRestrictAccessAddGroupPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsRestrictAccessListGroupsGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsRestrictAccessListGroupsGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsRestrictAccessListGroupsGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsRestrictAccessListGroupsGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsRestrictAccessRemoveGroupPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsRestrictAccessRemoveGroupPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsRestrictAccessRemoveGroupPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsRestrictAccessRemoveGroupPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsSearchGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsSearchGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsSearchGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsSearchGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsSetConversationPrefsPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsSetConversationPrefsPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsSetConversationPrefsPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsSetConversationPrefsPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsSetTeamsPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsSetTeamsPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsSetTeamsPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsSetTeamsPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsUnarchivePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsUnarchivePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminConversationsUnarchivePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminConversationsUnarchivePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminEmojiAddPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminEmojiAddPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminEmojiAddPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminEmojiAddPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminEmojiAddAliasPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminEmojiAddAliasPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminEmojiAddAliasPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminEmojiAddAliasPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminEmojiListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminEmojiListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminEmojiListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminEmojiListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminEmojiRemovePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminEmojiRemovePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminEmojiRemovePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminEmojiRemovePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminEmojiRenamePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminEmojiRenamePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminEmojiRenamePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminEmojiRenamePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminInviteRequestsApprovePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminInviteRequestsApprovePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminInviteRequestsApprovePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminInviteRequestsApprovePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminInviteRequestsApprovedListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminInviteRequestsApprovedListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminInviteRequestsApprovedListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminInviteRequestsApprovedListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminInviteRequestsDeniedListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminInviteRequestsDeniedListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminInviteRequestsDeniedListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminInviteRequestsDeniedListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminInviteRequestsDenyPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminInviteRequestsDenyPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminInviteRequestsDenyPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminInviteRequestsDenyPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminInviteRequestsListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminInviteRequestsListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminInviteRequestsListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminInviteRequestsListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsAdminsListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsAdminsListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsAdminsListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsAdminsListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsCreatePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsCreatePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsCreatePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsCreatePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsOwnersListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsOwnersListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsOwnersListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsOwnersListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsSettingsInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsSettingsInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsSettingsInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsSettingsInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsSettingsSetDefaultChannelsPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsSettingsSetDefaultChannelsPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsSettingsSetDefaultChannelsPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsSettingsSetDefaultChannelsPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsSettingsSetDescriptionPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsSettingsSetDescriptionPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsSettingsSetDescriptionPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsSettingsSetDescriptionPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsSettingsSetDiscoverabilityPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsSettingsSetDiscoverabilityPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsSettingsSetDiscoverabilityPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsSettingsSetDiscoverabilityPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsSettingsSetIconPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsSettingsSetIconPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsSettingsSetIconPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsSettingsSetIconPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsSettingsSetNamePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsSettingsSetNamePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminTeamsSettingsSetNamePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminTeamsSettingsSetNamePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsergroupsAddChannelsPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsergroupsAddChannelsPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsergroupsAddChannelsPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsergroupsAddChannelsPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsergroupsAddTeamsPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsergroupsAddTeamsPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsergroupsAddTeamsPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsergroupsAddTeamsPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsergroupsListChannelsGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsergroupsListChannelsGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsergroupsListChannelsGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsergroupsListChannelsGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsergroupsRemoveChannelsPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsergroupsRemoveChannelsPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsergroupsRemoveChannelsPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsergroupsRemoveChannelsPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersAssignPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersAssignPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersAssignPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersAssignPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersInvitePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersInvitePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersInvitePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersInvitePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersRemovePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersRemovePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersRemovePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersRemovePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersSessionInvalidatePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersSessionInvalidatePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersSessionInvalidatePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersSessionInvalidatePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersSessionResetPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersSessionResetPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersSessionResetPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersSessionResetPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersSetAdminPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersSetAdminPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersSetAdminPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersSetAdminPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersSetExpirationPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersSetExpirationPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersSetExpirationPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersSetExpirationPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersSetOwnerPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersSetOwnerPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersSetOwnerPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersSetOwnerPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersSetRegularPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersSetRegularPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AdminUsersSetRegularPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AdminUsersSetRegularPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ApiTestGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ApiTestGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ApiTestGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ApiTestGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsEventAuthorizationsListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsEventAuthorizationsListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AppsEventAuthorizationsListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsEventAuthorizationsListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsInfoGetResponse200Info' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsInfoGetResponse200InfoNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsInfoGetResponse200InfoAppHome' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsInfoGetResponse200InfoAppHomeNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsInfoGetResponse200InfoChannel' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsInfoGetResponse200InfoChannelNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsInfoGetResponse200InfoGroup' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsInfoGetResponse200InfoGroupNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsInfoGetResponse200InfoIm' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsInfoGetResponse200InfoImNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsInfoGetResponse200InfoMpim' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsInfoGetResponse200InfoMpimNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsInfoGetResponse200InfoTeam' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsInfoGetResponse200InfoTeamNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsRequestGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsRequestGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsRequestGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsRequestGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsResourcesListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsResourcesListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsResourcesListGetResponse200ResourcesItem' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsResourcesListGetResponse200ResourcesItemNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsResourcesListGetResponse200ResponseMetadata' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsResourcesListGetResponse200ResponseMetadataNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsResourcesListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsResourcesListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsScopesListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsScopesListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsScopesListGetResponse200Scopes' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsScopesListGetResponse200ScopesNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsScopesListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsScopesListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsUsersListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsUsersListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsUsersListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsUsersListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsUsersRequestGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsUsersRequestGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AppsPermissionsUsersRequestGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsPermissionsUsersRequestGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AppsUninstallGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsUninstallGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AppsUninstallGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AppsUninstallGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AuthRevokeGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AuthRevokeGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AuthRevokeGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AuthRevokeGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\AuthTestGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\AuthTestGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\AuthTestGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\AuthTestGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\BotsInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\BotsInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\BotsInfoGetResponse200Bot' => 'JoliCode\\Slack\\Api\\Normalizer\\BotsInfoGetResponse200BotNormalizer', 'JoliCode\\Slack\\Api\\Model\\BotsInfoGetResponse200BotIcons' => 'JoliCode\\Slack\\Api\\Normalizer\\BotsInfoGetResponse200BotIconsNormalizer', 'JoliCode\\Slack\\Api\\Model\\BotsInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\BotsInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\CallsAddPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\CallsAddPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\CallsAddPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\CallsAddPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\CallsEndPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\CallsEndPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\CallsEndPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\CallsEndPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\CallsInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\CallsInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\CallsInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\CallsInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\CallsParticipantsAddPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\CallsParticipantsAddPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\CallsParticipantsAddPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\CallsParticipantsAddPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\CallsParticipantsRemovePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\CallsParticipantsRemovePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\CallsParticipantsRemovePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\CallsParticipantsRemovePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\CallsUpdatePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\CallsUpdatePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\CallsUpdatePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\CallsUpdatePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatDeletePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatDeletePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ChatDeletePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatDeletePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatDeleteScheduledMessagePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatDeleteScheduledMessagePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ChatDeleteScheduledMessagePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatDeleteScheduledMessagePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatGetPermalinkGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatGetPermalinkGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ChatGetPermalinkGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatGetPermalinkGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatMeMessagePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatMeMessagePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ChatMeMessagePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatMeMessagePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatPostEphemeralPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatPostEphemeralPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ChatPostEphemeralPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatPostEphemeralPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatPostMessagePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatPostMessagePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ChatPostMessagePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatPostMessagePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatScheduleMessagePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatScheduleMessagePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ChatScheduleMessagePostResponse200Message' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatScheduleMessagePostResponse200MessageNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatScheduleMessagePostResponse200MessageAttachmentsItem' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatScheduleMessagePostResponse200MessageAttachmentsItemNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatScheduleMessagePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatScheduleMessagePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatScheduledMessagesListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatScheduledMessagesListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ChatScheduledMessagesListGetResponse200ResponseMetadata' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatScheduledMessagesListGetResponse200ResponseMetadataNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatScheduledMessagesListGetResponse200ScheduledMessagesItem' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatScheduledMessagesListGetResponse200ScheduledMessagesItemNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatScheduledMessagesListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatScheduledMessagesListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatUnfurlPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatUnfurlPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ChatUnfurlPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatUnfurlPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatUpdatePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatUpdatePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ChatUpdatePostResponse200Message' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatUpdatePostResponse200MessageNormalizer', 'JoliCode\\Slack\\Api\\Model\\ChatUpdatePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ChatUpdatePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsArchivePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsArchivePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsArchivePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsArchivePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsClosePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsClosePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsClosePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsClosePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsCreatePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsCreatePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsCreatePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsCreatePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsHistoryGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsHistoryGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsHistoryGetResponse200ResponseMetadata' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsHistoryGetResponse200ResponseMetadataNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsHistoryGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsHistoryGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsInvitePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsInvitePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsInvitePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsInvitePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsInvitePostResponsedefaultErrorsItem' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsInvitePostResponsedefaultErrorsItemNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsJoinPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsJoinPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsJoinPostResponse200ResponseMetadata' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsJoinPostResponse200ResponseMetadataNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsJoinPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsJoinPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsKickPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsKickPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsKickPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsKickPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsLeavePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsLeavePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsLeavePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsLeavePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsListGetResponse200ResponseMetadata' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsListGetResponse200ResponseMetadataNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsMarkPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsMarkPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsMarkPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsMarkPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsMembersGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsMembersGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsMembersGetResponse200ResponseMetadata' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsMembersGetResponse200ResponseMetadataNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsMembersGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsMembersGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsOpenPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsOpenPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsOpenPostResponse200ChannelItem1' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsOpenPostResponse200ChannelItem1Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsOpenPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsOpenPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsRenamePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsRenamePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsRenamePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsRenamePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsRepliesGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsRepliesGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsRepliesGetResponse200MessagesItemItem0' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsRepliesGetResponse200MessagesItemItem0Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsRepliesGetResponse200MessagesItemItem1' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsRepliesGetResponse200MessagesItemItem1Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsRepliesGetResponse200ResponseMetadata' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsRepliesGetResponse200ResponseMetadataNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsRepliesGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsRepliesGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsSetPurposePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsSetPurposePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsSetPurposePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsSetPurposePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsSetTopicPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsSetTopicPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsSetTopicPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsSetTopicPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsUnarchivePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsUnarchivePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ConversationsUnarchivePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ConversationsUnarchivePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\DialogOpenGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\DialogOpenGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\DialogOpenGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\DialogOpenGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\DndEndDndPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\DndEndDndPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\DndEndDndPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\DndEndDndPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\DndEndSnoozePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\DndEndSnoozePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\DndEndSnoozePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\DndEndSnoozePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\DndInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\DndInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\DndInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\DndInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\DndSetSnoozePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\DndSetSnoozePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\DndSetSnoozePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\DndSetSnoozePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\DndTeamInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\DndTeamInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\DndTeamInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\DndTeamInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\EmojiListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\EmojiListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\EmojiListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\EmojiListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesCommentsDeletePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesCommentsDeletePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesCommentsDeletePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesCommentsDeletePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesDeletePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesDeletePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesDeletePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesDeletePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRemoteAddPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRemoteAddPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRemoteAddPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRemoteAddPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRemoteInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRemoteInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRemoteInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRemoteInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRemoteListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRemoteListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRemoteListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRemoteListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRemoteRemovePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRemoteRemovePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRemoteRemovePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRemoteRemovePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRemoteShareGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRemoteShareGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRemoteShareGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRemoteShareGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRemoteUpdatePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRemoteUpdatePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRemoteUpdatePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRemoteUpdatePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRevokePublicURLPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRevokePublicURLPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesRevokePublicURLPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesRevokePublicURLPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesSharedPublicURLPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesSharedPublicURLPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesSharedPublicURLPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesSharedPublicURLPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\FilesUploadPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesUploadPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\FilesUploadPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\FilesUploadPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\MigrationExchangeGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\MigrationExchangeGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\MigrationExchangeGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\MigrationExchangeGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\OauthAccessGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\OauthAccessGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\OauthAccessGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\OauthAccessGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\OauthTokenGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\OauthTokenGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\OauthTokenGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\OauthTokenGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\OauthV2AccessGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\OauthV2AccessGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\OauthV2AccessGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\OauthV2AccessGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\PinsAddPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\PinsAddPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\PinsAddPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\PinsAddPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\PinsListGetResponse200Item0' => 'JoliCode\\Slack\\Api\\Normalizer\\PinsListGetResponse200Item0Normalizer', 'JoliCode\\Slack\\Api\\Model\\PinsListGetResponse200Item0ItemsItem0' => 'JoliCode\\Slack\\Api\\Normalizer\\PinsListGetResponse200Item0ItemsItem0Normalizer', 'JoliCode\\Slack\\Api\\Model\\PinsListGetResponse200Item0ItemsItem1' => 'JoliCode\\Slack\\Api\\Normalizer\\PinsListGetResponse200Item0ItemsItem1Normalizer', 'JoliCode\\Slack\\Api\\Model\\PinsListGetResponse200Item1' => 'JoliCode\\Slack\\Api\\Normalizer\\PinsListGetResponse200Item1Normalizer', 'JoliCode\\Slack\\Api\\Model\\PinsListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\PinsListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\PinsRemovePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\PinsRemovePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\PinsRemovePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\PinsRemovePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ReactionsAddPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ReactionsAddPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ReactionsAddPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ReactionsAddPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ReactionsGetGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ReactionsGetGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ReactionsListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ReactionsListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ReactionsListGetResponse200ItemsItemItem0' => 'JoliCode\\Slack\\Api\\Normalizer\\ReactionsListGetResponse200ItemsItemItem0Normalizer', 'JoliCode\\Slack\\Api\\Model\\ReactionsListGetResponse200ItemsItemItem1' => 'JoliCode\\Slack\\Api\\Normalizer\\ReactionsListGetResponse200ItemsItemItem1Normalizer', 'JoliCode\\Slack\\Api\\Model\\ReactionsListGetResponse200ItemsItemItem2' => 'JoliCode\\Slack\\Api\\Normalizer\\ReactionsListGetResponse200ItemsItemItem2Normalizer', 'JoliCode\\Slack\\Api\\Model\\ReactionsListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ReactionsListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ReactionsRemovePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ReactionsRemovePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ReactionsRemovePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ReactionsRemovePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\RemindersAddPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\RemindersAddPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\RemindersAddPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\RemindersAddPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\RemindersCompletePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\RemindersCompletePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\RemindersCompletePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\RemindersCompletePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\RemindersDeletePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\RemindersDeletePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\RemindersDeletePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\RemindersDeletePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\RemindersInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\RemindersInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\RemindersInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\RemindersInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\RemindersListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\RemindersListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\RemindersListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\RemindersListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\RtmConnectGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\RtmConnectGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\RtmConnectGetResponse200Self' => 'JoliCode\\Slack\\Api\\Normalizer\\RtmConnectGetResponse200SelfNormalizer', 'JoliCode\\Slack\\Api\\Model\\RtmConnectGetResponse200Team' => 'JoliCode\\Slack\\Api\\Normalizer\\RtmConnectGetResponse200TeamNormalizer', 'JoliCode\\Slack\\Api\\Model\\RtmConnectGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\RtmConnectGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\SearchMessagesGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\SearchMessagesGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\SearchMessagesGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\SearchMessagesGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\StarsAddPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\StarsAddPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\StarsAddPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\StarsAddPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\StarsListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\StarsListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\StarsListGetResponse200ItemsItemItem0' => 'JoliCode\\Slack\\Api\\Normalizer\\StarsListGetResponse200ItemsItemItem0Normalizer', 'JoliCode\\Slack\\Api\\Model\\StarsListGetResponse200ItemsItemItem1' => 'JoliCode\\Slack\\Api\\Normalizer\\StarsListGetResponse200ItemsItemItem1Normalizer', 'JoliCode\\Slack\\Api\\Model\\StarsListGetResponse200ItemsItemItem2' => 'JoliCode\\Slack\\Api\\Normalizer\\StarsListGetResponse200ItemsItemItem2Normalizer', 'JoliCode\\Slack\\Api\\Model\\StarsListGetResponse200ItemsItemItem3' => 'JoliCode\\Slack\\Api\\Normalizer\\StarsListGetResponse200ItemsItemItem3Normalizer', 'JoliCode\\Slack\\Api\\Model\\StarsListGetResponse200ItemsItemItem4' => 'JoliCode\\Slack\\Api\\Normalizer\\StarsListGetResponse200ItemsItemItem4Normalizer', 'JoliCode\\Slack\\Api\\Model\\StarsListGetResponse200ItemsItemItem5' => 'JoliCode\\Slack\\Api\\Normalizer\\StarsListGetResponse200ItemsItemItem5Normalizer', 'JoliCode\\Slack\\Api\\Model\\StarsListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\StarsListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\StarsRemovePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\StarsRemovePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\StarsRemovePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\StarsRemovePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\TeamAccessLogsGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamAccessLogsGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\TeamAccessLogsGetResponse200LoginsItem' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamAccessLogsGetResponse200LoginsItemNormalizer', 'JoliCode\\Slack\\Api\\Model\\TeamAccessLogsGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamAccessLogsGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\TeamBillableInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamBillableInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\TeamBillableInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamBillableInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\TeamInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\TeamInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\TeamIntegrationLogsGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamIntegrationLogsGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\TeamIntegrationLogsGetResponse200LogsItem' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamIntegrationLogsGetResponse200LogsItemNormalizer', 'JoliCode\\Slack\\Api\\Model\\TeamIntegrationLogsGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamIntegrationLogsGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\TeamProfileGetGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamProfileGetGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\TeamProfileGetGetResponse200Profile' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamProfileGetGetResponse200ProfileNormalizer', 'JoliCode\\Slack\\Api\\Model\\TeamProfileGetGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\TeamProfileGetGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsCreatePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsCreatePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsCreatePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsCreatePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsDisablePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsDisablePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsDisablePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsDisablePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsEnablePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsEnablePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsEnablePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsEnablePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsUpdatePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsUpdatePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsUpdatePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsUpdatePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsUsersListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsUsersListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsUsersListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsUsersListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsUsersUpdatePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsUsersUpdatePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsergroupsUsersUpdatePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsergroupsUsersUpdatePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersConversationsGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersConversationsGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersConversationsGetResponse200ResponseMetadata' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersConversationsGetResponse200ResponseMetadataNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersConversationsGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersConversationsGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersDeletePhotoPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersDeletePhotoPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersDeletePhotoPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersDeletePhotoPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersGetPresenceGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersGetPresenceGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersGetPresenceGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersGetPresenceGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponse200Item0' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponse200Item0Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponse200Item0Team' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponse200Item0TeamNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponse200Item0User' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponse200Item0UserNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponse200Item1' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponse200Item1Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponse200Item1Team' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponse200Item1TeamNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponse200Item1User' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponse200Item1UserNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponse200Item2' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponse200Item2Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponse200Item2Team' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponse200Item2TeamNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponse200Item2User' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponse200Item2UserNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponse200Item3' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponse200Item3Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponse200Item3Team' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponse200Item3TeamNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponse200Item3User' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponse200Item3UserNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersIdentityGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersIdentityGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersInfoGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersInfoGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersInfoGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersInfoGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersListGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersListGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersListGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersListGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersLookupByEmailGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersLookupByEmailGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersLookupByEmailGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersLookupByEmailGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersProfileGetGetResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersProfileGetGetResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersProfileGetGetResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersProfileGetGetResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersProfileSetPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersProfileSetPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersProfileSetPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersProfileSetPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersSetActivePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersSetActivePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersSetActivePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersSetActivePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersSetPhotoPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersSetPhotoPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersSetPhotoPostResponse200Profile' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersSetPhotoPostResponse200ProfileNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersSetPhotoPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersSetPhotoPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\UsersSetPresencePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersSetPresencePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\UsersSetPresencePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\UsersSetPresencePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ViewsOpenPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ViewsOpenPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ViewsOpenPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ViewsOpenPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ViewsPublishPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ViewsPublishPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ViewsPublishPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ViewsPublishPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ViewsPushPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ViewsPushPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ViewsPushPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ViewsPushPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\ViewsUpdatePostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\ViewsUpdatePostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\ViewsUpdatePostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\ViewsUpdatePostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\WorkflowsStepCompletedPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\WorkflowsStepCompletedPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\WorkflowsStepCompletedPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\WorkflowsStepCompletedPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\WorkflowsStepFailedPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\WorkflowsStepFailedPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\WorkflowsStepFailedPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\WorkflowsStepFailedPostResponsedefaultNormalizer', 'JoliCode\\Slack\\Api\\Model\\WorkflowsUpdateStepPostResponse200' => 'JoliCode\\Slack\\Api\\Normalizer\\WorkflowsUpdateStepPostResponse200Normalizer', 'JoliCode\\Slack\\Api\\Model\\WorkflowsUpdateStepPostResponsedefault' => 'JoliCode\\Slack\\Api\\Normalizer\\WorkflowsUpdateStepPostResponsedefaultNormalizer', '\\Jane\\Component\\JsonSchemaRuntime\\Reference' => '\\JoliCode\\Slack\\Api\\Runtime\\Normalizer\\ReferenceNormalizer'];
    protected $normalizersCache = [];

    /**
     * @return bool
     */
    public function supportsDenormalization($data, $type, $format = null)
    {
        return \array_key_exists($type, $this->normalizers);
    }

    /**
     * @return bool
     */
    public function supportsNormalization($data, $format = null)
    {
        return \is_object($data) && \array_key_exists(\get_class($data), $this->normalizers);
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $normalizerClass = $this->normalizers[\get_class($object)];
        $normalizer = $this->getNormalizer($normalizerClass);

        return $normalizer->normalize($object, $format, $context);
    }

    /**
     * @return mixed
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        $denormalizerClass = $this->normalizers[$class];
        $denormalizer = $this->getNormalizer($denormalizerClass);

        return $denormalizer->denormalize($data, $class, $format, $context);
    }

    private function getNormalizer(string $normalizerClass)
    {
        return $this->normalizersCache[$normalizerClass] ?? $this->initNormalizer($normalizerClass);
    }

    private function initNormalizer(string $normalizerClass)
    {
        $normalizer = new $normalizerClass();
        $normalizer->setNormalizer($this->normalizer);
        $normalizer->setDenormalizer($this->denormalizer);
        $this->normalizersCache[$normalizerClass] = $normalizer;

        return $normalizer;
    }
}
