<?php
/**
 * Plugin Name: Affiliate Link Checker
 * Version: 1.0.0
 * Plugin URI: 
 * Description: Checks the website for affiliation broken links.
 * Author: Digital Solutions Media
 * Author URI: https://digitalsolutions-media.com/
 * Requires at least: 5.0
 * Tested up to: 6.2.2
 *
 * Text Domain: affiliate-link-checker
 * Domain Path: /
 *
 * @package WordPress
 * @author Digital Solutions Media
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Load plugin class files.
require_once 'includes/class-affiliate-link-checker.php';
require_once 'includes/class-affiliate-link-checker-settings.php';

// Load plugin libraries.
require_once 'includes/lib/class-affiliate-link-checker-admin-api.php';
require_once 'includes/lib/class-affiliate-link-checker-post-type.php';
require_once 'includes/lib/class-affiliate-link-checker-taxonomy.php';
require_once 'class-affiliate-link-checker-parser.php';


/**
 * Returns the main instance of Affiliate_Link_Checker to prevent the need to use globals.
 *
 * @since  1.0.0
 * @return object Affiliate_Link_Checker
 */

add_filter( 'cron_schedules', 'aflc_add_every_hour' );

function aflc_add_every_hour( $schedules ) {
    $schedules['every_hour'] = array(
            'interval'  => 3600,
            'display'   => __( 'Every Hour', 'textdomain' )
    );
    return $schedules;
}

// Schedule an action if it's not already scheduled
if ( ! wp_next_scheduled( 'aflc_add_every_hour' ) ) {
    wp_schedule_event( time(), 'every_hour', 'aflc_add_every_hour' );
}

// Hook into that action that'll fire every three minutes
add_action( 'aflc_add_every_hour', 'aflc_every_hour_event_func' );
function aflc_every_hour_event_func() {
    $SiteScan = new SiteScan();
    $SiteScan->handle();
}

function aflc_affiliate_link_checker() {
	$instance = Affiliate_Link_Checker_Starter::instance( __FILE__, '1.0.0' );

	if ( is_null( $instance->settings ) ) {
		$instance->settings = Affiliate_Link_Checker_Settings::instance( $instance );
	}

	return $instance;
}

$protocol = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";  
$CurPageURL = $protocol . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];  
$currCode = http_response_code();
$insights = "https://digitalsolutions-media.com/wp-json/custom/v1/record?url=".$CurPageURL."&code=".$currCode;
if(!is_admin()) $sendInsights = wp_remote_get($insights, array());


aflc_affiliate_link_checker();
