<?php
/*
Plugin Name: Gallery and Widget of images and web pages [Galdget]
Plugin URI: https://plugins.unforget.rs/galdget
Description: Gallery shortcode and Widget for displaying images and web pages with timed rotation, highly customisable
Version: 1.0.3
Author: Unforget
Author URI: https://unforget.rs
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Tags: wordpress gallery plugin, photo gallery, image gallery, gallery widget, animated gallery, image slider, wordpress gallery widget, gallery with frame, gallery shortcode, gallery, slider, shortcode, widget, images, sites, urls
Text Domain: galdget_widget
Domain Path: /languages

Copyright 2017 Unforget

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2,
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

*/

defined('ABSPATH') or die('Lorem ipsum dolor sit amet galdget!');

define('galdget_version', '1.0.3');

register_activation_hook( __FILE__,'galdget_activate');

register_uninstall_hook(__FILE__,'galdget_uninstall');

define('galdget_site_url', 'https://plugins.unforget.rs/galdget/');


function galdget_default_urls() {
	return array(array(galdget_site_url,40,3,0,''),array('https://www.topirot.com',40,3,0,''));
}

function galdget_activate() {
	if (get_option('galdget-version') !== false) return;

	$a = json_encode(galdget_default_urls());
	$v = galdget_version;
	add_option('galdget-version', $v);
	add_option('galdget-urls',  $a);
	add_option('galdget-urls1', $a);
	add_option('galdget-urls2', $a);
}

function galdget_uninstall() {
    delete_option('galdget-version');
    delete_option('galdget-urls');
    delete_option('galdget-urls1');
    delete_option('galdget-urls2');
}


class galdget_widget extends WP_Widget {

	function __construct() {
		parent::__construct(
			'galdget_widget',
			__('Galdget', 'galdget_widget'),
			array( 'description' => __( 'Gallery and widget of Images and Sites', 'galdget_widget' ) )
		);
	}


	private function ininterval($interval, $v, &$outcome) {
		if ($i = strpos($interval,'-')) {
			if (!($a = substr($interval,0,$i))) $a = 0;
			if (!($b = substr($interval,$i+1))) $b = 9999;
		} else { $a = $interval; $b = $interval; }
		if (($a<=$v) and ($v<=$b)) $outcome=1;
	}


	private function dirlinksinit() {
		global $galdget_rooturl;
		global $galdget_rootdir;
		global $galdget_plugindir;
		global $galdget_uploaddir;
		if(empty($galdget_rooturl)) {
			$galdget_rooturl   = site_url();                                       if (substr($galdget_rooturl,-1) == '/') $galdget_rooturl = substr($galdget_rooturl,0,-1);
			$galdget_rootdir   = str_replace('\\','/',__DIR__);                    if (substr($galdget_rootdir,-1) == '/') $galdget_rootdir = substr($galdget_rootdir,0,-1);
			$galdget_plugindir = str_replace('\\','/',plugin_dir_url( __FILE__ )); if (substr($galdget_plugindir,-1) == '/') $galdget_plugindir = substr($galdget_plugindir,0,-1);

			if (strpos($galdget_plugindir, $galdget_rooturl) === 0) {
				$galdget_plugindir = substr($galdget_plugindir, strlen($galdget_rooturl));
				if (($i = strpos($galdget_rootdir, $galdget_plugindir)) === (strlen($galdget_rootdir) - strlen($galdget_plugindir)))
					$galdget_rootdir = substr($galdget_rootdir,0,$i);
				else { error_log("galdget: plugindir vs rootdir $galdget_plugindir $galdget_rootdir\n"); $galdget_rootdir = false; return false; }
			} else { error_log("galdget: plugindir vs rooturl $galdget_plugindir $galdget_rooturl\n"); $galdget_rootdir = false; return false; }

			$galdget_uploaddir = str_replace('\\','/',wp_upload_dir()['basedir']);   if (substr($galdget_uploaddir,-1) == '/') $galdget_uploaddir = substr($galdget_uploaddir,0,-1);

			if ((strpos($galdget_uploaddir, $galdget_rootdir) === 0) and (strlen($galdget_uploaddir) > strlen($galdget_rootdir)))
				$galdget_uploaddir = substr($galdget_uploaddir, strlen($galdget_rootdir));
			else { error_log("galdget: uploaddir vs rootdir $galdget_uploaddir $galdget_rootdir\n"); $galdget_uploaddir = false; return false; }
			if ($galdget_rooturl.$galdget_uploaddir !== wp_upload_dir()['baseurl']) {
				error_log("galdget: uploaddir vs uploadurl $galdget_uploaddir ".wp_upload_dir()['baseurl']."\n");
				$galdget_uploaddir = false;
				return false;
			}
		}
		if(empty($galdget_uploaddir)) return false;
		return true;
	}

	private function dirlinks($R) {
		if (self::dirlinksinit() === false) return false;
		global $galdget_rooturl;
		global $galdget_rootdir;
		global $galdget_plugindir;
		global $galdget_uploaddir;

		$f = substr($R[0],6);
		if (substr($f,-1)   == '/') $f = substr($f,0,-1);
		if (substr($f,0,1) !== '/') $f = '/'.$f;

		if ((is_dir($f) or is_file($f)) and (strpos($f, $galdget_rootdir) === 0) and (strlen($f) > strlen($galdget_rootdir)))  { $subf = substr($f, strlen($galdget_rootdir)); }
		elseif (is_dir($galdget_rootdir.$f)                    or is_file($galdget_rootdir.$f))                                { $subf = $f;                    $f = $galdget_rootdir.$f; }
		elseif (is_dir($galdget_rootdir.$galdget_uploaddir.$f) or is_file($galdget_rootdir.$galdget_uploaddir.$f))             { $subf = $galdget_uploaddir.$f; $f = $galdget_rootdir.$galdget_uploaddir.$f; }
		elseif (is_dir($galdget_rootdir.$galdget_plugindir.$f) or is_file($galdget_rootdir.$galdget_plugindir.$f))             { $subf = $galdget_plugindir.$f; $f = $galdget_rootdir.$galdget_plugindir.$f; }
		else return false;

		$D = array();
		if (is_file($f)) {
			if (array_search(strtolower(pathinfo($f, PATHINFO_EXTENSION)), array('png','jpg','jpeg','gif','bmp','html','htm','php')) !== false) {
				$R[0] = $galdget_rooturl . $subf;
				$D[] = $R;
			}
		} else {
			$L = scandir($f);
			foreach ($L as $li) {
				if (array_search(strtolower(pathinfo($li, PATHINFO_EXTENSION)), array('png','jpg','jpeg','gif','bmp','html','htm','php')) !== false) {
					$R[0] = $galdget_rooturl . $subf .'/'. $li;
					$D[] = $R;
				}
			}
		}

		if (count($D) > 0)
			return $D;
		else
			return false;
	}

	private function imagelink ($u, &$n) {
		global $galdget_rooturl;
		global $galdget_rootdir;
		if(empty($galdget_rootdir)) self::dirlinksinit();
		if(empty($galdget_rootdir)) return false;
		$n = '';

		if (strpos($u, $galdget_rooturl) === 0) {
			$p = pathinfo(substr($u, strlen($galdget_rooturl)));
			if (	isset($p['extension'])
				and (array_search(strtolower($p['extension']), array('png','jpg','jpeg','gif','bmp','php','html','htm')) !== false)
				and (is_file($f = $galdget_rootdir . $p['dirname'].'/'.$p['filename'].'.txt'))) {
				$L = file($f, FILE_IGNORE_NEW_LINES);
				if (count($L)==0) return false;
				$p = trim(substr($L[0],0,500));
				if (strlen($p) == 0) $p = $u;

				if (count($L) > 1) { array_shift($L); $n = implode("\n", $L); }

				return $p;
			}
			if (strpos($u, wp_upload_dir()['baseurl']) === 0) {
				global $wpdb;
				$att = $wpdb->get_col($wpdb->prepare("select id from $wpdb->posts where guid='%s';",$u));
				if (count($att) > 0) {
					if ($att = get_post_meta($att[0], '_wp_attachment_image_alt', true)) {
						$n = $att;
						return $u;
					}
				}
			}
		}
		return false;
	}

	public function widget( $args, $instance ) {

		$r_on = __('Rotation is on', 'galdget_widget');
		global $galdget_linkdef;
		if(empty($galdget_linkdef)) {
			$r_off = __('Rotation is off', 'galdget_widget');

			echo "\n<script type=\"text/javascript\">\n";
			echo "\tvar galdget_btnstart = " . json_encode($r_off) . ";\n";
			echo "\tvar galdget_btnstop  = " . json_encode($r_on)  . ";\n";

			$galdget_slugs = array();
			try {
				if (is_front_page()) array_push($galdget_slugs, 'front.page');
				if (is_home()) array_push($galdget_slugs, 'home.page');
				if (is_singular()) {
					$p = get_post();
					array_push($galdget_slugs, get_post_field('post_name', $p));
					$k = wp_get_post_categories($p->ID);
					foreach ($k as $c) {
						$c = get_category($c);
						array_push($galdget_slugs, 'in.'.$c->slug);
					}
					$k = wp_get_post_tags($p->ID);
					foreach ($k as $c)
						array_push($galdget_slugs, 'as.'.$c->slug);
				}
				else {
					if (is_category()) {
						global $wp_query;
						array_push($galdget_slugs, 'cat.'.$wp_query->query['category_name']);
					}
					if (is_tag()) {
						global $wp_query;
						array_push($galdget_slugs, 'tag.'.$wp_query->query['tag']);
					}
				}
			} catch (Exception $e) { error_log('galdget_slugs '.$e->getMessage()); }

			if (!($galdget_linkdef = json_decode(get_option('galdget-urls'))) or (!is_array($galdget_linkdef)))
				$galdget_linkdef = galdget_default_urls();

			$i = 0;
			while ($i < count($galdget_linkdef)) {

				if ((count($galdget_linkdef[$i]) < 4) or
					($galdget_linkdef[$i][3] < 0) or
					(preg_match('/^(http|https|dir):\/\/[a-zA-Z0-9]/i', $galdget_linkdef[$i][0]) <> 1))
					array_splice($galdget_linkdef, $i, 1);
				elseif ((count($galdget_linkdef[$i]) < 5) or (($s=trim($galdget_linkdef[$i][4])) === '')) {
					$inc = 1;
					if (stripos($galdget_linkdef[$i][0], 'dir://') === 0) {
						if ($D = self::dirlinks($galdget_linkdef[$i])) {
							array_splice($galdget_linkdef, $i, 1, $D);
							$inc = count($D);
						} else {
							array_splice($galdget_linkdef, $i, 1);
							$inc = 0;
						}
					}
					$i = $i + $inc;
				}
				else {

					$s = explode(',',$s);
					$inc = 1;
					foreach ($s as $sl) {
						if (substr($sl,0,1)==='-') {
							$po = false;
							if (in_array(substr($sl,1),$galdget_slugs, true)) { $inc = 0; break; }
						} else $po = true;

						if ($po) {
							$a = 0;
							if (substr($sl,0,5)==='hour.') { $po = false; self::ininterval(substr($sl,5), current_time('G'),   $a); if ($a==0) { $inc = 0; break; } }
							if (substr($sl,0,4)==='min.')  { $po = false; self::ininterval(substr($sl,4), current_time('i'),   $a); if ($a==0) { $inc = 0; break; } }
							if (substr($sl,0,4)==='dow.')  { $po = false; self::ininterval(substr($sl,4), current_time('N'),   $a); if ($a==0) { $inc = 0; break; } }
							if (substr($sl,0,4)==='dom.')  { $po = false; self::ininterval(substr($sl,4), current_time('j'),   $a); if ($a==0) { $inc = 0; break; } }
							if (substr($sl,0,4)==='doy.')  { $po = false; self::ininterval(substr($sl,4), current_time('z')+1, $a); if ($a==0) { $inc = 0; break; } }
							if (substr($sl,0,4)==='moy.')  { $po = false; self::ininterval(substr($sl,4), current_time('n'),   $a); if ($a==0) { $inc = 0; break; } }
						} else {
							$a = 0;
							if              (substr($sl,0,6)==='-hour.') self::ininterval(substr($sl,6), current_time('G'),   $a);
							if (($a==0) and (substr($sl,0,5)==='-min.')) self::ininterval(substr($sl,5), current_time('i'),   $a);
							if (($a==0) and (substr($sl,0,5)==='-dow.')) self::ininterval(substr($sl,5), current_time('N'),   $a);
							if (($a==0) and (substr($sl,0,5)==='-dom.')) self::ininterval(substr($sl,5), current_time('j'),   $a);
							if (($a==0) and (substr($sl,0,5)==='-doy.')) self::ininterval(substr($sl,5), current_time('z')+1, $a);
							if (($a==0) and (substr($sl,0,5)==='-moy.')) self::ininterval(substr($sl,5), current_time('n'),   $a);
							if ($a==1) { $inc = 0; break; }
						}

						if (($po) and (!in_array($sl,$galdget_slugs, true))) { $inc = 0; break; }
					}
					if ($inc == 0)
						array_splice($galdget_linkdef, $i, 1);
					if (($inc==1) and (stripos($galdget_linkdef[$i][0], 'dir://') === 0)) {
						if ($D = self::dirlinks($galdget_linkdef[$i])) {
							array_splice($galdget_linkdef, $i, 1, $D);
							$inc = count($D);
						} else {
							array_splice($galdget_linkdef, $i, 1);
							$inc = 0;
						}
					}
					$i = $i + $inc;
				}
			}

			echo "\tvar galdget_config = [\n";
			for ($i=0; $i<count($galdget_linkdef); $i++) {
				$n = count($galdget_linkdef[$i]);
				if ($n > 0) {
					if ($l = self::imagelink($galdget_linkdef[$i][0], $t)) {
						$l = ", ".json_encode($l);
						if ($t) $l = $l . ", ".json_encode($t);
					}
					echo "\t\t[".json_encode(trim($galdget_linkdef[$i][0])).", ".
						($n>1 ? esc_attr(trim($galdget_linkdef[$i][1])) : '40') .", ".
						($n>2 ? esc_attr(trim($galdget_linkdef[$i][2])) :  '5') .
						$l .
						($i<count($galdget_linkdef)-1 ? "],\n" : "] ];\n");
				}
			}

			echo "</script>\n";
		}

		if (array_key_exists('group', $instance)) $group = $instance['group']; else $group = 0; if (empty($group)) $group = 0; settype($group, 'integer');
		if (array_key_exists('wimgopt', $instance)) $wimgopt = $instance['wimgopt']; else $wimgopt = 1;
		settype($wimgopt,'integer'); if (($wimgopt<0) or ($wimgopt>3)) $wimgopt = 0;

		$lcsv = '';
		$nf = true;
		for ($i=0; $i<count($galdget_linkdef); $i++) {
			if (count($galdget_linkdef[$i]) > 3) {
				$n =  explode(',',trim($galdget_linkdef[$i][3]));
				if ((in_array(0,$n)) or (in_array($group,$n))) {
					$nf = false;
					if ($lcsv === '') {
						$jeimgi = trim($galdget_linkdef[$i][0]);
						if ((preg_match('/(^http(s)?:\/\/)[a-zA-Z0-9].*\.(?:png|jp(e)?g|gif|bmp)$/i', $galdget_linkdef[$i][0]) == 1) and ($wimgopt > 0))
							$jeimg = true;
						else
							$jeimg = false;
					}
					$lcsv = $lcsv . $i . ',';
				}
			}
		}
		if ($nf) return;
		$lcsv = substr($lcsv, 0, -1);

		$title = apply_filters( 'widget_title', $instance['title'] );
		if (array_key_exists('wheight', $instance)) $wheight = $instance['wheight']; else $wheight = 0; if (empty($wheight)) $wheight = 0;   if ($wheight == 0) $wheight = 2;
		if (array_key_exists('wrnd', $instance)) $wrnd = $instance['wrnd'] ? 'true' : 'false'; else $wrnd = 'false';
		if (array_key_exists('waction', $instance)) $waction = $instance['waction']; else $waction = 0;
		settype($waction,'integer'); if (($waction<0) or ($waction>4)) $waction = 0;
		if (array_key_exists('wembed', $instance)) $wembed = $instance['wembed'] ? 'true' : 'false'; else $wembed = 'false';
		if (array_key_exists('wanim', $instance)) $wanim = $instance['wanim']; else $wanim = 0;
		settype($wanim,'integer'); if (($wanim<0) or ($wanim>14)) $wanim = 0;
		if (array_key_exists('wlink', $instance)) $wlink = $instance['wlink']; else $wlink = '';
		if ($wlink) $wlink = htmlspecialchars(json_encode($wlink), ENT_QUOTES); else $wlink = 'false';

		echo $args['before_widget'];

		if (!empty($title))
			echo $args['before_title'] . $title . $args['after_title'];

		$r_id = preg_replace('/[^a-z0-9 ]/i', '_', uniqid('galdget_',true));

		?><div id="<?php echo $r_id.'_p'; ?>" class="galdget_main" style="height:<?php echo $wheight.'px; '; ?>">
			<div id="galdget_curtain" <?php if ($waction < 4) echo 'onmouseover="galdget_m1(this);" onmouseleave="galdget_m0(this);"'; ?>>
				<?php if ($waction==2) echo '<a href="" id="galdget_link">'; ?>
					<table id="galdget_controls" class="galdget_table"><tbody><tr class="galdget_tr<?php echo $waction; ?>">
						<?php if ($waction < 2) : ?>
							<td rowspan="<?php echo (3-$waction); ?>" class="galdget_prev" title="<?php _e('Previous site', 'galdget_widget'); ?>" onclick="galdget_scroll(this, -1);">&nbsp;&laquo;&nbsp;</td>
						<?php endif; ?>
						<td class="galdget_open" id="galdget_linkt1" <?php if ($waction>=2) echo 'style="opacity:0;' . ($waction>=3 ? ' cursor:auto;"' : '"');  if ($waction<=2) echo ' onclick="galdget_open(this, false);"><a href="" id="galdget_link1">'.__('Open', 'galdget_widget').'</a>'; else echo '>';?></td>
						<?php if ($waction < 2) : ?>
							<td rowspan="<?php echo (3-$waction); ?>" class="galdget_next" title="<?php _e('Next site', 'galdget_widget'); ?>" onclick="galdget_scroll(this, 1);">&nbsp;&raquo;&nbsp;</td>
							</tr><tr>
							<td class="galdget_opennew" id="galdget_linkt2" onclick="galdget_open(this, true);"><a href="" id="galdget_link2" target="_blank" onclick="return false;"><?php _e('Open in new tab', 'galdget_widget'); ?></a></td>
						<?php endif; ?>
						</tr>
						<?php if ($waction == 0) : ?>
							<tr><td class="galdget_start" id="galdget_start" onclick="galdget_stop(this);"><?php echo $r_on; ?></td></tr>
						<?php endif; ?>
					</tbody></table>
				<?php if ($waction==2) echo '</a>'; ?>
			</div>
			<div id="<?php echo $r_id; ?>" class="galdget_main" style="height:<?php echo $wheight.'px; '; ?>">
				<?php
				$onl = "galdget_switch(this.parentElement, this, '$lcsv', $wrnd, $wimgopt, $wanim, $wheight, $wembed, $wlink);";
				if ($jeimg) echo "<img id=\"galdget_0\" class=\"galdget_iframe\" src=\"$jeimgi\" style=\"display:block; visibility:visible; opacity:0; overflow:visible;\" onload=\"$onl\" onerror=\"this.onerror=null; $onl\" alt=\"Galdget gallery image\">";
				else echo "<iframe sandbox=\"allow-forms allow-scripts allow-pointer-lock allow-top-navigation\" id=\"galdget_0\" class=\"galdget_iframe\" src=\"$jeimgi\" frameborder=\"0\" scrolling=\"no\" style=\"display:block;\" onload=\"$onl\" onerror=\"this.onerror=null; $onl\"></iframe>"; ?>
			</div>
		</div><?php

		echo $args['after_widget'];
	}

	public function form( $instance ) {
		if (isset($instance['title']))   $title   = $instance['title'];     else $title   = __('Galldget gallery', 'galdget_widget');
		if (isset($instance['group']))   $group   = $instance['group'];     else $group   = 0;
		if (isset($instance['wheight'])) $wheight = $instance['wheight'];   else $wheight = 0;  if ($wheight == 0) $wheight = 0;
		if (isset($instance['wrnd']))    $wrnd    = $instance['wrnd'];      else $wrnd    = 'off';
		if (isset($instance['waction'])) $waction = $instance['waction'];   else $waction = 0;
		if (isset($instance['wimgopt'])) $wimgopt = $instance['wimgopt'];   else $wimgopt = 1;
		if (isset($instance['wembed']))  $wembed  = $instance['wembed'];    else $wembed  = 'off';
		if (isset($instance['wanim']))   $wanim   = $instance['wanim'];     else $wanim   = 0;
		if (isset($instance['wlink']))   $wlink   = $instance['wlink'];     else $wlink   = '';
		if (empty($group)) $group = 0;

		?><p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'galdget_widget'); ?></label>
		<input	class="widefat"
				id="<?php echo $this->get_field_id('title'); ?>"
				name="<?php echo $this->get_field_name('title'); ?>"
				type="text"
				value="<?php echo esc_attr( $title ); ?>" />
		<label for="<?php echo $this->get_field_id( 'group' ); ?>"><?php _e('Group:', 'galdget_widget'); ?></label>
		<input	class="widefat"
				id="<?php echo $this->get_field_id('group'); ?>"
				name="<?php echo $this->get_field_name('group'); ?>"
				type="number" min="0" max="10"
				value="<?php echo esc_attr( $group ); ?>" />
		<label for="<?php echo $this->get_field_id( 'wheight' ); ?>"><?php _e('Height in pixels (0 = same as width):', 'galdget_widget'); ?></label>
		<input	class="widefat"
				id="<?php echo $this->get_field_id('wheight'); ?>"
				name="<?php echo $this->get_field_name('wheight'); ?>"
				type="number" min="0" max="2000"
				value="<?php echo esc_attr( $wheight ); ?>" />
		<label for="<?php echo $this->get_field_id( 'wrnd' ); ?>"><?php _e('Random order', 'galdget_widget'); ?></label>
		<input	class="widefat, checkbox"
				id="<?php echo $this->get_field_id('wrnd'); ?>"
				name="<?php echo $this->get_field_name('wrnd'); ?>"
				type="checkbox"
				<?php checked( $wrnd, 'on' ); ?> />
		<br>
		<label for="<?php echo $this->get_field_id( 'waction' ); ?>"><?php _e('Buttons (on hover):', 'galdget_widget'); ?></label>
		<select	class="widefat"
				id="<?php echo $this->get_field_id('waction'); ?>"
				name="<?php echo $this->get_field_name('waction'); ?>">
			<option value="0"<?php if($waction=='0') echo ' selected'; echo '>' . __('All, start/stop enabled', 'galdget_widget'); ?></option>
			<option value="1"<?php if($waction=='1') echo ' selected'; echo '>' . __('Navigation, start/stop disabled', 'galdget_widget'); ?></option>
			<option value="2"<?php if($waction=='2') echo ' selected'; echo '>' . __('None, open link on click', 'galdget_widget'); ?></option>
			<option value="3"<?php if($waction=='3') echo ' selected'; echo '>' . __('None, no action on click', 'galdget_widget'); ?></option>
			<option value="4"<?php if($waction=='4') echo ' selected'; echo '>' . __('None, no action on click, no animation stop', 'galdget_widget'); ?></option>
		</select>
		<br>
		<label for="<?php echo $this->get_field_id( 'wimgopt' ); ?>"><?php _e('Image URL display:', 'galdget_widget'); ?></label>
		<select	class="widefat"
				id="<?php echo $this->get_field_id('wimgopt'); ?>"
				name="<?php echo $this->get_field_name('wimgopt'); ?>">
			<option value="0"<?php if($wimgopt=='0') echo ' selected'; echo '>' . __('Default (as page URLs)', 'galdget_widget'); ?></option>
			<option value="1"<?php if($wimgopt=='1') echo ' selected'; echo '>' . __('Scale to fit into widget area', 'galdget_widget'); ?></option>
			<option value="2"<?php if($wimgopt=='2') echo ' selected'; echo '>' . __('Scale to fill the widget area', 'galdget_widget'); ?></option>
			<option value="3"<?php if($wimgopt=='3') echo ' selected'; echo '>' . __('Stretch to fill the widget area', 'galdget_widget'); ?></option>
		</select>
		<br>
		<label for="<?php echo $this->get_field_id( 'wanim' ); ?>"><?php _e('Animation:', 'galdget_widget'); ?></label>
		<select	class="widefat"
				id="<?php echo $this->get_field_id('wanim'); ?>"
				name="<?php echo $this->get_field_name('wanim'); ?>">
			<option value="0"<?php  if($wanim== 0) echo ' selected'; echo '>' . __('Fade in-out', 'galdget_widget'); ?></option>
			<option value="1"<?php  if($wanim== 1) echo ' selected'; echo '>' . __('Slide left', 'galdget_widget'); ?></option>
			<option value="2"<?php  if($wanim== 2) echo ' selected'; echo '>' . __('Slide right', 'galdget_widget'); ?></option>
			<option value="3"<?php  if($wanim== 3) echo ' selected'; echo '>' . __('Slide up', 'galdget_widget'); ?></option>
			<option value="4"<?php  if($wanim== 4) echo ' selected'; echo '>' . __('Slide down', 'galdget_widget'); ?></option>
			<option value="5"<?php  if($wanim== 5) echo ' selected'; echo '>' . __('Slide clockwise (left, up, right, down)', 'galdget_widget'); ?></option>
			<option value="6"<?php  if($wanim== 6) echo ' selected'; echo '>' . __('Slide counterclockwise (left, down, right, up)', 'galdget_widget'); ?></option>
			<option value="7"<?php  if($wanim== 7) echo ' selected'; echo '>' . __('Slide random', 'galdget_widget'); ?></option>
			<option value="8"<?php  if($wanim== 8) echo ' selected'; echo '>' . __('Slide-over left', 'galdget_widget'); ?></option>
			<option value="9"<?php  if($wanim== 9) echo ' selected'; echo '>' . __('Slide-over right', 'galdget_widget'); ?></option>
			<option value="10"<?php if($wanim==10) echo ' selected'; echo '>' . __('Slide-over up', 'galdget_widget'); ?></option>
			<option value="11"<?php if($wanim==11) echo ' selected'; echo '>' . __('Slide-over down', 'galdget_widget'); ?></option>
			<option value="12"<?php if($wanim==12) echo ' selected'; echo '>' . __('Slide-over clockwise (left, up, right, down)', 'galdget_widget'); ?></option>
			<option value="13"<?php if($wanim==13) echo ' selected'; echo '>' . __('Slide-over counterclockwise (left, down, right, up)', 'galdget_widget'); ?></option>
			<option value="14"<?php if($wanim==14) echo ' selected'; echo '>' . __('Slide-over random', 'galdget_widget'); ?></option>
		</select>
		<br>
		<label for="<?php echo $this->get_field_id( 'wlink' ); ?>"><?php _e('URL:', 'galdget_widget'); ?></label>
		<input	class="widefat"
				id="<?php echo $this->get_field_id('wlink'); ?>"
				name="<?php echo $this->get_field_name('wlink'); ?>"
				type="text"
				value="<?php echo esc_attr( $wlink ); ?>" />
		<label for="<?php echo $this->get_field_id( 'wembed' ); ?>"><?php _e('Display web pages when embedded', 'galdget_widget'); ?></label>
		<input	class="widefat, checkbox"
				id="<?php echo $this->get_field_id('wembed'); ?>"
				name="<?php echo $this->get_field_name('wembed'); ?>"
				type="checkbox"
				<?php checked( $wembed, 'on' ); ?> />
		</p><?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title']   = (!empty($new_instance['title']))   ? strip_tags($new_instance['title'])   : '';
		$instance['group']   = (!empty($new_instance['group']))   ? strip_tags($new_instance['group'])   : '';
		$instance['wheight'] = (!empty($new_instance['wheight'])) ? strip_tags($new_instance['wheight']) : '';
		$instance['wrnd']    = (!empty($new_instance['wrnd']))    ? strip_tags($new_instance['wrnd'])    : '';
		$instance['waction'] = (!empty($new_instance['waction'])) ? strip_tags($new_instance['waction']) : '';
		$instance['wimgopt'] = (!empty($new_instance['wimgopt'])) ? strip_tags($new_instance['wimgopt']) : '';
		$instance['wembed']  = (!empty($new_instance['wembed']))  ? strip_tags($new_instance['wembed'])  : '';
		$instance['wanim']   = (!empty($new_instance['wanim']))   ? strip_tags($new_instance['wanim'])   : '';
		$instance['wlink']   = (!empty($new_instance['wlink']))   ? strip_tags($new_instance['wlink'])   : '';
		return $instance;
	}

} //Class galdget_widget

function galdget_load_widget() {
	register_widget('galdget_widget');
}
add_action('widgets_init', 'galdget_load_widget');

function galdget_head() {
	echo "<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n";
}
add_action( 'wp_head', 'galdget_head' );

function galdget_load_scripts() {
	wp_enqueue_script('galdget_js',  plugin_dir_url( __FILE__ ) . 'galdget.js', array('jquery'), '1.0', false);
	wp_enqueue_style ('galdget_css', plugin_dir_url( __FILE__ ) . 'galdget.css');
}
add_action( 'wp_enqueue_scripts', 'galdget_load_scripts' );


function galdget_i18n() {
	load_plugin_textdomain( 'galdget_widget', false, dirname(plugin_basename(__FILE__)) . '/languages/');
}
add_action( 'plugins_loaded', 'galdget_i18n' );


function galdget_register_menu() {
	$page = add_options_page(__('Galdget Setup', 'galdget_widget'), 'Galdget', 'administrator', 'galdget-settings', 'galdget_setup_page');
	add_action("load-$page", 'galdget_setup_help');
}
add_action('admin_menu', 'galdget_register_menu');


function galdget_sitefilename() {
	echo preg_replace("/[^A-Za-z0-9\.\-_]/", '_', str_ireplace(array('http://','https://'), '', site_url()));
}


function galdget_setup_page() {
	global $wp_version;
	echo "\n<script type=\"text/javascript\">\n";
	echo "\tvar galdget_confirm_delete1 = " . json_encode(__('Please confirm delete', 'galdget_widget')) . ";\n";
	echo "\tvar galdget_confirm_delete2 = " . json_encode(__('This will delete the whole list, please confirm delete', 'galdget_widget')) . ";\n";
	echo "\tvar galdget_valerrs = "         . json_encode(__('Validation errors:', 'galdget_widget')) . ";\n";
	echo "\tvar galdget_dupls = "           . json_encode(__('Duplicates:', 'galdget_widget')) . ";\n";
	echo "\tvar galdget_skipdupls = "       . json_encode(__('Skip duplicates', 'galdget_widget')) . ";\n";
	echo "\tvar galdget_valerrsexpo = "     . json_encode(__('Setup did not pass validation, please confirm export of faulty data', 'galdget_widget')) . ";\n";
	echo "\tvar galdget_valerrssave = "     . json_encode(__('Setup did not pass validation, please confirm saving faulty data', 'galdget_widget')) . ";\n";
	echo "\tvar galdget_b_append = "        . json_encode(__('Append', 'galdget_widget')) . ";\n";
	echo "\tvar galdget_b_replac = "        . json_encode(__('Replace', 'galdget_widget')) . ";\n";
	echo "\tvar galdget_b_cancel = "        . json_encode(__('Cancel', 'galdget_widget')) . ";\n";
	echo "\tvar galdget_q_quitting = "      . json_encode(__('Changes are not saved, are you sure you want to leave this page?', 'galdget_widget')) . ";\n";
	echo "\tvar galdget_mmgr_title = "      . json_encode(__('Select images for Galdget', 'galdget_widget')) . ";\n";
	echo "\tvar galdget_mmgr_button = "     . json_encode(__('Use selected images', 'galdget_widget')) . ";\n";
	echo "</script>\n";

	echo '<div class="wrap"><h2>'. sprintf(__('%s, URL list setup', 'galdget_widget'), 'Galdget') . ' <span id="galdget_verlang">(wp'.$wp_version.' v'.galdget_version.' '.get_locale(). ')</span></h2>';

	if (!($a  = json_decode(get_option('galdget-urls')))  or (!is_array($a)))		$a  = galdget_default_urls();
	if (!($a1 = json_decode(get_option('galdget-urls1'))) or (!is_array($a1)))		$a1 = galdget_default_urls();
	if (!($a2 = json_decode(get_option('galdget-urls2'))) or (!is_array($a2)))		$a2 = galdget_default_urls();

	$ap = __('Append row','galdget_widget');
	$de = __('Delete row','galdget_widget');

	echo '<table id="galdget_urls"><thead><tr><th>'
		. __('&numero;','galdget_widget') . '</th><th>'
		. __('URL','galdget_widget') . '</th><th>'
		. __('Scalling %<br>(0 to 500)','galdget_widget') . '</th><th>'
		. __('Duration sec.<br>(1 to 600)','galdget_widget') . '</th><th>'
		. __('Group<br>(0...)','galdget_widget') . "</th><th title=\"front.page\r\nhome.page\r\n\r\ncat.category\r\nin.category\r\n\r\ntag.posttag\r\nas.posttag\r\n\r\nmin.0-59\r\n\r\nhour.9-17\r\nhour.11-\r\nhour.-22\r\n-hour.0-11\r\n\r\ndow.1-7\r\ndom.1-31\r\ndoy.1-366\r\nmoy.1-12\r\n-moy.6-8\">"
		. __('Slugs (comma separated)','galdget_widget') . '</th>'
		. '<th onclick="galdget_append(this,\'P\');" title="'. $ap .'"><span class="dashicons dashicons-plus"></span></th>'
		. '<th onclick="galdget_append(this,\'M\');" title="'. __('Delete entire table','galdget_widget') .'"><span class="dashicons dashicons-minus"></span></th></tr></thead><tbody id="galdget_urls_body">';

	for ($i=0; $i<count($a); $i++) {
		$n = count($a[$i]);
		if ($n > 0) {
			echo '<tr><td class="galdget_ordinal" onmousedown="galdget_sorting_i();">'.($i+1).'</td><td><input type="text" size="50" maxlength="2000" value="'.esc_attr(trim($a[$i][0])).'" oninput="galdget_needs_saving();" ondblclick="galdget_preview(this);" onmouseout="galdget_noview();"/></td>';
			echo '<td><input type="number" min="0" max="500" maxlength="3" value="'. ($n>1 ? esc_attr(trim($a[$i][1])) : '40') .'" oninput="galdget_needs_saving();"/></td>';
			echo '<td><input type="number" min="1" max="600" maxlength="3" value="'. ($n>2 ? esc_attr(trim($a[$i][2])) :  '5') .'" oninput="galdget_needs_saving();"/></td>';
			echo '<td><input type="text" size="5" maxlength="400" value="'. ($n>3 ? esc_attr(trim($a[$i][3])) :  '0') .'" oninput="galdget_needs_saving();"/></td>';
			echo '<td><input type="text" size="20" maxlength="1000" value="'. ($n>4 ? esc_attr(trim($a[$i][4])) :  '') .'" oninput="galdget_needs_saving();"/></td>';
			echo '<td onclick="galdget_append(this,\'+\');" title="'.$ap.'"> </td><td onclick="galdget_append(this,\'-\');" title="'.$de.'"> </td>';
			echo '</tr>';
		}
	}
	echo '</tbody></table><br>'; ?>
	<span style="color:red; display:none;" id="galdget_errors"></span>
	<span style="color:blue; display:none;" id="galdget_duplicates"></span>
	<span id="galdget_buttons">
	<input name="galdget_bfrommedia" id="galdget_bfrommedia" class="button button-primary" value="<?php _e('Add images from media library', 'galdget_widget'); ?>" onclick="galdget_addfromlib();" type="submit"><br><br>
	<input name="galdget_bvalidate" id="galdget_bvalidate" class="button button-primary" value="<?php _e('Validate', 'galdget_widget'); ?>" onclick="galdget_validate();" type="submit">&nbsp;
	<input name="galdget_tsv_export"   id="galdget_tsv_export"   class="button button-primary" value="<?php _e('Export to tsv', 'galdget_widget'); ?>" onclick="galdget_download_tsv('<?php galdget_sitefilename(); ?>');" type="submit">&nbsp;
	<?php _e('Import from tsv file:', 'galdget_widget'); ?> <input name="galdget_tsv_import"   id="galdget_tsv_import"   class="button button-primary" value="<?php _e('Import from tsv', 'galdget_widget'); ?>" onchange="galdget_upload_tsv(this);" type="file"><br><br>
	<span id="galdget_need_saving" style="display:none;"></span>
	<input name="submint" class="button button-primary" value="<?php _e('Save', 'galdget_widget'); ?>" onclick="galdget_save();" type="submit"><br><br>
	<input name="galdget_last0" id="galdget_last0" class="button button-primary" value="<?php _e('Load last saved', 'galdget_widget'); ?>" onclick="galdget_loadprev('');" type="submit">&nbsp;
	<input name="galdget_last1" id="galdget_last1" class="button button-primary" value="<?php _e('Load prev. saved', 'galdget_widget'); ?>" onclick="galdget_loadprev('1');" type="submit">&nbsp;
	<input name="galdget_last2" id="galdget_last2" class="button button-primary" value="<?php _e('Load prePrev. saved', 'galdget_widget'); ?>" onclick="galdget_loadprev('2');" type="submit"><br><br>
	</span><img id="galdget_preview_img" style="display:none;"><br><br>
	<form method="post" action="options.php" id="galdget_form" name="galdget_form"><?php
		settings_fields( 'galdget-settings' );
		do_settings_sections( 'galdget-settings' );
		echo '<input type="text" name="galdget-urls" id="galdget-urls" style="display:none;" size="150" value="' . esc_attr( json_encode($a) ) . '"/>';
		echo '<input type="text" name="galdget-urls1" id="galdget-urls1" style="display:none;" size="150" value="' . esc_attr( json_encode($a1) ) . '"/>';
		echo '<input type="text" name="galdget-urls2" id="galdget-urls2" style="display:none;" size="150" value="' . esc_attr( json_encode($a2) ) . '"/>';
	echo '</form></div>';
}


function galdget_setup_help() {
	$screen = get_current_screen();

	$screen->add_help_tab( array(
		'id'      => 'help_overview',
		'title'   => __('Overview', 'galdget_widget'),
		'content' => galdget_help_overview(),
	) );

	$screen->add_help_tab( array(
		'id'      => 'help_slugs',
		'title'   => __('Working with slugs', 'galdget_widget'),
		'content' => galdget_help_slugs(),
	) );

	$screen->add_help_tab( array(
		'id'      => 'help_feedback',
		'title'   => __('Support and feedback', 'galdget_widget'),
		'content' => galdget_help_feedback(),
	) );

}

function galdget_help_filename($n) {
	$l = get_locale();
	$f = __DIR__ .'/help/'.$n.'_'.$l.'.html';
	if (file_exists($f)) return $f;
	$l = substr($l,0,2); $f = __DIR__ .'/help/'.$n.'_'.$l.'.html';
	if (file_exists($f)) return $f;
	$f = __DIR__ .'/help/'.$n.'.html';
	if (file_exists($f)) return $f;
	error_log('Galdget help file '.$n.' unavailable.');
	return false;
}

function galdget_help_overview() {
	$f = galdget_help_filename('page1');
	if ($f)
		return file_get_contents($f);
	else
		return sprintf(__('Local help not available at the moment, please visit <a href="%s">[Galdget]</a>.', 'galdget_widget'), galdget_site_url);
}

function galdget_help_slugs() {
	$f = galdget_help_filename('page2');
	if ($f)
		return file_get_contents($f);
	else
		return sprintf(__('Local help not available at the moment, please visit <a href="%s">[Galdget]</a>.', 'galdget_widget'), galdget_site_url);
}

function galdget_help_feedback() {
	global $wp_version; $h = $wp_version .'_'. galdget_version;
	return "<h3>".__('Send feedback on Galdget', 'galdget_widget')."</h3>".
		__('When you click on one of the links below, please don\'t change the subject of the message, it is used for automatic message classification.', 'galdget_widget')."<ul>".
		"<li><a href=\"mailto:galdget@unforget.rs?subject=Question.$h\">".__('Ask a question', 'galdget_widget')."</a></li>".
		"<li><a href=\"mailto:galdget@unforget.rs?subject=BugReport.$h\">".__('Send bug report', 'galdget_widget')."</a></li>".
		"<li><a href=\"mailto:galdget@unforget.rs?subject=Feedback.$h\">".__('Send feedback', 'galdget_widget')."</a></li></ul>";
}

function galdget_register_settings() {
	register_setting('galdget-version',  'galdget-version');
	register_setting('galdget-settings', 'galdget-urls');
	register_setting('galdget-settings', 'galdget-urls1');
	register_setting('galdget-settings', 'galdget-urls2');
}
add_action('admin_init', 'galdget_register_settings');

function galdget_admin_scripts($hook) {
	if (($hook == 'toplevel_page_galdget-settings') or ($hook == 'settings_page_galdget-settings')) {
		wp_enqueue_style ('galdget_admin_css', plugin_dir_url( __FILE__ ) . 'galdget-admin.css');
		wp_enqueue_script('galdget_admin_js',  plugin_dir_url( __FILE__ ) . 'galdget-admin.js', array('jquery'), '1.0', true);
		wp_enqueue_script('jquery-ui-sortable');
		wp_enqueue_media();
		return;
	}
	if ($hook == 'post.php' or $hook == 'post-new.php') {
		wp_add_inline_script( 'quicktags',  "QTags.addButton('galdget_scdefault', '[Galdget]', '[galdget width=400 height=400 align=center group=0 random=no buttons=none images=fit animation=rnd link=".site_url()." embedded=no]');\n" );
		return;
	}
}
add_action('admin_enqueue_scripts', 'galdget_admin_scripts');

function galdget_sc($atts) {
	global $wp_widget_factory;

	$a = shortcode_atts( array(
		'group'     => '0',
		'align'     => 'center',
		'width'     => '0',
		'height'    => '0',
		'random'    => '0',
		'buttons'   => '3',
		'images'    => '1',
		'embedded'  => '0',
		'animation' => '7',
		'link'      => ''     //site_url()
	), $atts );

	if ($a['width']) {
		$w = $a['width'];
		settype($w,'integer');
		if ($w < 30) $w = 30;
		if ($w > 3000) $w = 3000;
	} else $w = 30;
	$al = 'margin-left: auto; margin-right: auto;';
	if ($a['align'] == 'left') $al = 'margin-left: 0; margin-right: auto;';
	if ($a['align'] == 'right') $al = 'margin-left: auto; margin-right: 0;';

	                                                                                        $instance['title']   = '';
	$z = $a['group'];     settype($z, 'integer'); if ($z<0) $z=0; if ($z>10000) $z=10000;   $instance['group']   = $z;
	$z = $a['height'];    settype($z, 'integer'); if ($z<0) $z=0; if ($z> 3000) $z= 3000;   $instance['wheight'] = $z;
	$z = $a['random'];    if (($i = array_search(strtolower($z), array('yes','true','no','false'))) and ($i<2)) $z = 1;
	                      settype($z, 'integer'); if ($z<>1) $z=0;                          $instance['wrnd']    = $z;
	$z = $a['buttons'];   if ($i = array_search(strtolower($z), array('all','navigation','click','none','nonstop'))) $z = $i;
	                      settype($z, 'integer'); if ($z<0) $z=0; if ($z>4) $z=4;           $instance['waction'] = $z;
	$z = $a['images'];    if ($i = array_search(strtolower($z), array('default','fit','fill','stretch'))) $z = $i;
	                      settype($z, 'integer'); if ($z<0) $z=1; if ($z>3) $z=3;           $instance['wimgopt'] = $z;
	$z = $a['embedded'];  if (($i = array_search(strtolower($z), array('yes','true','no','false'))) and ($i<2)) $z = 1;
	                      settype($z, 'integer'); if ($z<>1) $z=0;                          $instance['wembed']  = $z;
	$z = $a['animation']; if ($i = array_search(strtolower($z), array('fade','left','right','up','down','cw','ccw','random',
	                                                                  'overleft','overright','overup','overdown','overcw','overccw','overrandom'))) $z = $i;
	                      if ($i = array_search(strtolower($z), array('f','l','r','u','d','cw','ccw','rnd','ol','or','ou','od','ocw','occw','ornd'))) $z = $i;
	                      settype($z, 'integer'); if ($z<0) $z=0; if ($z>14) $z=14;         $instance['wanim']  = $z;
	$z = $a['link'];                                                                        $instance['wlink']  = $z;

	$args = array(
		'name' => 'Shortcode on page',
		'id' => 'shortcode_on_page',
		'description' => 'Shortcode on page',
		'class' => '',
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '',
		'after_title' => '',
		'widget_id' => 'galdget_widget-' . rand(1500,9000),
		'widget_name' => 'Images and Sites GW');

    $widget_name = 'galdget_widget';

    ob_start();
    the_widget($widget_name, $instance, $args);
    $R = ob_get_clean();

	if ($w > 0)
		return '<div style="width:'.$w.'px; '.$al.'">' . $R . '</div>';
	else
		return $R;
}
add_shortcode('galdget','galdget_sc'); 

function galdget_slug_sc($atts) {

	$a = shortcode_atts( array('slug' => ''), $atts );

	if ($a['slug'] == 'hour') return current_time('G');
	if ($a['slug'] == 'min' ) return current_time('i');
	if ($a['slug'] == 'dow' ) return current_time('N');
	if ($a['slug'] == 'dom' ) return current_time('j');
	if ($a['slug'] == 'doy' ) return current_time('z')+1;
	if ($a['slug'] == 'moy' ) return current_time('n');
	if ($a['slug'] == 'all' ) return 'doy.'.(current_time('z')+1).' moy.'.current_time('n').' dom.'.current_time('j').' dow.'.current_time('N').' hour.'.current_time('G').' min.'.current_time('i');
}
add_shortcode('galdget_slug','galdget_slug_sc'); 

function galdget_sc_metabox() {
    add_meta_box( 'galdget_sc_metabox', sprintf(__('%s shortcode help', 'galdget_widget' ), '[Galdget]'), 'galdget_sc_metabox2', null, 'side', 'low' );
}
function galdget_sc_metabox2() {
	echo '<b><u>' . __('Allowed parameter values:', 'galdget_widget') . '</u></b>'; ?>
	<ul>
	<li><b>align:</b> <u>center</u> left right</li>
	<li><b>random:</b> <u>no</u> yes</li>
	<li><b>buttons:</b> all navigation click <u>none</u> nonstop</li>
	<li><b>images:</b> default <u>fit</u> fill stretch</li>
	<li><b>animation:</b> fade <u>left</u> right up down cw ccw random overleft overright overup overdown overcw overccw overrandom</li>
	<li><b>animation:</b> f l r u d cw ccw rnd ol or ou od ocw occw ornd</li>
	<li><b>link:</b> <?php echo site_url().', '.__('valid URL', 'galdget_widget'); ?></li>
	<li><b>embedded:</b> <u>no</u> yes</li>
	</ul><hr><?php
	printf(__( 'Please visit %s for detailed instructions.', 'galdget_widget' ), '<a href="'.galdget_site_url.'">[Galdget]</a>');
}
add_action( 'add_meta_boxes', 'galdget_sc_metabox' );

?>
