function galdget_append(D,O) { try {
	var P = document.getElementById('galdget_urls_body');

	switch(O) {
		case 'M':
			if (P.rows.length <= 1) return;
			if (!confirm(galdget_confirm_delete2)) return;
			for (i = P.rows.length-1; i>0; i--)
				P.deleteRow(i);
			galdget_emptyrow(P.rows[0]);
			break;
		case 'P':
			P.insertBefore(P.rows[0].cloneNode(true), P.rows[0]);
			galdget_emptyrow(P.rows[0]);
			P.rows[0].cells[1].children[0].focus();
			break;
		case '-':
			if (!confirm(galdget_confirm_delete1)) return;
			if (P.rows.length==1)
				galdget_emptyrow(P.rows[0]);
			else
				D.parentNode.parentNode.removeChild(D.parentNode);
			break;
		case '+':
			n = D.parentNode.rowIndex;
			if (n < P.rows.length)
				P.insertBefore(P.rows[0].cloneNode(true), P.rows[n]);
			else {
				n = P.rows.length;
				P.appendChild(P.rows[0].cloneNode(true));
			}
			galdget_emptyrow(P.rows[n]);
			P.rows[n].cells[1].children[0].focus();
			break;
	}

	for (i=0; i < P.rows.length; i++)
		P.rows[i].cells[0].innerHTML = i+1;

	galdget_validate();
	galdget_needs_saving();
	galdget_sorting_r();
} catch(e) { console.log('galdget_append: '+e.message); }}

function galdget_emptyrow(R) {
	R.cells[1].children[0].value ='';
	R.cells[2].children[0].value ='40';
	R.cells[3].children[0].value ='5';
	R.cells[4].children[0].value ='0';
	R.cells[5].children[0].value ='';
}

var galdget_rel = new RegExp(/^(http|https|dir):\/\/[a-zA-Z0-9]/i),
	galdget_res = new RegExp(/^([a-z0-9,.\-_])*$/),
	galdget_reg = new RegExp(/^(\d{1,4}(,\d{1,4})*)?$/),
	galdget_img = new RegExp(/(^http(s)?:\/\/)[a-zA-Z0-9].*\.(?:png|jp(e)?g|gif|bmp)$/i);

function galdget_validate() { try {
	var x = 0;
	var y = 0;
	var P = document.getElementById('galdget_urls_body');
	if (P == null) { alert('Galdget is down!'); return (1); }

	var R, C, v, f;

	for (R=0; R < P.rows.length; R++) {
		C = P.rows[R].cells[1];		v = C.children[0].value;
		if ((v.length<7) || (!v.match(galdget_rel))) {
			C.style.background = 'red';
			x++;
		} else C.style.background = 'transparent';

		C = P.rows[R].cells[2];		v = C.children[0].value;
		f = parseFloat(v);
		if ((v.length==0) || (isNaN(f)) || (f != Math.floor(f)) || (f<0) || (f>500)) {
			C.style.background = 'red';
			x++;
		} else C.style.background = 'transparent';

		C = P.rows[R].cells[3];		v = C.children[0].value;
		f = parseFloat(v);
		if ((v.length==0) || (isNaN(f)) || (f != Math.floor(f)) || (f<1) || (f>600)) {
			C.style.background = 'red';
			x++;
		} else C.style.background = 'transparent';

		C = P.rows[R].cells[4];		v = C.children[0].value;
		if ((v.length==0) || (!v.match(galdget_reg))) {
			C.style.background = 'red';
			x++;
		} else C.style.background = 'transparent';

		C = P.rows[R].cells[5];		v = C.children[0].value;
		if ((v.length>0) && (!v.match(galdget_res))) {
			C.style.background = 'red';
			x++;
		} else C.style.background = 'transparent';

		P.rows[R].cells[0].style.background = '';
		P.rows[R].cells[0].style.color = '';
	}

	for (R=0; R < P.rows.length-1; R++)
		if (P.rows[R].cells[0].style.color == '') {
			for (C=R+1; C < P.rows.length; C++)
				if (P.rows[R].cells[1].children[0].value == P.rows[C].cells[1].children[0].value) {
					P.rows[R].cells[0].style.background = 'rgb(179,179,255)';
					P.rows[C].cells[0].style.background = 'blue';
					P.rows[C].cells[0].style.color = 'white';
					y++;
				}
		}

	C = document.getElementById('galdget_errors');
	if (x > 0) {
		C.innerHTML = galdget_valerrs+' '+x+'<br>';
		C.style.display = 'block';
	} else C.style.display = 'none';
	C = document.getElementById('galdget_duplicates');
	if (y > 0) {
		C.innerHTML = galdget_dupls+' '+y+'<br>';
		C.style.display = 'block';
	} else C.style.display = 'none';

	return (x);
} catch(e) { console.log('galdget_validate: '+e.message); return(1); }}


function galdget_download(filename, textvar) { try {
	var tekst = textvar;
	tekst = tekst.replace(/\r\n|\n|\r/g,"\r\n") + "\r\n";
	var element = document.createElement("a");

	var blob = new Blob([tekst], {encoding: "UTF-8", type: "text/plain"});
	if(window.navigator.msSaveOrOpenBlob) {
		window.navigator.msSaveBlob(blob, filename);
		return;
	}

	element.setAttribute("href", "data:text/plain;charset=utf-8," + encodeURIComponent(tekst));
	element.setAttribute("download", filename);

	element.style.display = "none";
	document.body.appendChild(element);

	if (document.createEvent) {
		var event = document.createEvent("MouseEvents");
		event.initEvent("click", true, true);
		element.dispatchEvent(event);
	}
	else element.click();

	document.body.removeChild(element);
} catch(e) { console.log('galdget_download: '+e.message); return(1); }}


function galdget_encode_tsv() { try {
	var P = document.getElementById('galdget_urls_body');
	var R;
	var v = '';

	for (R=0; R < P.rows.length; R++) {
		v = v 	+ P.rows[R].cells[1].children[0].value + '\t'
				+ P.rows[R].cells[2].children[0].value + '\t'
				+ P.rows[R].cells[3].children[0].value + '\t'
				+ P.rows[R].cells[4].children[0].value + '\t'
				+ P.rows[R].cells[5].children[0].value + '\r\n'; 
	}

	return (v);
} catch(e) { console.log('galdget_encode_tsv: '+e.message); return(1); }}


function galdget_download_tsv(u) { try {
	if ((galdget_validate() > 0) && (!confirm(galdget_valerrsexpo))) return;

	var d = new Date();
	var f = u + '_' +
			d.getFullYear() +
			('00' + (d.getMonth() + 1)).slice(-2) +
			('00' + d.getDate()).slice(-2) + '_' + 
			('00' + d.getHours()).slice(-2) +
			('00' + d.getMinutes()).slice(-2) +
			('00' + d.getSeconds()).slice(-2);

	var tsv = galdget_encode_tsv();
	galdget_download('Galdget_backup_'+f+'.tsv', tsv);
} catch(e) { console.log('galdget_download_tsv: '+e.message); }}

function galdget_upload_tsv(e) { try {
	galdget_cancel();
	var file = e.files[0];
	var reader = new FileReader();

	reader.onload = function(e) { galdget_parse_tsv(reader.result); };
	reader.readAsText(file);	
} catch(e) { alert('galdget_upload_tsv: '+e.message); }}


var galdget_moved = null,
	galdget_x = 0,
	galdget_y = 0;

function galdget_parse_tsv(tsv) { try {
	galdget_cancel();
	var T  = document.getElementById('galdget_urls');
	var P  = T.parentElement;
	var i,j;
	var mh = document.getElementById('wpwrap').clientHeight-120;
	if (mh == null) mh = 600;

	D = document.createElement('div');
	D.style.position = 'absolute';
	D.style.top  = (T.offsetTop +20) + 'px';
	D.style.left = (T.offsetLeft+20) + 'px';
	D.style.maxHeight = Math.max(mh,(P.clientHeight-40)) + 'px';
	D.setAttribute('id', 'galdget_loaded');
	P.appendChild(D);

	var S = document.createElement('table');
	S.setAttribute('id', 'galdget_loaded_table');
	var R = S.insertRow(0);
	for (i=0; i<6; i++)
		R.appendChild(T.rows[0].cells[i].cloneNode(true));

	P = document.getElementById('galdget_urls');
	var L = tsv.split(/\r?\n/);
	var C, Rc;
	var x = 0;
	var y = 0;
	var z;

	j=1;
	for (i=0; i<L.length; i++) {
		C = L[i].split(/\t/);
		if (C[0].length > 10) {
			C[0] = C[0].substring(0,2000);
			R = S.insertRow(j);
			Rc = R.insertCell(0); Rc.innerHTML = j++;

			Rc = R.insertCell(1); Rc.innerHTML = '<input type="text" size="50" maxlength="2000" value=""/>'; Rc.children[0].value = C[0]; Rc.children[0].readOnly = true;
			if ((C[0].length<10) || (!C[0].match(galdget_rel))) { Rc.style.background = 'red'; x++; }
			z = 0;
			do {
				z++;
			} while ((z < P.rows.length) && ((P.rows[z].cells[1]==null) || (P.rows[z].cells[1].children[0].value != C[0])));
			if (z < P.rows.length) {
				R.cells[0].style.background = 'blue';
				R.cells[0].style.color = 'white';
				y++;
			}

			Rc = R.insertCell(2); if (C.length>1) Rc.innerHTML = C[1];
			f = parseFloat(Rc.innerHTML);
			if ((Rc.innerHTML.length==0) || (isNaN(f)) || (f != Math.floor(f)) || (f<0) || (f>500)) { Rc.style.background = 'red'; x++; }

			Rc = R.insertCell(3); if (C.length>2) Rc.innerHTML = C[2];
			f = parseFloat(Rc.innerHTML);
			if ((Rc.innerHTML.length==0) || (isNaN(f)) || (f != Math.floor(f)) || (f<1) || (f>600)) { Rc.style.background = 'red'; x++; }

			Rc = R.insertCell(4); if (C.length>3) Rc.innerHTML = C[3];
			if ((Rc.innerHTML.length==0) || (!Rc.innerHTML.match(galdget_reg))) { Rc.style.background = 'red'; x++; }

			Rc = R.insertCell(5); Rc.innerHTML = '<input type="text" size="20" maxlength="1000" value=""/>'; Rc.children[0].readOnly = true;
			if (C.length>4) Rc.children[0].value = C[4].substring(0,1000);
			if ((Rc.children[0].value.length>0) && (!Rc.children[0].value.match(galdget_res))) { Rc.style.background = 'red'; x++; }
		}
	}

	D.appendChild(S);
	D.appendChild(document.createElement('br'));
	Rc = document.createElement('div');
	Rc.id = 'galdget_loaded2';
	if (x>0) Rc.innerHTML  = '<span style="color:red;">'+galdget_valerrs+' '+x+'</span><br>';
	if (y>0) {
		Rc.innerHTML += 
			'<span style="color:blue;">'+galdget_dupls+' '+y+'</span><br>' +
			'<label for="galdget_input_duplicates">'+galdget_skipdupls+'</label>' +
			'<input	class="widefat, checkbox" id="galdget_input_duplicates" name="galdget_input_duplicates" type="checkbox" checked/><br>';
	}
	Rc.innerHTML +=
		'<input name="galdget_input_append"  id="galdget_input_append"  class="button button-primary" value="'+galdget_b_append+'" onclick="galdget_import();"  type="submit">&nbsp;' +
		'<input name="galdget_input_replace" id="galdget_input_replace" class="button button-primary" value="'+galdget_b_replac+'" onclick="galdget_replace();" type="submit">&nbsp;' +
		'<input name="galdget_input_cancel"  id="galdget_input_cancel"  class="button button-primary" value="'+galdget_b_cancel+'" onclick="galdget_cancel();"  type="submit">';

	D.appendChild(Rc);

	D.addEventListener('mousedown',  galdget_move1, true);
	D.addEventListener('touchstart', galdget_move1, true);
	document.addEventListener('mouseup', galdget_m_up, true);

	if ((D.clientHeight+50)<T.clientHeight) D.style.top  = (T.offsetTop+10+T.clientHeight-D.clientHeight) + 'px';
} catch(e) { console.log('galdget_parse_tsv: '+e.message); }}

function galdget_move1(e) { try {
	if ((e.target.id != 'galdget_loaded') || (e.clientX-e.target.getBoundingClientRect().left > e.target.clientWidth)) {
		galdget_moved = null;
		window.removeEventListener('mousemove', galdget_drag, true);
		window.removeEventListener('touchmove', galdget_drag, true);
		return;
	}
	e.preventDefault();
	e.stopPropagation();

	galdget_moved = e.target;

	if (e.type == 'mousedown') {
		galdget_x = e.clientX - galdget_loaded.offsetLeft;
		galdget_y = e.clientY - galdget_loaded.offsetTop;
		window.addEventListener('mousemove', galdget_drag, true);
	} else if (e.type == 'touchstart') {
		galdget_x = e.targetTouches[0].clientX - galdget_loaded.offsetLeft;
		galdget_y = e.targetTouches[0].clientY - galdget_loaded.offsetTop;
		window.addEventListener('touchmove', galdget_drag, true);
	}
} catch(e) { console.log('galdget_move1: '+e.message); }}

function galdget_drag(e) { try {
	e.preventDefault();
	e.stopPropagation();

	if (galdget_moved == null) return;
	if (e.type == 'mousemove') {
		galdget_moved.style.left = (e.clientX-galdget_x) + "px";
		galdget_moved.style.top  = (e.clientY-galdget_y) + "px";
	} else if (e.type == 'touchmove') {
		galdget_moved.style.left = (e.targetTouches[0].clientX-galdget_x) + "px";
		galdget_moved.style.top  = (e.targetTouches[0].clientY-galdget_y) + "px";
	}
} catch(e) { console.log('galdget_drag: '+e.message); }}

function galdget_m_up(e) { try {
	if (galdget_moved) {
		galdget_moved = null;
		window.removeEventListener('mousemove', galdget_drag, true);
		window.removeEventListener('touchmove', galdget_drag, true);
	}
} catch(e) { console.log('galdget_m_up: '+e.message); }}

function galdget_cancel() { try {
	var P = document.getElementById('galdget_loaded');
	if (P) P.parentNode.removeChild(P);
	window.removeEventListener('mousemove', galdget_drag, true);
	window.removeEventListener('touchmove', galdget_drag, true);
} catch(e) { console.log('galdget_cancel: '+e.message); }}

function galdget_import(ssd) { try {
	var P  = document.getElementById('galdget_loaded'),
		S  = document.getElementById('galdget_loaded_table'),
		D  = document.getElementById('galdget_urls_body'),
		C, sd;
	if (ssd) sd = false;
	else {
		sd = document.getElementById('galdget_input_duplicates');
		if (sd == null) sd = true; else sd = document.getElementById('galdget_input_duplicates').checked;
	}

	var j = D.rows.length, R;
	for (var i=1; i<S.rows.length; i++)
		if ((S.rows[i].cells[0].style.background == '') || (!sd)) {
			D.appendChild(D.rows[0].cloneNode(true));
			R = D.rows[j];
			R.cells[0].innerHTML = ++j;
			R.cells[1].children[0].value = S.rows[i].cells[1].children[0].value;
			R.cells[2].children[0].value = S.rows[i].cells[2].innerHTML;
			R.cells[3].children[0].value = S.rows[i].cells[3].innerHTML;
			R.cells[4].children[0].value = S.rows[i].cells[4].innerHTML;
			R.cells[5].children[0].value = S.rows[i].cells[5].children[0].value;
		}

	P.parentNode.removeChild(P);
	window.removeEventListener('mousemove', galdget_drag, true);
	window.removeEventListener('touchmove', galdget_drag, true);

	galdget_validate();
	galdget_needs_saving();
	galdget_sorting_r();
} catch(e) { console.log('galdget_import: '+e.message); }}

function galdget_replace() { try {
	var D  = document.getElementById('galdget_urls_body');
	var j = D.rows.length;
	var i;
	galdget_import(true);

	for (i=0; i<j; i++)
		D.deleteRow(0);

	for (i=0; i < D.rows.length; i++)
		D.rows[i].cells[0].innerHTML = i+1;

	galdget_validate();
	galdget_needs_saving();
	galdget_sorting_r();
} catch(e) { console.log('galdget_replace: '+e.message); }}

function galdget_save() { try {
	galdget_cancel();
	if ((galdget_validate() > 0) && (!confirm(galdget_valerrssave))) return;

	var P = document.getElementById('galdget_urls_body');
	var R;
	var v = [];

	for (R=0; R < P.rows.length; R++) {
		v[R] = new Array();
		v[R].push(P.rows[R].cells[1].children[0].value.trim());
		v[R].push(parseInt(P.rows[R].cells[2].children[0].value));
		v[R].push(parseInt(P.rows[R].cells[3].children[0].value));
		v[R].push(P.rows[R].cells[4].children[0].value.trim());
		v[R].push(P.rows[R].cells[5].children[0].value.trim());
	}
	R = JSON.stringify(v);

	var u0 = document.getElementById('galdget-urls');
	var u1 = document.getElementById('galdget-urls1');
	var u2 = document.getElementById('galdget-urls2');

	u2.value = u1.value;
	u1.value = u0.value;
	u0.value = R;

	document.getElementById('galdget_need_saving').style.display = 'none';
	document.getElementById('galdget_form').submit();
} catch(e) { console.log('galdget_save: '+e.message); }}


function galdget_loadprev(n) { try {
	var v = JSON.parse(document.getElementById('galdget-urls'+n).value);
	var tsv = '', i,j;
	for (i in v) {
		if (v[i].length > 0) tsv = tsv + v[i][0] + '\t'; else tsv = tsv + '\t';
		if (v[i].length > 1) tsv = tsv + v[i][1] + '\t'; else tsv = tsv + '\t';
		if (v[i].length > 2) tsv = tsv + v[i][2] + '\t'; else tsv = tsv + '\t';
		if (v[i].length > 3) tsv = tsv + v[i][3] + '\t'; else tsv = tsv + '\t';
		if (v[i].length > 4) tsv = tsv + v[i][4] + '\n'; else tsv = tsv + '\n';
	}
	galdget_parse_tsv(tsv);
} catch(e) { console.log('galdget_loadprev: '+e.message); }}


if(window.addEventListener) {
	window.addEventListener('load', galdget_sorting_i);
	window.addEventListener('load', galdget_validate);
	window.addEventListener('beforeunload', galdget_quitting);
} else {
	window.attachEvent('onload', galdget_sorting_i);
	window.attachEvent('onload', galdget_validate);
	window.attachEvent('onbeforeunload', galdget_quitting);
}

function galdget_needs_saving() { try {
	document.getElementById('galdget_need_saving').style.display = 'inline';
} catch(e) { console.log('galdget_needs_saving: '+e.message); }}

function galdget_quitting(e) { try {
	if (document.getElementById('galdget_need_saving').style.display == 'inline') {
		(e || window.event).returnValue = galdget_q_quitting;
		return galdget_q_quitting;
	}
} catch(e) { console.log('galdget_quitting: '+e.message); }}


var galdget_sorting1 = function(e, tr) {
	var tds = tr.children();
	var trc = tr.clone();
	trc.children().each(function(index) {
		jQuery(this).width(tds.eq(index).width())
	});
	return trc;
},
	galdget_sorting0 = function(e, ui) {
		jQuery('td.galdget_ordinal', ui.item.parent()).each(function (i) { jQuery(this).html(i+1); });
		galdget_needs_saving();
	};
function galdget_sorting_i() {
	var t = jQuery("#galdget_urls_body");
	if (!t.hasClass('ui-sortable'))
		t.sortable({ helper: galdget_sorting1, stop: galdget_sorting0 }).disableSelection();
}
function galdget_sorting_r() {
	var t = jQuery("#galdget_urls_body");
	if (t.hasClass('ui-sortable'))
		try { t.sortable('destroy'); } catch(e) { console.log('galdget_sorting_r '+e.message); };
	galdget_sorting_i();
}


var galdget_mmgr;
function galdget_addfromlib() { try {
	if (galdget_mmgr) {
		galdget_mmgr.open();
		return;
	}
	galdget_mmgr = wp.media.frames.file_frame = wp.media({ title: galdget_mmgr_title, button: { text: galdget_mmgr_button }, multiple: true });
	galdget_mmgr.on( 'select', function() {
		galdget_mmgr.state().get('selection').forEach(function(a){ galdget_addmmgrurl(a.toJSON().url); });
		galdget_validate();
	});
	galdget_mmgr.open();
} catch(e) { console.log('galdget_addfromlib: '+e.message); }}

function galdget_addmmgrurl(u) { try {
	var T;
	if (!(T = document.getElementById('galdget_urls'))) return;
	var n = T.rows.length;
	galdget_append(T.rows[n-1].cells[1],'+');
	T.rows[n].cells[1].children[0].value = u;
} catch(e) { console.log('galdget_addmmgrurl: '+e.message); }}

function galdget_preview(u) { try {
	if (!u.value.match(galdget_img)) return;
	var I = document.getElementById('galdget_preview_img');
	I.src='';
	I.style.display="block";
	I.src=u.value;
	var R = u.getBoundingClientRect();
	I.style.position = 'fixed';
	I.style.top = (R.bottom+10) + 'px';
	I.style.left = (R.left+10) + 'px';
} catch(e) { console.log('galdget_preview: '+e.message); }}
function galdget_noview() { try {
	document.getElementById('galdget_preview_img').style.display="none";
} catch(e) { console.log('galdget_preview: '+e.message); }}
