<?php
/**
 * Fuzion - Write. Create. Dream. AI.
 *
 * Main plugin file for the Fuzion plugin. Initializes all required constants, all install and uninstall hooks,
 * loads the plugin code.
 *
 * @link              https://getfuzion.io
 * @since             1.0.0
 * @package           Fuzion
 *
 * @wordpress-plugin
 * Plugin Name:       Fuzion
 * Plugin URI:        https://wp.org/plugins/fuzion
 * Description:       Take your content writing to the next level with the Fuzion plugin. Write. Create. Dream. AI.
 * Version:           1.4.1
 * Author:            Fuzion AI
 * Author URI:        https://getfuzion.io
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       fuzion
 * Domain Path:       /languages
 */

namespace Fuzion;

if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'FUZION_VERSION', '1.4.1' );
define( 'FUZION_DIR_URL', plugin_dir_url( __FILE__ ) );

require_once __DIR__ . '/app/class-update.php';
require_once __DIR__ . '/app/class-core.php';
register_activation_hook( __FILE__, array( 'Fuzion\App\Core', 'activate' ) );

/**
 * Begin execution of the plugin.
 *
 * @since 1.0.0
 *
 * @return void
 */
function run_fuzion() {

	App\Update::do_upgrade();
	App\Core::get_instance();

}
run_fuzion();
