/**
 * Various helper functions.
 *
 * @since 1.0.0
 */

/* global Fuzion */

'use strict';

/**
 * Get strings from localized object.
 *
 * @param {string} str
 * @return {*|string} String
 */
export const getString = ( str ) => {
	return Fuzion.string[ str ] || '';
};

/**
 * Get link from localized object.
 *
 * @param {string} str
 * @return {*|string} String
 */
export const getLink = ( str ) => {
	return Fuzion.links[ str ] || '';
};
