/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';
import { code, more, postContent, formatListNumbered, alignJustify, heading, title, page } from '@wordpress/icons';

/**
 * Set of generation elements.
 *
 * @type {Object}
 */
export const contentActions = {
	title: {
		help: __( 'Enter a topic', 'fuzion' ),
		name: __( 'Article title', 'fuzion' ),
		placeholder: __( 'Article of the day', 'fuzion' ),
		description: __( 'Generate a title or an idea from a topic or list of keywords.', 'fuzion' ),
		icon: title
	},
	heading: {
		help: __( 'Enter a topic', 'fuzion' ),
		name: __( 'Heading or idea', 'fuzion' ),
		placeholder: __( 'Remote work', 'fuzion' ),
		description: __( 'Generate a heading or an idea from a topic or list of keywords.', 'fuzion' ),
		icon: heading
	},
	intro: {
		help: __( 'Enter a topic', 'fuzion' ),
		name: __( 'Introduction', 'fuzion' ),
		placeholder: __( 'What is the importance of climate change', 'fuzion' ),
		description: __( 'Write powerful introductions based on keywords or expand on a provided subject.', 'fuzion' ),
		icon: postContent
	},
	expand: {
		help: __( 'Enter text', 'fuzion' ),
		name: __( 'Expand text', 'fuzion' ),
		placeholder: __( 'SEO is important for a website', 'fuzion' ),
		description: __( 'Expand your thoughts and ideas from text into full blown paragraphs.', 'fuzion' ),
		icon: more
	},
	list: {
		help: __( 'Enter a topic', 'fuzion' ),
		name: __( 'List creation', 'fuzion' ),
		placeholder: __( '10 book titles', 'fuzion' ),
		description: __( 'Create lists of items for given topics or keywords.', 'fuzion' ),
		icon: formatListNumbered
	},
	outline: {
		help: __( 'Enter a topic', 'fuzion' ),
		name: __( 'Outline', 'fuzion' ),
		placeholder: __( '5 tips for better health', 'fuzion' ),
		description: __( 'Write outlines that cover any topic or keyword combination.', 'fuzion' ),
		icon: alignJustify
	},
	tldr: {
		help: __( 'Enter text', 'fuzion' ),
		name: __( 'TL;DR summarization', 'fuzion' ),
		placeholder: __( 'Input text to summarize', 'fuzion' ),
		description: __( 'Summarize a block of text.', 'fuzion' ),
		icon: page
	},
	code_generate: {
		help: __( 'Try to provide as much specifics as possible: such as language, variables, what should be returned, etc. To avoid truncated results, it is recommended to set the credits to 250-300.', 'fuzion' ),
		name: __( 'Generate code (beta)', 'fuzion' ),
		placeholder: __( 'Create a function using PHP that adds two numbers and returns the result', 'fuzion' ),
		description: __( 'Generate code from a text prompt.', 'fuzion' ),
		icon: code
	}
};
